/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.network.server.packet.endercalamity;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import team.cqr.cqrepoured.entity.boss.endercalamity.EntityCQREnderCalamity;

public class SPacketCalamityUpdateHand
implements IMessage {
    private int entityId;
    private byte[] handStates = new byte[6];

    public SPacketCalamityUpdateHand() {
    }

    SPacketCalamityUpdateHand(Builder builder) {
        this.entityId = builder.getEntityID();
        for (int i = 0; i < builder.getStates().length; ++i) {
            this.handStates[i] = builder.getStates()[i];
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        buf.readBytes(this.handStates);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeBytes(this.handStates);
    }

    public byte[] getHandStates() {
        return this.handStates;
    }

    public static Builder builder(EntityCQREnderCalamity entity) {
        return new Builder(entity);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public static class Builder {
        private int entityID;
        private byte[] states = new byte[]{0, 0, 0, 0, 0, 0};

        private Builder(EntityCQREnderCalamity entity) {
            this.entityID = entity.func_145782_y();
        }

        public Builder swingArm(EntityCQREnderCalamity.E_CALAMITY_HAND hand, boolean swinging) {
            this.states[hand.getIndex()] = (byte)(swinging ? 1 : 0);
            return this;
        }

        byte[] getStates() {
            return this.states;
        }

        int getEntityID() {
            return this.entityID;
        }

        @Nullable
        public SPacketCalamityUpdateHand build() {
            try {
                return new SPacketCalamityUpdateHand(this);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }
}

