/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.network.datasync;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagLong;
import team.cqr.cqrepoured.network.datasync.DataEntry;

public class DataEntryLong
extends DataEntry<Long> {
    private long value;

    public DataEntryLong(String name, long defaultValue, boolean isClientModificationAllowed) {
        super(name, isClientModificationAllowed);
        this.value = defaultValue;
    }

    @Override
    public NBTBase write() {
        return new NBTTagLong(this.value);
    }

    @Override
    protected void readInternal(NBTBase nbt) {
        if (nbt instanceof NBTTagLong) {
            this.value = ((NBTTagLong)nbt).func_150291_c();
        }
    }

    @Override
    public void writeChanges(ByteBuf buf) {
        buf.writeLong(this.value);
    }

    @Override
    protected void readChangesInternal(ByteBuf buf) {
        this.value = buf.readLong();
    }

    @Override
    @Deprecated
    public void set(@Nonnull Long value) {
        if (value == null) {
            return;
        }
        this.set(value);
    }

    @Override
    @Deprecated
    protected void setInternal(@Nonnull Long value) {
        if (value == null) {
            return;
        }
        this.setInternal(value);
    }

    @Override
    @Deprecated
    public boolean isSavedValueEqualTo(Long value) {
        return this.isSavedValueEqualTo(value);
    }

    @Override
    @Deprecated
    public Long get() {
        return this.getLong();
    }

    @Override
    public void set(long value) {
        if (!this.isSavedValueEqualTo(value)) {
            this.setInternal(value);
            this.onValueChanged();
            this.markDirty();
        }
    }

    @Override
    protected void setInternal(long value) {
        this.value = value;
    }

    @Override
    public boolean isSavedValueEqualTo(long value) {
        return this.value == value;
    }

    public long getLong() {
        return this.value;
    }
}

