/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.item.staff;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import team.cqr.cqrepoured.entity.misc.EntityColoredLightningBolt;
import team.cqr.cqrepoured.init.CQRSounds;
import team.cqr.cqrepoured.item.IRangedWeapon;

public class ItemStaffThunder
extends Item
implements IRangedWeapon {
    public ItemStaffThunder() {
        this.func_77656_e(2048);
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (this.isNotAirBlock(worldIn, playerIn)) {
            if (!worldIn.field_72995_K) {
                playerIn.func_184609_a(handIn);
                this.spawnLightningBolt(playerIn, worldIn);
                stack.func_77972_a(1, (EntityLivingBase)playerIn);
                playerIn.func_184811_cZ().func_185145_a(stack.func_77973_b(), 20);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public void spawnLightningBolt(EntityPlayer player, World worldIn) {
        Vec3d end;
        Vec3d start;
        RayTraceResult result;
        if (!worldIn.field_72995_K && (result = worldIn.func_72933_a(start = player.func_174824_e(1.0f), end = start.func_178787_e(player.func_70040_Z().func_186678_a(20.0)))) != null) {
            EntityColoredLightningBolt entity = new EntityColoredLightningBolt(worldIn, result.field_72307_f.field_72450_a, result.field_72307_f.field_72448_b, result.field_72307_f.field_72449_c, true, false);
            worldIn.func_72838_d((Entity)entity);
        }
    }

    public boolean isNotAirBlock(World worldIn, EntityPlayer player) {
        Vec3d end;
        Vec3d start = player.func_174824_e(1.0f);
        RayTraceResult result = worldIn.func_72933_a(start, end = start.func_178787_e(player.func_70040_Z().func_186678_a(20.0)));
        return result != null && !worldIn.func_175623_d(result.func_178782_a());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.staff_thunder.name", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.click_shift.name", (Object[])new Object[0]));
        }
    }

    @Override
    public void shoot(World worldIn, EntityLivingBase shooter, Entity target, EnumHand handIn) {
        Vec3d v = target.func_174791_d().func_178788_d(shooter.func_174791_d());
        Vec3d pos = target.func_174791_d();
        if (v.func_72433_c() > 20.0) {
            v = v.func_72432_b();
            v = v.func_186678_a(20.0);
            pos = shooter.func_174791_d().func_178787_e(v);
        }
        EntityColoredLightningBolt entity = new EntityColoredLightningBolt(worldIn, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, true, false);
        worldIn.func_72838_d((Entity)entity);
    }

    @Override
    public SoundEvent getShootSound() {
        return CQRSounds.MAGIC;
    }

    @Override
    public double getRange() {
        return 32.0;
    }

    @Override
    public int getCooldown() {
        return 80;
    }

    @Override
    public int getChargeTicks() {
        return 0;
    }
}

