/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.item.spear;

import com.google.common.base.Predicate;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.init.CQRPotions;
import team.cqr.cqrepoured.item.sword.ItemCQRWeapon;
import team.cqr.cqrepoured.util.ItemUtil;

public class ItemSpearBase
extends ItemCQRWeapon {
    private static final UUID REACH_DISTANCE_MODIFIER = UUID.fromString("95dd73a8-c715-42f9-8f6d-abf5e40fa3cd");
    private static final float SPECIAL_REACH_MULTIPLIER = 1.5f;
    private final double reachDistanceBonus;

    public ItemSpearBase(Item.ToolMaterial material) {
        super(material, CQRConfig.materials.toolMaterials.spearAttackDamageBonus, CQRConfig.materials.toolMaterials.spearAttackSpeedBonus);
        this.reachDistanceBonus = CQRConfig.materials.toolMaterials.spearReachDistanceBonus;
    }

    public double getReach() {
        return this.reachDistanceBonus;
    }

    public double getReachExtended() {
        return this.reachDistanceBonus * 1.5;
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        ItemUtil.attackTarget(stack, player, entity, false, 0.0f, 1.0f, true, 1.0f, 0.0f, 0.25, 0.25, 0.2f);
        return true;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap<String, AttributeModifier> multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)EntityPlayer.REACH_DISTANCE.func_111108_a(), (Object)new AttributeModifier(REACH_DISTANCE_MODIFIER, "Weapon modifier", this.reachDistanceBonus, 0));
        }
        return multimap;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            if (!worldIn.field_72995_K) {
                Vec3d vec1 = player.func_174824_e(1.0f);
                Vec3d vec2 = player.func_70040_Z();
                double reachDistance = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
                float charge = Math.min((float)player.func_184612_cw() / 40.0f, 1.0f);
                for (EntityLivingBase entityLivingBase : this.getEntities(worldIn, EntityLivingBase.class, player, vec1, vec2, reachDistance, null)) {
                    entityLivingBase.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), (1.0f + this.func_150931_i()) * charge);
                }
                Vec3d vec3 = vec1.func_178787_e(new Vec3d(0.0, -0.5, 0.0).func_178789_a((float)Math.toRadians(-player.field_70125_A))).func_178787_e(new Vec3d(-0.4, 0.0, 0.0).func_178785_b((float)Math.toRadians(-player.field_70177_z)));
                for (double d = reachDistance; d >= 0.0; d -= 1.0) {
                    Vec3d vec4 = vec3.func_178787_e(vec2.func_186678_a(d));
                    ((WorldServer)worldIn).func_175739_a(EnumParticleTypes.SMOKE_NORMAL, vec4.field_72450_a, vec4.field_72448_b, vec4.field_72449_c, 1, 0.05, 0.05, 0.05, 0.0, new int[0]);
                }
                player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187721_dT, player.func_184176_by(), 1.0f, 1.0f);
                player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 200);
            } else {
                player.func_184609_a(EnumHand.MAIN_HAND);
            }
        }
    }

    private <T extends Entity> List<T> getEntities(World world, Class<T> entityClass, @Nullable T toIgnore, Vec3d vec1, Vec3d vec2, double range, @Nullable Predicate<T> predicate) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        Vec3d vec3 = vec1.func_178787_e(vec2.func_72432_b().func_186678_a(range));
        RayTraceResult rayTraceResult1 = world.func_147447_a(vec1, vec3, false, true, false);
        Vec3d vec4 = rayTraceResult1 != null ? rayTraceResult1.field_72307_f : vec3;
        AxisAlignedBB aabb1 = new AxisAlignedBB(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, vec4.field_72450_a, vec4.field_72448_b, vec4.field_72449_c);
        for (Entity entity : world.func_175647_a(entityClass, aabb1, predicate)) {
            AxisAlignedBB aabb2;
            RayTraceResult rayTraceResult2;
            if (entity == toIgnore || (rayTraceResult2 = (aabb2 = entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y())).func_72327_a(vec1, vec4)) == null) continue;
            list.add(entity);
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.spear_diamond.name", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.click_shift.name", (Object[])new Object[0]));
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!(entityIn instanceof EntityLivingBase)) {
            return;
        }
        if (!isSelected) {
            return;
        }
        EntityLivingBase entityLiving = (EntityLivingBase)entityIn;
        ItemStack offhand = entityLiving.func_184592_cb();
        if (!offhand.func_190926_b()) {
            entityLiving.func_70690_d(new PotionEffect(CQRPotions.TWOHANDED, 30, 1));
        }
    }
}

