/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.item.armor;

import com.google.common.collect.Multimap;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.cqr.cqrepoured.client.init.CQRArmorModels;
import team.cqr.cqrepoured.init.CQRMaterials;

public class ItemArmorHeavy
extends ItemArmor {
    private AttributeModifier movementSpeed = new AttributeModifier("HeavySpeedModifier", -0.05, 2);
    private AttributeModifier knockbackResistance = new AttributeModifier("HeavyKnockbackModifier", 0.1, 0);

    public ItemArmorHeavy(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityLiving.func_184640_d((ItemStack)stack)) {
            multimap.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)this.knockbackResistance);
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)this.movementSpeed);
        }
        return multimap;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        player.field_70747_aH *= 0.95f;
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        ItemArmor.ArmorMaterial armorMaterial = ((ItemArmor)itemStack.func_77973_b()).func_82812_d();
        if (armorMaterial == CQRMaterials.ArmorMaterials.ARMOR_HEAVY_DIAMOND) {
            return armorSlot == EntityEquipmentSlot.LEGS ? CQRArmorModels.heavyDiamondArmorLegs : CQRArmorModels.heavyDiamondArmor;
        }
        if (armorMaterial == CQRMaterials.ArmorMaterials.ARMOR_HEAVY_IRON) {
            return armorSlot == EntityEquipmentSlot.LEGS ? CQRArmorModels.heavyIronArmorLegs : CQRArmorModels.heavyIronArmor;
        }
        return null;
    }
}

