/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;

public class ItemSpawnEggCQR
extends Item {
    private Class<? extends AbstractEntityCQR> entityClass;
    private String entityName;
    private ItemStack mainhand;
    private ItemStack offhand;
    private ItemArmor.ArmorMaterial armor;

    public ItemSpawnEggCQR(Class<? extends AbstractEntityCQR> entityClass, String entityName, ItemStack mainhand, ItemStack offhand, ItemArmor.ArmorMaterial armor) {
        this.entityClass = entityClass;
        this.entityName = entityName;
        this.mainhand = mainhand;
        this.offhand = offhand;
        this.armor = armor;
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            AbstractEntityCQR entity = null;
            try {
                entity = this.entityClass.getConstructor(World.class).newInstance(worldIn);
            }
            catch (Exception e) {
                CQRMain.logger.error("Failed to spawn entity from preset item!", (Throwable)e);
            }
            if (entity != null) {
                entity.func_180482_a(worldIn.func_175649_E(pos), null);
                BlockPos blockpos = pos.func_177972_a(facing);
                double d0 = this.getYOffset(worldIn, blockpos);
                entity.func_70107_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + d0, (double)blockpos.func_177952_p() + 0.5);
                this.setEquipment(entity);
                worldIn.func_72838_d((Entity)entity);
            }
            if (!player.func_184812_l_()) {
                player.func_184586_b(hand).func_190918_g(1);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    protected double getYOffset(World world, BlockPos blockpos) {
        AxisAlignedBB aabb = new AxisAlignedBB(blockpos).func_72321_a(0.0, -1.0, 0.0);
        List list = world.func_184144_a(null, aabb);
        if (list.isEmpty()) {
            return 0.0;
        }
        double d0 = aabb.field_72338_b;
        for (AxisAlignedBB aabb1 : list) {
            d0 = Math.max(aabb1.field_72337_e, d0);
        }
        return d0 - (double)blockpos.func_177956_o();
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)("entity.cqr_" + this.entityName + ".name")).trim() + " (" + this.mainhand.func_82833_r() + ", " + this.offhand.func_82833_r() + ", " + this.armor.name() + ")";
    }

    private void setEquipment(AbstractEntityCQR entity) {
        entity.func_184611_a(EnumHand.MAIN_HAND, this.mainhand.func_77946_l());
        entity.func_184611_a(EnumHand.OFF_HAND, this.offhand.func_77946_l());
        switch (this.armor) {
            case LEATHER: {
                entity.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151021_T));
                entity.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151026_S));
                entity.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151027_R));
                entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151024_Q));
                break;
            }
            case GOLD: {
                entity.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151151_aj));
                entity.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151149_ai));
                entity.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151171_ah));
                entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151169_ag));
                break;
            }
            case CHAIN: {
                entity.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151029_X));
                entity.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151022_W));
                entity.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151023_V));
                entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151020_U));
                break;
            }
            case IRON: {
                entity.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151167_ab));
                entity.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151165_aa));
                entity.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151030_Z));
                entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151028_Y));
                break;
            }
            case DIAMOND: {
                entity.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151175_af));
                entity.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151173_ae));
                entity.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151163_ad));
                entity.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151161_ac));
                break;
            }
        }
    }

    public static List<Item> getItemList(Class<? extends AbstractEntityCQR> entityClass, String entityName) {
        ArrayList<Item> itemList = new ArrayList<Item>();
        itemList.add(new ItemSpawnEggCQR(entityClass, entityName, new ItemStack(Items.field_151041_m), ItemStack.field_190927_a, ItemArmor.ArmorMaterial.LEATHER));
        itemList.add(new ItemSpawnEggCQR(entityClass, entityName, new ItemStack(Items.field_151010_B), ItemStack.field_190927_a, ItemArmor.ArmorMaterial.GOLD));
        itemList.add(new ItemSpawnEggCQR(entityClass, entityName, new ItemStack(Items.field_151052_q), ItemStack.field_190927_a, ItemArmor.ArmorMaterial.CHAIN));
        itemList.add(new ItemSpawnEggCQR(entityClass, entityName, new ItemStack(Items.field_151040_l), ItemStack.field_190927_a, ItemArmor.ArmorMaterial.IRON));
        itemList.add(new ItemSpawnEggCQR(entityClass, entityName, new ItemStack(Items.field_151048_u), ItemStack.field_190927_a, ItemArmor.ArmorMaterial.DIAMOND));
        return itemList;
    }
}

