/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.item;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import team.cqr.cqrepoured.init.CQRParticleType;
import team.cqr.cqrepoured.init.CQRSounds;
import team.cqr.cqrepoured.item.ItemLore;
import team.cqr.cqrepoured.util.EntityUtil;
import team.cqr.cqrepoured.world.structure.protection.IProtectedRegionManager;
import team.cqr.cqrepoured.world.structure.protection.ProtectedRegion;
import team.cqr.cqrepoured.world.structure.protection.ProtectedRegionManager;

public class ItemMagicBell
extends ItemLore {
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 20;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (!worldIn.field_72995_K) {
            IProtectedRegionManager protectedRegionManager = ProtectedRegionManager.getInstance(worldIn);
            List<ProtectedRegion> protectedRegions = protectedRegionManager.getProtectedRegionsAt(new BlockPos((Entity)entityLiving));
            protectedRegions.stream().map(ProtectedRegion::getEntityDependencies).flatMap(Collection::stream).map(uuid -> EntityUtil.getEntityByUUID(worldIn, uuid)).filter(Objects::nonNull).forEach(entity -> CQRParticleType.spawnParticles(CQRParticleType.BLOCK_HIGHLIGHT, worldIn, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 200, 0xC00000, entity.func_145782_y()));
            protectedRegions.stream().map(ProtectedRegion::getBlockDependencies).flatMap(Collection::stream).forEach(pos -> CQRParticleType.spawnParticles(CQRParticleType.BLOCK_HIGHLIGHT, worldIn, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 200, 4214992, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
            protectedRegions.forEach(pr -> {
                BlockPos start = pr.getStartPos();
                BlockPos size = pr.getEndPos().func_177973_b((Vec3i)pr.getStartPos()).func_177982_a(1, 1, 1);
                byte[] protectionStates = pr.getProtectionStates();
                for (int i = 0; i < protectionStates.length; ++i) {
                    byte protectionState = protectionStates[i];
                    if (protectionState != 1 && protectionState != 2) continue;
                    int color = protectionState == 1 ? 0xFFFF00 : 65280;
                    int x = i / size.func_177952_p() / size.func_177956_o();
                    int y = i / size.func_177952_p() % size.func_177956_o();
                    int z = i % size.func_177952_p();
                    CQRParticleType.spawnParticles(CQRParticleType.BLOCK_HIGHLIGHT, worldIn, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, 0.0, 0.0, 0.0, 1, 0.0, 0.0, 0.0, 200, color, start.func_177958_n() + x, start.func_177956_o() + y, start.func_177952_p() + z);
                }
            });
            worldIn.func_184148_a(null, entityLiving.field_70165_t, entityLiving.field_70163_u, entityLiving.field_70161_v, CQRSounds.BELL_USE, entityLiving.func_184176_by(), 1.0f, 1.0f);
            if (entityLiving instanceof EntityPlayer) {
                if (protectedRegions.isEmpty()) {
                    ((EntityPlayer)entityLiving).func_184811_cZ().func_185145_a(stack.func_77973_b(), 60);
                } else {
                    ((EntityPlayer)entityLiving).func_184811_cZ().func_185145_a(stack.func_77973_b(), 200);
                }
            }
        }
        return stack;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }
}

