/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.projectiles;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import team.cqr.cqrepoured.init.CQRSounds;

public class ProjectileEnergyOrb
extends EntityFireball {
    private int deflectionsByPlayer = 0;
    public int innerRotation = this.field_70146_Z.nextInt(100000);

    public ProjectileEnergyOrb(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.5f, 1.5f);
    }

    public ProjectileEnergyOrb(World world, EntityLivingBase shooter, double vx, double vy, double vz) {
        super(world, shooter, vx, vy, vz);
    }

    public int getDeflectionCount() {
        return this.deflectionsByPlayer;
    }

    public void func_70071_h_() {
        ++this.innerRotation;
        super.func_70071_h_();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean result = super.func_70097_a(source, amount);
        if (result && source.func_76346_g() instanceof EntityPlayer) {
            ++this.deflectionsByPlayer;
        }
        return result;
    }

    public static ProjectileEnergyOrb shootAt(Entity target, EntityLivingBase shooter, World world) {
        Vec3d vec3d = shooter.func_70676_i(1.0f);
        double vx = target.field_70165_t - (shooter.field_70165_t + vec3d.field_72450_a * (double)shooter.field_70130_N);
        double vy = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - (0.5 + shooter.field_70163_u + (double)(shooter.field_70131_O / 2.0f));
        double vz = target.field_70161_v - (shooter.field_70161_v + vec3d.field_72449_c * (double)shooter.field_70130_N);
        ProjectileEnergyOrb orb = new ProjectileEnergyOrb(world, shooter, vx, vy, vz);
        orb.field_70165_t = shooter.field_70165_t + vec3d.field_72450_a * (double)shooter.field_70130_N;
        orb.field_70163_u = shooter.field_70163_u + (double)(shooter.field_70131_O / 2.0f) + 0.5;
        orb.field_70161_v = shooter.field_70161_v + vec3d.field_72449_c * (double)shooter.field_70130_N;
        world.func_72838_d((Entity)orb);
        return orb;
    }

    public void redirect(Entity target, EntityLivingBase shooter) {
        this.field_70235_a = shooter;
        Vec3d vec3d = shooter.func_70676_i(1.0f);
        double accelX = target.field_70165_t - (shooter.field_70165_t + vec3d.field_72450_a * (double)shooter.field_70130_N);
        double accelY = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - (0.5 + shooter.field_70163_u + (double)(shooter.field_70131_O / 2.0f));
        double accelZ = target.field_70161_v - (shooter.field_70161_v + vec3d.field_72449_c * (double)shooter.field_70130_N);
        this.field_70165_t = shooter.field_70165_t + vec3d.field_72450_a * (double)shooter.field_70130_N;
        this.field_70163_u = shooter.field_70163_u + (double)(shooter.field_70131_O / 2.0f) + 0.5;
        this.field_70161_v = shooter.field_70161_v + vec3d.field_72449_c * (double)shooter.field_70130_N;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        double d0 = MathHelper.func_76133_a((double)((accelX += this.field_70146_Z.nextGaussian() * 0.4) * accelX + (accelY += this.field_70146_Z.nextGaussian() * 0.4) * accelY + (accelZ += this.field_70146_Z.nextGaussian() * 0.4) * accelZ));
        this.field_70232_b = accelX / d0 * 0.1;
        this.field_70233_c = accelY / d0 * 0.1;
        this.field_70230_d = accelZ / d0 * 0.1;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.deflectionsByPlayer = compound.func_74762_e("deflections");
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("deflections", this.deflectionsByPlayer);
    }

    protected void func_70227_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            if (result.field_72308_g != null) {
                if (!result.field_72308_g.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.field_70235_a), 4.0f)) {
                    return;
                }
                this.func_174815_a(this.field_70235_a, result.field_72308_g);
            }
            this.field_70170_p.func_72876_a((Entity)this.field_70235_a, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, false);
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            entityareaeffectcloud.func_184481_a(this.field_70235_a);
            entityareaeffectcloud.func_184491_a(EnumParticleTypes.SPELL_MOB);
            entityareaeffectcloud.func_184482_a(0xFFFF26);
            entityareaeffectcloud.func_184483_a(4.0f);
            entityareaeffectcloud.func_184486_b(400);
            entityareaeffectcloud.func_184495_b(-0.125f);
            entityareaeffectcloud.func_184485_d(20);
            entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
            entityareaeffectcloud.func_184496_a(new PotionEffect(MobEffects.field_76436_u, 60, 2));
            this.field_70170_p.func_72838_d((Entity)entityareaeffectcloud);
            this.func_184185_a(CQRSounds.PROJECTILE_ENERGY_SPHERE_IMPACT, 8.0f, 1.0f);
            this.func_70106_y();
        }
    }
}

