/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.boss.spectrelord;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import team.cqr.cqrepoured.entity.boss.AbstractEntityLaser;

public class EntityTargetingLaser
extends AbstractEntityLaser {
    private EntityLivingBase target;
    protected float maxRotationPerTick = 2.0f;

    public EntityTargetingLaser(World worldIn) {
        this(worldIn, null, 4.0f, null);
    }

    public EntityTargetingLaser(World worldIn, EntityLivingBase caster, float length, EntityLivingBase target) {
        super(worldIn, caster, length);
        this.target = target;
    }

    @Override
    public void setupPositionAndRotation() {
        Vec3d vec1 = new Vec3d(this.caster.field_70165_t, this.caster.field_70163_u, this.caster.field_70161_v);
        vec1 = vec1.func_178787_e(this.getOffsetVector());
        Vec3d vec2 = new Vec3d(this.target.field_70165_t, this.target.field_70163_u + (double)this.target.field_70131_O * 0.6, this.target.field_70161_v);
        Vec3d vec3 = vec2.func_178788_d(vec1);
        double dist = Math.sqrt(vec3.field_72450_a * vec3.field_72450_a + vec3.field_72449_c * vec3.field_72449_c);
        float yaw = (float)Math.toDegrees(Math.atan2(-vec3.field_72450_a, vec3.field_72449_c));
        float pitch = (float)Math.toDegrees(Math.atan2(-vec3.field_72448_b, dist));
        this.rotationYawCQR = yaw;
        this.rotationPitchCQR = pitch;
        this.func_70107_b(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c);
    }

    @Override
    public void updatePositionAndRotation() {
        float deltaPitch;
        Vec3d vec1 = new Vec3d(this.caster.field_70165_t, this.caster.field_70163_u, this.caster.field_70161_v);
        vec1 = vec1.func_178787_e(this.getOffsetVector());
        Vec3d vec2 = new Vec3d(this.target.field_70165_t, this.target.field_70163_u + (double)this.target.field_70131_O * 0.6, this.target.field_70161_v);
        Vec3d vec3 = vec2.func_178788_d(vec1);
        double dist = Math.sqrt(vec3.field_72450_a * vec3.field_72450_a + vec3.field_72449_c * vec3.field_72449_c);
        float yaw = (float)Math.toDegrees(Math.atan2(-vec3.field_72450_a, vec3.field_72449_c));
        float pitch = (float)Math.toDegrees(Math.atan2(-vec3.field_72448_b, dist));
        float deltaYaw = MathHelper.func_76142_g((float)(yaw - this.rotationYawCQR));
        float delta = this.maxRotationPerTick / (float)Math.sqrt(deltaYaw * deltaYaw + (deltaPitch = MathHelper.func_76142_g((float)(pitch - this.rotationPitchCQR))) * deltaPitch);
        if (delta > 1.0f) {
            delta = 1.0f;
        }
        this.rotationYawCQR += (deltaYaw *= delta);
        this.rotationYawCQR = MathHelper.func_76142_g((float)this.rotationYawCQR);
        this.rotationPitchCQR += (deltaPitch *= delta);
        this.func_70107_b(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c);
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeInt(this.target.func_145782_y());
    }

    @Override
    public void readSpawnData(ByteBuf additionalData) {
        super.readSpawnData(additionalData);
        this.target = (EntityLivingBase)this.field_70170_p.func_73045_a(additionalData.readInt());
    }
}

