/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.boss.exterminator;

import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import team.cqr.cqrepoured.capability.electric.CapabilityElectricShock;
import team.cqr.cqrepoured.capability.electric.CapabilityElectricShockProvider;
import team.cqr.cqrepoured.entity.MultiPartEntityPartSizable;
import team.cqr.cqrepoured.entity.boss.exterminator.EntityCQRExterminator;
import team.cqr.cqrepoured.init.CQRSounds;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public class SubEntityExterminatorFieldEmitter
extends MultiPartEntityPartSizable<EntityCQRExterminator> {
    private EntityCQRExterminator exterminator;
    private final Supplier<EntityLivingBase> funcGetElectrocuteTarget;
    private final Supplier<Boolean> funcGetIsActive;
    private final Consumer<Boolean> funcSetIsActiveInParent;
    private int remainingActiveTime;
    private int activeTimeNoTarget;
    private int cooldown;

    public SubEntityExterminatorFieldEmitter(EntityCQRExterminator parent, String partName, Supplier<EntityLivingBase> funcGetElectrocuteTarget, Supplier<Boolean> funcGetIsActive, Consumer<Boolean> funcSetIsActiveInParent) {
        super(parent, partName, 0.5f, 0.5f);
        this.exterminator = parent;
        this.funcGetElectrocuteTarget = funcGetElectrocuteTarget;
        this.funcGetIsActive = funcGetIsActive;
        this.funcSetIsActiveInParent = funcSetIsActiveInParent;
    }

    public void func_174812_G() {
        this.exterminator.func_174812_G();
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public boolean isActive() {
        if (this.field_70170_p.field_72995_K) {
            return this.funcGetIsActive.get();
        }
        return this.exterminator.canElectricCoilsBeActive() && this.remainingActiveTime > 0;
    }

    public void func_70030_z() {
        super.func_70030_z();
        boolean active = this.isActive();
        this.funcSetIsActiveInParent.accept(active);
        if (active) {
            if (this.field_70173_aa % 30 == 0) {
                this.func_184185_a(CQRSounds.EXTERMINATOR_ELECTRO_ZAP, 0.75f, 1.0f);
            }
            EntityLivingBase target = this.getTargetedEntity();
            --this.remainingActiveTime;
            if (target == null) {
                ++this.activeTimeNoTarget;
                if (this.activeTimeNoTarget > 60) {
                    this.remainingActiveTime = -1;
                }
            } else {
                ((CapabilityElectricShock)target.getCapability(CapabilityElectricShockProvider.ELECTROCUTE_HANDLER_CQR, null)).setRemainingTicks(200);
                ((CapabilityElectricShock)target.getCapability(CapabilityElectricShockProvider.ELECTROCUTE_HANDLER_CQR, null)).setRemainingSpreads(8);
                ((CapabilityElectricShock)target.getCapability(CapabilityElectricShockProvider.ELECTROCUTE_HANDLER_CQR, null)).setCasterID(this.exterminator.getPersistentID());
            }
        } else {
            --this.cooldown;
            if (this.remainingActiveTime > 0) {
                this.remainingActiveTime = -1;
            }
            if (this.cooldown <= 0) {
                this.cooldown = DungeonGenUtils.randomBetween(120, 360, this.field_70146_Z);
                this.remainingActiveTime = DungeonGenUtils.randomBetween(100, 200, this.field_70146_Z);
                this.activeTimeNoTarget = 0;
            }
        }
    }

    @Nullable
    public EntityLivingBase getTargetedEntity() {
        return this.funcGetElectrocuteTarget.get();
    }

    public Random getRNG() {
        return this.exterminator.func_70681_au();
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.exterminator == null || this.exterminator.field_70128_L) {
            return false;
        }
        return this.exterminator.func_184230_a(player, hand);
    }
}

