/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.boss.endercalamity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import team.cqr.cqrepoured.entity.boss.endercalamity.EntityCQREnderCalamity;
import team.cqr.cqrepoured.entity.misc.EntityColoredLightningBolt;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.EntityUtil;
import team.cqr.cqrepoured.util.VectorUtil;

public class EntityCalamitySpawner
extends Entity {
    private int timer;
    private String faction;
    private float sizeScaling;
    private double healthScaling;
    private static final int CALAMITY_SPAWN_DURATION = 800;
    public static ItemStack FIREWORK_PURPLE_SPARK = Items.field_151152_bP.func_190903_i();
    private static final int FIREWORK_DURATION = 120;
    private static final int FIREWORK_DIVISOR = 5;

    public EntityCalamitySpawner(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.0f, 1.0f);
        this.func_189654_d(true);
        this.func_82142_c(true);
        this.func_184224_h(true);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    public void func_70100_b_(EntityPlayer entityIn) {
    }

    public boolean func_70104_M() {
        return false;
    }

    public void func_70108_f(Entity entityIn) {
    }

    protected void func_70088_a() {
    }

    public boolean shouldRenderInPass(int pass) {
        return false;
    }

    public void func_70030_z() {
        if (this.field_70170_p.field_72995_K) {
            super.func_70030_z();
            return;
        }
        ++this.timer;
        int tmpTimer = 800 - this.timer;
        double percentage = (double)tmpTimer / 120.0;
        if (this.timer >= 200) {
            if (this.timer % 40 == 0) {
                this.spawnScaryEffect((int)(Math.round(25.0 * percentage) + 5L));
                if (800 - this.timer > 180 && DungeonGenUtils.percentageRandom(0.75, this.field_70146_Z)) {
                    this.spawnFireworks((int)(Math.round(3.0 * percentage) + 1L));
                }
            }
            if ((this.timer - 2) % 40 == 0 && this.field_70146_Z.nextBoolean()) {
                EntityColoredLightningBolt lightning = new EntityColoredLightningBolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, true, false, 0.34f, 0.08f, 0.43f, 0.4f);
                lightning.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.field_70170_p.func_72838_d((Entity)lightning);
            }
            if (this.timer >= 800) {
                if (this.timer == 800 && !this.field_70170_p.field_72995_K) {
                    this.spawnCalamity();
                }
                this.func_70106_y();
                return;
            }
            if (800 - this.timer <= 120 && tmpTimer % 5 == 0) {
                double radius = 2 * EntityCQREnderCalamity.getArenaRadius();
                radius *= percentage;
                Vec3d vector = new Vec3d(radius += 1.5, 0.0, 0.0);
                int lines = 5;
                int rotationDegree = 72;
                vector = VectorUtil.rotateVectorAroundY(vector, 288.0 * percentage);
                for (int i = 0; i < 5; ++i) {
                    Vec3d particlePosition = this.func_174791_d().func_178787_e(vector);
                    this.spawnFirework(particlePosition.field_72450_a, particlePosition.field_72448_b + 1.0, particlePosition.field_72449_c, FIREWORK_PURPLE_SPARK);
                    vector = VectorUtil.rotateVectorAroundY(vector, 72.0);
                }
            }
        }
        super.func_70030_z();
    }

    private void spawnFirework(double x, double y, double z, ItemStack stack) {
        EntityFireworkRocket firework = new EntityFireworkRocket(this.field_70170_p, x, y, z, FIREWORK_PURPLE_SPARK);
        firework.field_92055_b = 1;
        firework.func_82142_c(true);
        firework.func_174810_b(true);
        this.field_70170_p.func_72838_d((Entity)firework);
    }

    private Vec3d getRandomPositionAroundPosition() {
        Vec3d v = new Vec3d((double)EntityCQREnderCalamity.getArenaRadius() * this.field_70146_Z.nextDouble(), 0.0, 0.0);
        v = VectorUtil.rotateVectorAroundY(v, (double)DungeonGenUtils.randomBetween(0, 360, this.field_70146_Z));
        return v.func_178787_e(this.func_174791_d());
    }

    private void spawnCalamity() {
        EntityCQREnderCalamity calamity = new EntityCQREnderCalamity(this.field_70170_p);
        calamity.setFaction(this.faction, false);
        calamity.setHomePositionCQR(this.func_180425_c());
        calamity.setHealthScale(this.healthScaling);
        calamity.setSizeVariation(this.sizeScaling);
        calamity.func_70107_b(calamity.getHomePositionCQR().func_177958_n(), calamity.getHomePositionCQR().func_177956_o(), calamity.getHomePositionCQR().func_177952_p());
        this.field_70170_p.func_72838_d((Entity)calamity);
        EntityUtil.addEntityToAllRegionsAt(this.func_180425_c(), (Entity)calamity);
        EntityUtil.removeEntityFromAllRegionsAt(this.func_180425_c(), this);
    }

    protected void spawnScaryEffect(int count) {
        this.func_184185_a(SoundEvents.field_187532_aV, 1.0f, 0.5f + 0.5f * this.field_70146_Z.nextFloat());
    }

    protected void spawnFireworks(int count) {
        for (int i = 0; i < count; ++i) {
            Vec3d v = this.getRandomPositionAroundPosition();
            this.spawnFirework(v.field_72450_a, v.field_72448_b, v.field_72449_c, FIREWORK_PURPLE_SPARK);
        }
    }

    protected void spawnEnderClouds(int count, int minSize, int maxSize) {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.timer = compound.func_74762_e("entityTimer");
        this.setFaction(compound.func_74779_i("faction"));
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("entityTimer", this.timer);
        compound.func_74778_a("faction", this.getFaction());
    }

    public String getFaction() {
        return this.faction;
    }

    public void setFaction(String faction) {
        this.faction = faction;
    }

    public void setSizeScaling(float sizeScaling) {
        this.sizeScaling = sizeScaling;
    }

    public void setHealthScaling(double healthScaling) {
        this.healthScaling = healthScaling;
    }

    static {
        NBTTagCompound compound = FIREWORK_PURPLE_SPARK.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        NBTTagCompound fwCompound = new NBTTagCompound();
        NBTTagList explosionCompoundList = new NBTTagList();
        NBTTagCompound explosionCompound = new NBTTagCompound();
        explosionCompound.func_74768_a("Type", 4);
        explosionCompound.func_74783_a("Colors", new int[]{8073150});
        explosionCompound.func_74783_a("FadeColors", new int[]{2437522, 6719955, 12801229});
        explosionCompoundList.func_74742_a((NBTBase)explosionCompound);
        fwCompound.func_74782_a("Explosions", (NBTBase)explosionCompoundList);
        compound.func_74782_a("Fireworks", (NBTBase)fwCompound);
        FIREWORK_PURPLE_SPARK.func_77982_d(compound);
    }
}

