/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.boss;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.entity.ai.spells.EntityAIBlindTargetSpell;
import team.cqr.cqrepoured.entity.ai.spells.EntityAIFangAttack;
import team.cqr.cqrepoured.entity.ai.spells.EntityAISummonMinionSpell;
import team.cqr.cqrepoured.entity.bases.ISummoner;
import team.cqr.cqrepoured.entity.boss.AbstractEntityCQRMageBase;
import team.cqr.cqrepoured.entity.misc.EntityFlyingSkullMinion;
import team.cqr.cqrepoured.entity.misc.EntitySummoningCircle;
import team.cqr.cqrepoured.faction.EDefaultFaction;
import team.cqr.cqrepoured.faction.Faction;
import team.cqr.cqrepoured.init.CQRLoottables;

public class EntityCQRNecromancer
extends AbstractEntityCQRMageBase
implements ISummoner {
    private static final DataParameter<Boolean> BONE_SHIELD_ACTIVE = EntityDataManager.func_187226_a(EntityCQRNecromancer.class, (DataSerializer)DataSerializers.field_187198_h);
    protected List<Entity> summonedMinions = new ArrayList<Entity>();
    protected List<EntityFlyingSkullMinion> summonedSkulls = new ArrayList<EntityFlyingSkullMinion>();

    public EntityCQRNecromancer(World worldIn) {
        super(worldIn);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.spellHandler.addSpell(0, new EntityAISummonMinionSpell(this, 30, 10, new ResourceLocation("cqrepoured", "skeleton"), EntitySummoningCircle.ECircleTexture.SKELETON, true, 25, 5, new Vec3d(0.0, 0.0, 0.0)){

            @Override
            public boolean isInterruptible() {
                return false;
            }
        });
        this.spellHandler.addSpell(1, new EntityAISummonMinionSpell(this, 20, 5, new ResourceLocation("cqrepoured", "flying_skull"), EntitySummoningCircle.ECircleTexture.FLYING_SKULL, false, 8, 4, new Vec3d(0.0, 2.5, 0.0)){

            @Override
            public boolean isInterruptible() {
                return false;
            }
        });
        this.spellHandler.addSpell(2, new EntityAIBlindTargetSpell(this, 45, 10, 100));
        this.spellHandler.addSpell(3, new EntityAIFangAttack(this, 20, 10, 4, 8){

            @Override
            public boolean isInterruptible() {
                return false;
            }
        });
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BONE_SHIELD_ACTIVE, (Object)false);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.filterSummonLists();
        if (!this.summonedSkulls.isEmpty() && !this.hasAttackTarget()) {
            this.summonedSkulls.get(0).setSide(false);
            if (this.summonedSkulls.size() >= 2) {
                this.summonedSkulls.get(1).setSide(true);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_110143_aJ() <= this.func_110138_aP() / 2.0f) {
            this.field_70180_af.func_187227_b(BONE_SHIELD_ACTIVE, (Object)true);
        } else if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(BONE_SHIELD_ACTIVE, (Object)false);
        }
        if (this.func_70638_az() != null && !this.func_70638_az().field_70128_L && !this.summonedSkulls.isEmpty()) {
            EntityFlyingSkullMinion skull;
            int i;
            for (i = 0; i < this.summonedSkulls.size(); ++i) {
                skull = this.summonedSkulls.get(i);
                if (skull.hasTarget()) continue;
                skull.setTarget((Entity)this.func_70638_az());
            }
            for (i = 0; i < this.summonedSkulls.size(); ++i) {
                skull = this.summonedSkulls.get(i);
                if (skull.isAttacking()) continue;
                skull.startAttacking();
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && this.func_110143_aJ() <= this.func_110138_aP() / 2.0f && (source.func_76352_a() || source.func_76364_f() instanceof EntityArrow || source.func_76364_f() instanceof IProjectile)) {
            amount = 0.0f;
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    private void filterSummonLists() {
        ArrayList<Entity> tmp = new ArrayList<Entity>();
        for (Entity entity : this.summonedMinions) {
            if (entity != null && !entity.field_70128_L) continue;
            tmp.add(entity);
        }
        for (Entity entity : tmp) {
            this.summonedMinions.remove(entity);
        }
        tmp.clear();
        for (Entity entity : this.summonedSkulls) {
            if (entity != null && !entity.field_70128_L) continue;
            tmp.add(entity);
        }
        for (Entity entity : tmp) {
            this.summonedSkulls.remove(entity);
        }
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        for (Entity e : this.getSummonedEntities()) {
            if (e == null || e.field_70128_L) continue;
            if (e instanceof EntityLivingBase) {
                ((EntityLivingBase)e).func_70645_a(cause);
            }
            e.func_70106_y();
        }
        this.summonedMinions.clear();
        super.func_70645_a(cause);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return CQRLoottables.ENTITIES_NECROMANCER;
    }

    @Override
    public float getBaseHealth() {
        return CQRConfig.baseHealths.Necromancer;
    }

    @Override
    public EDefaultFaction getDefaultFaction() {
        return EDefaultFaction.UNDEAD;
    }

    @Override
    public Faction getSummonerFaction() {
        return this.getFaction();
    }

    @Override
    public List<Entity> getSummonedEntities() {
        ArrayList<Entity> list = new ArrayList<Entity>(this.summonedMinions);
        list.addAll(this.summonedSkulls);
        return list;
    }

    @Override
    public EntityLivingBase getSummoner() {
        return this;
    }

    @Override
    public void addSummonedEntityToList(Entity summoned) {
        if (summoned instanceof EntityFlyingSkullMinion) {
            this.summonedSkulls.add((EntityFlyingSkullMinion)summoned);
            return;
        }
        this.summonedMinions.add(summoned);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ILLAGER;
    }

    public boolean isBoneShieldActive() {
        return (Boolean)this.field_70180_af.func_187225_a(BONE_SHIELD_ACTIVE);
    }
}

