/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.target;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumDifficulty;
import team.cqr.cqrepoured.entity.ICirclingEntity;
import team.cqr.cqrepoured.entity.ai.AbstractCQREntityAI;
import team.cqr.cqrepoured.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.faction.Faction;
import team.cqr.cqrepoured.init.CQRItems;

public class EntityAINearestAttackTargetAtHomeArea<T extends AbstractEntityCQR>
extends AbstractCQREntityAI<T> {
    protected final Predicate<EntityLivingBase> predicate = input -> {
        if (!TargetUtil.PREDICATE_ATTACK_TARGET.apply(input)) {
            return false;
        }
        if (!EntitySelectors.field_94557_a.apply(input)) {
            return false;
        }
        return this.isSuitableTarget((EntityLivingBase)input);
    };
    private static final Vec3i SIZE_VECTOR = new Vec3i(32, 32, 32);

    public EntityAINearestAttackTargetAtHomeArea(T entity) {
        super(entity);
    }

    public boolean func_75250_a() {
        if (this.entity.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.entity.func_70624_b(null);
            return false;
        }
        if (this.isStillSuitableTarget(this.entity.func_70638_az())) {
            return false;
        }
        this.entity.func_70624_b(null);
        return true;
    }

    public boolean func_75253_b() {
        return false;
    }

    public void func_75249_e() {
        AxisAlignedBB aabb = new AxisAlignedBB(((ICirclingEntity)((Object)this.entity)).getCirclingCenter().func_177971_a(SIZE_VECTOR), ((ICirclingEntity)((Object)this.entity)).getCirclingCenter().func_177973_b(SIZE_VECTOR));
        List possibleTargets = this.entity.field_70170_p.func_175647_a(EntityLivingBase.class, aabb, this.predicate);
        if (!possibleTargets.isEmpty()) {
            this.entity.func_70624_b((EntityLivingBase)TargetUtil.getNearestEntity((EntityLiving)this.entity, possibleTargets));
        }
    }

    private boolean isSuitableTarget(EntityLivingBase possibleTarget) {
        if (possibleTarget == this.entity) {
            return false;
        }
        Faction faction = this.entity.getFaction();
        if (this.entity.func_184614_ca().func_77973_b() == CQRItems.STAFF_HEALING) {
            if (faction == null || !faction.isAlly((Entity)possibleTarget) && this.entity.getLeader() != possibleTarget) {
                return false;
            }
            if (possibleTarget.func_110143_aJ() >= possibleTarget.func_110138_aP()) {
                return false;
            }
            return this.isInHomeZone(possibleTarget);
        }
        if (faction == null || !this.entity.getFaction().isEnemy((Entity)possibleTarget) || this.entity.getLeader() == possibleTarget) {
            return false;
        }
        if (this.entity.isInAttackReach(possibleTarget)) {
            return true;
        }
        return !possibleTarget.func_70093_af() && (double)this.entity.func_70032_d((Entity)possibleTarget) < 32.0;
    }

    private boolean isStillSuitableTarget(EntityLivingBase possibleTarget) {
        if (!TargetUtil.PREDICATE_ATTACK_TARGET.apply((Object)possibleTarget)) {
            return false;
        }
        if (!EntitySelectors.field_94557_a.apply((Object)possibleTarget)) {
            return false;
        }
        if (possibleTarget == this.entity) {
            return false;
        }
        Faction faction = this.entity.getFaction();
        if (this.entity.func_184614_ca().func_77973_b() == CQRItems.STAFF_HEALING) {
            if (faction == null || !faction.isAlly((Entity)possibleTarget) && this.entity.getLeader() != possibleTarget) {
                return false;
            }
            if (possibleTarget.func_110143_aJ() >= possibleTarget.func_110138_aP()) {
                return false;
            }
            return this.isInHomeZone(possibleTarget);
        }
        if (faction == null || !this.entity.getFaction().isEnemy((Entity)possibleTarget) || this.entity.getLeader() == possibleTarget) {
            return false;
        }
        return this.isInHomeZone(possibleTarget);
    }

    private boolean isInHomeZone(EntityLivingBase possibleTarget) {
        double distance = possibleTarget.func_180425_c().func_185332_f(((ICirclingEntity)((Object)this.entity)).getCirclingCenter().func_177958_n(), ((ICirclingEntity)((Object)this.entity)).getCirclingCenter().func_177956_o(), ((ICirclingEntity)((Object)this.entity)).getCirclingCenter().func_177952_p());
        return Math.abs(distance) <= (double)(48 + 8 * this.world.func_175659_aa().ordinal());
    }
}

