/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.spells;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import team.cqr.cqrepoured.entity.ai.spells.AbstractEntityAISpell;
import team.cqr.cqrepoured.entity.ai.spells.IEntityAISpellAnimatedVanilla;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.entity.projectiles.ProjectilePoisonSpell;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.VectorUtil;

public class EntityAIShootPoisonProjectiles
extends AbstractEntityAISpell<AbstractEntityCQR>
implements IEntityAISpellAnimatedVanilla {
    protected static final int MAX_PROJECTILES = 10;
    protected static final int MIN_PROJECTILES = 4;
    protected static final double SPEED_MULTIPLIER = 1.5;

    public EntityAIShootPoisonProjectiles(AbstractEntityCQR entity, int cooldown, int chargingTicks) {
        super(entity, cooldown, chargingTicks, 1);
        this.setup(true, true, true, false);
    }

    @Override
    public void startCastingSpell() {
        int projectiles = DungeonGenUtils.randomBetween(4, 10, this.entity.func_70681_au());
        Vec3d vector = new Vec3d((Vec3i)this.entity.func_70638_az().func_180425_c().func_177973_b((Vec3i)this.entity.func_180425_c())).func_72432_b();
        double angle = 180.0 / (double)projectiles;
        vector = VectorUtil.rotateVectorAroundY(vector, 270.0 + angle / 2.0);
        Vec3d[] velocities = new Vec3d[projectiles];
        for (int i = 0; i < projectiles; ++i) {
            velocities[i] = VectorUtil.rotateVectorAroundY(vector, angle * (double)i);
        }
        for (Vec3d v : velocities) {
            ProjectilePoisonSpell proj = new ProjectilePoisonSpell(this.entity.field_70170_p, (EntityLivingBase)this.entity);
            if (this.entity.func_70668_bt() == EnumCreatureAttribute.ARTHROPOD) {
                proj.enableAuraPlacement();
            }
            proj.field_70159_w = v.field_72450_a * 1.5;
            proj.field_70181_x = v.field_72448_b * 1.5;
            proj.field_70179_y = v.field_72449_c * 1.5;
            proj.field_70133_I = true;
            this.entity.field_70170_p.func_72838_d((Entity)proj);
        }
    }

    @Override
    protected SoundEvent getStartChargingSound() {
        return SoundEvents.field_187942_hp;
    }

    @Override
    protected SoundEvent getStartCastingSound() {
        return SoundEvents.field_193784_dd;
    }

    @Override
    public int getWeight() {
        return 10;
    }

    @Override
    public boolean ignoreWeight() {
        return false;
    }

    @Override
    public float getRed() {
        return 0.16f;
    }

    @Override
    public float getGreen() {
        return 0.48f;
    }

    @Override
    public float getBlue() {
        return 0.12f;
    }
}

