/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.spells;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import team.cqr.cqrepoured.entity.ai.spells.AbstractEntityAISpell;
import team.cqr.cqrepoured.entity.ai.spells.IEntityAISpellAnimatedVanilla;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.VectorUtil;

public class EntityAIFangAttack
extends AbstractEntityAISpell<AbstractEntityCQR>
implements IEntityAISpellAnimatedVanilla {
    private int minRows = 1;
    private int maxRows = 1;

    public EntityAIFangAttack(AbstractEntityCQR entity, int cooldown, int chargingTicks) {
        super(entity, cooldown, chargingTicks, 1);
        this.setup(true, true, true, false);
    }

    public EntityAIFangAttack(AbstractEntityCQR entity, int cooldown, int chargingTicks, int minRows, int maxRows) {
        this(entity, cooldown, chargingTicks);
        this.minRows = minRows;
        this.maxRows = maxRows;
    }

    @Override
    public void startCastingSpell() {
        EntityLivingBase entitylivingbase = this.entity.func_70638_az();
        double d0 = Math.min(entitylivingbase.field_70163_u, this.entity.field_70163_u);
        double d1 = Math.max(entitylivingbase.field_70163_u, this.entity.field_70163_u) + 1.0;
        float entityAngle = (float)MathHelper.func_181159_b((double)(entitylivingbase.field_70161_v - this.entity.field_70161_v), (double)(entitylivingbase.field_70165_t - this.entity.field_70165_t));
        if (this.entity.func_70068_e((Entity)entitylivingbase) < 9.0) {
            for (int i = 0; i < 5; ++i) {
                float f1 = entityAngle + (float)i * (float)Math.PI * 0.4f;
                this.spawnFangs(this.entity.field_70165_t + (double)MathHelper.func_76134_b((float)f1) * 1.5, this.entity.field_70161_v + (double)MathHelper.func_76126_a((float)f1) * 1.5, d0, d1, f1, 0);
            }
            for (int k = 0; k < 8; ++k) {
                float f2 = entityAngle + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                this.spawnFangs(this.entity.field_70165_t + (double)MathHelper.func_76134_b((float)f2) * 2.5, this.entity.field_70161_v + (double)MathHelper.func_76126_a((float)f2) * 2.5, d0, d1, f2, 3);
            }
        } else {
            double angle;
            Vec3d v = new Vec3d((double)MathHelper.func_76134_b((float)entityAngle), 0.0, (double)MathHelper.func_76126_a((float)entityAngle));
            v = v.func_72432_b().func_186678_a(1.25);
            int rows = DungeonGenUtils.randomBetween(this.minRows, this.maxRows, this.entity.func_70681_au());
            double d = angle = rows > 0 ? (double)(120 / rows) : 0.0;
            if (angle != 0.0) {
                v = VectorUtil.rotateVectorAroundY(v, -60.0);
            }
            for (int rowCount = 0; rowCount < rows; ++rowCount) {
                for (int fangcount = 0; fangcount < 24; ++fangcount) {
                    double d2 = 1.25 * (double)(fangcount + 1);
                    v = v.func_72432_b();
                    v = v.func_186678_a(d2);
                    this.spawnFangs(this.entity.field_70165_t + v.field_72450_a, this.entity.field_70161_v + v.field_72449_c, d0, d1, entityAngle, fangcount);
                }
                if (angle == 0.0) continue;
                v = v.func_72432_b();
                v = VectorUtil.rotateVectorAroundY(v, angle);
            }
        }
    }

    private void spawnFangs(double x, double z, double minY, double maxY, float rotationYawRadians, int warmupDelayTicks) {
        BlockPos blockpos = new BlockPos(x, maxY, z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            IBlockState iblockstate;
            AxisAlignedBB axisalignedbb;
            if (this.entity.field_70170_p.func_175677_d(blockpos, true) || !this.entity.field_70170_p.func_175677_d(blockpos.func_177977_b(), true)) continue;
            if (!this.entity.field_70170_p.func_175623_d(blockpos) && (axisalignedbb = (iblockstate = this.entity.field_70170_p.func_180495_p(blockpos)).func_185890_d((IBlockAccess)this.entity.field_70170_p, blockpos)) != null) {
                d0 = axisalignedbb.field_72337_e;
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c((double)minY) - 1);
        if (flag) {
            EntityEvokerFangs entityevokerfangs = new EntityEvokerFangs(this.entity.field_70170_p, x, (double)blockpos.func_177956_o() + d0, z, rotationYawRadians, warmupDelayTicks, (EntityLivingBase)this.entity);
            this.entity.field_70170_p.func_72838_d((Entity)entityevokerfangs);
        }
    }

    @Override
    protected SoundEvent getStartChargingSound() {
        return SoundEvents.field_191247_bq;
    }

    @Override
    protected SoundEvent getStartCastingSound() {
        return SoundEvents.field_193784_dd;
    }

    @Override
    public int getWeight() {
        return 10;
    }

    @Override
    public boolean ignoreWeight() {
        return false;
    }

    @Override
    public float getRed() {
        return 0.4f;
    }

    @Override
    public float getGreen() {
        return 0.3f;
    }

    @Override
    public float getBlue() {
        return 0.35f;
    }
}

