/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.boss.piratecaptain;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.entity.ai.spells.AbstractEntityAISpell;
import team.cqr.cqrepoured.entity.ai.spells.IEntityAISpellAnimatedVanilla;
import team.cqr.cqrepoured.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.entity.boss.EntityCQRPirateCaptain;

public class BossAIPirateFleeSpell
extends AbstractEntityAISpell<EntityCQRPirateCaptain>
implements IEntityAISpellAnimatedVanilla {
    protected final Predicate<EntityLiving> predicateAlly = input -> {
        if (!TargetUtil.PREDICATE_ATTACK_TARGET.apply(input)) {
            return false;
        }
        if (!EntitySelectors.field_94557_a.apply(input)) {
            return false;
        }
        return this.isSuitableAlly((EntityLiving)input);
    };

    public BossAIPirateFleeSpell(EntityCQRPirateCaptain entity, int cooldown, int chargingTicks, int castingTicks) {
        super(entity, cooldown, chargingTicks, castingTicks);
        this.setup(true, true, true, false);
    }

    @Override
    public boolean shouldExecute() {
        if (super.shouldExecute() && ((EntityCQRPirateCaptain)this.entity).getHealingPotions() >= 1 && (double)(((EntityCQRPirateCaptain)this.entity).func_110143_aJ() / ((EntityCQRPirateCaptain)this.entity).func_110138_aP()) <= 0.2) {
            return this.hasNearbyAllies();
        }
        return false;
    }

    @Override
    public boolean shouldContinueExecuting() {
        return super.shouldContinueExecuting() && this.hasNearbyAllies();
    }

    private boolean hasNearbyAllies() {
        Vec3d vec = new Vec3d(CQRConfig.bosses.pirateCaptainFleeCheckRadius, 0.5 * CQRConfig.bosses.pirateCaptainFleeCheckRadius, CQRConfig.bosses.pirateCaptainFleeCheckRadius);
        Vec3d v1 = ((EntityCQRPirateCaptain)this.entity).func_174791_d().func_178787_e(vec);
        Vec3d v2 = ((EntityCQRPirateCaptain)this.entity).func_174791_d().func_178788_d(vec);
        AxisAlignedBB aabb = new AxisAlignedBB(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c);
        List allies = ((EntityCQRPirateCaptain)this.entity).field_70170_p.func_175647_a(EntityLiving.class, aabb, this.predicateAlly);
        return !allies.isEmpty();
    }

    private int getNearbyAllies(EntityLiving o1) {
        Vec3d vec = new Vec3d(4.0, 2.0, 4.0);
        Vec3d v1 = o1.func_174791_d().func_178787_e(vec);
        Vec3d v2 = o1.func_174791_d().func_178788_d(vec);
        AxisAlignedBB aabb = new AxisAlignedBB(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c);
        return o1.field_70170_p.func_175647_a(EntityLiving.class, aabb, this.predicateAlly).size();
    }

    @Override
    public void castSpell() {
        super.castSpell();
        Vec3d vec = new Vec3d(CQRConfig.bosses.pirateCaptainFleeCheckRadius, 0.5 * CQRConfig.bosses.pirateCaptainFleeCheckRadius, CQRConfig.bosses.pirateCaptainFleeCheckRadius);
        Vec3d v1 = ((EntityCQRPirateCaptain)this.entity).func_174791_d().func_178787_e(vec);
        Vec3d v2 = ((EntityCQRPirateCaptain)this.entity).func_174791_d().func_178788_d(vec);
        AxisAlignedBB aabb = new AxisAlignedBB(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c);
        List allies = ((EntityCQRPirateCaptain)this.entity).field_70170_p.func_175647_a(EntityLiving.class, aabb, this.predicateAlly);
        allies.sort((o1, o2) -> {
            int entCount1 = this.getNearbyAllies((EntityLiving)o1);
            int entCount2 = this.getNearbyAllies((EntityLiving)o2);
            return entCount2 - entCount1;
        });
        Vec3d p = ((EntityLiving)allies.get(0)).func_174791_d();
        ((EntityCQRPirateCaptain)this.entity).func_184595_k(p.field_72450_a, p.field_72448_b, p.field_72449_c);
    }

    @Override
    public int getWeight() {
        return 2;
    }

    @Override
    public boolean ignoreWeight() {
        return true;
    }

    @Override
    public float getRed() {
        return 0.0f;
    }

    @Override
    public float getGreen() {
        return 1.0f;
    }

    @Override
    public float getBlue() {
        return 0.0f;
    }

    protected boolean isSuitableAlly(EntityLiving possibleAlly) {
        if (possibleAlly == this.entity) {
            return false;
        }
        if (!((EntityCQRPirateCaptain)this.entity).getFaction().isAlly((Entity)possibleAlly)) {
            return false;
        }
        Path path = possibleAlly.func_70661_as().func_75494_a((Entity)this.entity);
        return path != null && path.func_75874_d() <= 10;
    }
}

