/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.boss.endercalamity;

import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import team.cqr.cqrepoured.entity.ai.boss.endercalamity.BossAIBlockThrower;
import team.cqr.cqrepoured.entity.boss.endercalamity.EntityCQREnderCalamity;
import team.cqr.cqrepoured.entity.boss.endercalamity.phases.EEnderCalamityPhase;

public class BossAICalamityBuilding
extends BossAIBlockThrower {
    private int buildingCycles = 3;
    private int teleportCooldown = 10;
    private int blockEquipTimer = 5;
    private int blockThrowTimer = 15;
    private boolean waitingForAnimationEnd = false;

    public BossAICalamityBuilding(EntityCQREnderCalamity entity) {
        super(entity);
    }

    @Override
    protected boolean canExecuteDuringPhase(EEnderCalamityPhase currentPhase) {
        return currentPhase == EEnderCalamityPhase.PHASE_BUILDING;
    }

    @Override
    public boolean func_75253_b() {
        return this.buildingCycles >= 0;
    }

    @Override
    protected void execHandStateBlockWhenDone(EntityCQREnderCalamity.E_CALAMITY_HAND hand) {
    }

    @Override
    protected void execHandStateNoBlockWhenDone(EntityCQREnderCalamity.E_CALAMITY_HAND hand) {
    }

    @Override
    protected void execHandStateThrowingWhenDone(EntityCQREnderCalamity.E_CALAMITY_HAND hand) {
        this.waitingForAnimationEnd = false;
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.forceDropAllBlocks();
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (((EntityCQREnderCalamity)this.entity).hasAttackTarget()) {
            ((EntityCQREnderCalamity)this.entity).func_70625_a((Entity)((EntityCQREnderCalamity)this.entity).func_70638_az(), 90.0f, 90.0f);
        }
        if (this.blockEquipTimer > 0) {
            --this.blockEquipTimer;
            if (this.blockEquipTimer <= 0 && this.getCountOfEquippedHands() < 6) {
                for (EntityCQREnderCalamity.E_CALAMITY_HAND hand : EntityCQREnderCalamity.E_CALAMITY_HAND.values()) {
                    if (this.getStateOfHand(hand) != BossAIBlockThrower.E_HAND_STATE.NO_BLOCK) continue;
                    ((EntityCQREnderCalamity)this.entity).equipBlock(hand, Blocks.field_185772_cY);
                    this.setStateOfHand(hand, BossAIBlockThrower.E_HAND_STATE.BLOCK);
                    this.spawnEquipParticlesForHand(hand);
                    break;
                }
                this.blockEquipTimer = 5;
            }
        }
        if (this.getCountOfEquippedHands() >= 6 && this.blockEquipTimer <= 0) {
            --this.blockThrowTimer;
            if (this.blockThrowTimer <= 0) {
                for (EntityCQREnderCalamity.E_CALAMITY_HAND hand : EntityCQREnderCalamity.E_CALAMITY_HAND.values()) {
                    this.throwBlockOfHand(hand);
                }
                this.waitingForAnimationEnd = true;
                this.blockThrowTimer = 0;
            }
        }
        if (!this.waitingForAnimationEnd && this.blockThrowTimer <= 0 && this.getCountOfEquippedHands() <= 0) {
            --this.teleportCooldown;
            if (this.teleportCooldown <= 0) {
                this.teleportCooldown = 10;
                --this.buildingCycles;
                ((EntityCQREnderCalamity)this.entity).forceTeleport();
                this.blockEquipTimer = 5;
                this.blockThrowTimer = 15;
            }
        }
    }

    @Override
    public void func_75251_c() {
        this.buildingCycles = 3;
        this.teleportCooldown = 10;
        this.blockEquipTimer = 5;
        this.blockThrowTimer = 15;
        this.waitingForAnimationEnd = false;
        ((EntityCQREnderCalamity)this.entity).forcePhaseChangeToNextOf(EEnderCalamityPhase.PHASE_BUILDING.getPhaseObject());
    }
}

