/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.boss.endercalamity;

import com.google.common.base.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import team.cqr.cqrepoured.config.CQRConfig;
import team.cqr.cqrepoured.entity.ai.boss.endercalamity.AbstractBossAIEnderCalamity;
import team.cqr.cqrepoured.entity.boss.endercalamity.EntityCQREnderCalamity;
import team.cqr.cqrepoured.entity.boss.endercalamity.phases.EEnderCalamityPhase;
import team.cqr.cqrepoured.entity.projectiles.ProjectileThrownBlock;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.VectorUtil;

public class BossAIBlockThrower
extends AbstractBossAIEnderCalamity {
    protected static final int THROWING_TIME = 40;
    private E_HAND_STATE[] handstates = new E_HAND_STATE[]{E_HAND_STATE.NO_BLOCK, E_HAND_STATE.NO_BLOCK, E_HAND_STATE.NO_BLOCK, E_HAND_STATE.NO_BLOCK, E_HAND_STATE.NO_BLOCK, E_HAND_STATE.NO_BLOCK};
    private int[] handCooldowns = new int[]{100, 100, 100, 100, 100, 100};
    protected static final int MAX_EQUIPPED_BLOCKS = 3;

    protected E_HAND_STATE getStateOfHand(EntityCQREnderCalamity.E_CALAMITY_HAND hand) {
        return this.handstates[hand.getIndex()];
    }

    protected int getCooldownOfHand(EntityCQREnderCalamity.E_CALAMITY_HAND hand) {
        return this.handCooldowns[hand.getIndex()];
    }

    protected int getCountOfEquippedHands() {
        int counter = 0;
        for (E_HAND_STATE state : this.handstates) {
            if (state != E_HAND_STATE.BLOCK) continue;
            ++counter;
        }
        return counter;
    }

    protected boolean blockLimitReached() {
        int counter = this.getCountOfEquippedHands();
        return counter >= 3;
    }

    public BossAIBlockThrower(EntityCQREnderCalamity entity) {
        super(entity);
        for (EntityCQREnderCalamity.E_CALAMITY_HAND hand : EntityCQREnderCalamity.E_CALAMITY_HAND.values()) {
            if (entity.getBlockFromHand(hand).isPresent()) {
                this.handstates[hand.getIndex()] = E_HAND_STATE.BLOCK;
            }
            this.handCooldowns[hand.getIndex()] = DungeonGenUtils.randomBetween(200, 400);
        }
    }

    @Override
    public boolean func_75250_a() {
        if (this.entity != null && ((EntityCQREnderCalamity)this.entity).hasAttackTarget()) {
            return super.func_75250_a();
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.func_75250_a();
    }

    protected void execHandStateBlockWhenDone(EntityCQREnderCalamity.E_CALAMITY_HAND hand) {
        this.throwBlockOfHand(hand);
    }

    protected void execHandStateThrowingWhenDone(EntityCQREnderCalamity.E_CALAMITY_HAND hand) {
        this.handCooldowns[hand.getIndex()] = DungeonGenUtils.randomBetween(80, 140, ((EntityCQREnderCalamity)this.entity).func_70681_au());
    }

    protected void execHandStateNoBlockWhenDone(EntityCQREnderCalamity.E_CALAMITY_HAND hand) {
        IBlockState block = DungeonGenUtils.percentageRandom(0.25) ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150377_bs.func_176223_P();
        ((EntityCQREnderCalamity)this.entity).equipBlock(hand, block);
        this.handCooldowns[hand.getIndex()] = DungeonGenUtils.randomBetween(40, 200, ((EntityCQREnderCalamity)this.entity).func_70681_au());
        this.handstates[hand.getIndex()] = E_HAND_STATE.BLOCK;
        this.spawnEquipParticlesForHand(hand);
    }

    public void func_75246_d() {
        super.func_75246_d();
        block5: for (EntityCQREnderCalamity.E_CALAMITY_HAND hand : EntityCQREnderCalamity.E_CALAMITY_HAND.values()) {
            switch (this.getStateOfHand(hand)) {
                case BLOCK: {
                    if (!((EntityCQREnderCalamity)this.entity).getCurrentPhase().getPhaseObject().canThrowBlocksDuringPhase()) continue block5;
                    int n = hand.getIndex();
                    this.handCooldowns[n] = this.handCooldowns[n] - 1;
                    if (this.getCooldownOfHand(hand) > 0) continue block5;
                    this.execHandStateBlockWhenDone(hand);
                    continue block5;
                }
                case NO_BLOCK: {
                    if (!((EntityCQREnderCalamity)this.entity).getCurrentPhase().getPhaseObject().canPickUpBlocksDuringPhase() || this.blockLimitReached()) continue block5;
                    int n = hand.getIndex();
                    this.handCooldowns[n] = this.handCooldowns[n] - 1;
                    if (this.getCooldownOfHand(hand) > 0) continue block5;
                    this.execHandStateNoBlockWhenDone(hand);
                    continue block5;
                }
                case THROWING: {
                    int n = hand.getIndex();
                    this.handCooldowns[n] = this.handCooldowns[n] - 1;
                    if (this.getCooldownOfHand(hand) > 0) continue block5;
                    this.setStateOfHand(hand, E_HAND_STATE.NO_BLOCK);
                    this.execHandStateThrowingWhenDone(hand);
                }
            }
        }
    }

    protected void spawnEquipParticlesForHand(EntityCQREnderCalamity.E_CALAMITY_HAND hand) {
        if (this.world instanceof WorldServer && CQRConfig.bosses.calamityBlockEquipParticles) {
            WorldServer ws = (WorldServer)this.world;
            Vec3d pos = this.getPositionOfHand(hand);
            for (int i = 0; i < 50; ++i) {
                double dx = -0.5 + ((EntityCQREnderCalamity)this.entity).func_70681_au().nextDouble();
                double dy = -0.5 + ((EntityCQREnderCalamity)this.entity).func_70681_au().nextDouble();
                double dz = -0.5 + ((EntityCQREnderCalamity)this.entity).func_70681_au().nextDouble();
                ws.func_175739_a(EnumParticleTypes.ENCHANTMENT_TABLE, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 10, dx *= 2.0, dy *= 2.0, dz *= 2.0, 0.05, new int[0]);
                ((EntityCQREnderCalamity)this.entity).func_184185_a(SoundEvents.field_187941_ho, 1.5f, 1.25f);
            }
        }
    }

    public void func_75251_c() {
        super.func_75251_c();
    }

    protected boolean throwBlockOfHand(EntityCQREnderCalamity.E_CALAMITY_HAND hand) {
        Vec3d v = ((EntityCQREnderCalamity)this.entity).func_70040_Z().func_72432_b();
        if (((EntityCQREnderCalamity)this.entity).hasAttackTarget()) {
            v = ((EntityCQREnderCalamity)this.entity).func_70638_az().func_174791_d().func_178788_d(((EntityCQREnderCalamity)this.entity).func_174791_d());
            v = v.func_72432_b();
            v = v.func_186678_a(0.5);
            v = v.func_72441_c(0.0, 0.5, 0.0);
        }
        return this.throwBlockOfHand(hand, v);
    }

    protected Vec3d getPositionOfHand(EntityCQREnderCalamity.E_CALAMITY_HAND hand) {
        Vec3d offset = ((EntityCQREnderCalamity)this.entity).func_70040_Z().func_72432_b().func_186678_a(1.25);
        offset = new Vec3d(offset.field_72450_a, 0.0, offset.field_72449_c);
        offset = VectorUtil.rotateVectorAroundY(offset, hand.isLeftSided() ? 90.0 : 270.0);
        switch (hand.name().split("_")[1].toUpperCase()) {
            case "LOWER": {
                offset = offset.func_72441_c(0.0, 0.5, 0.0);
                break;
            }
            case "MIDDLE": {
                offset = offset.func_72441_c(0.0, 1.0, 0.0);
                break;
            }
            case "UPPER": {
                offset = offset.func_72441_c(0.0, 1.5, 0.0);
                break;
            }
        }
        offset = offset.func_186678_a((double)((EntityCQREnderCalamity)this.entity).getSizeVariation());
        Vec3d position = ((EntityCQREnderCalamity)this.entity).func_174791_d().func_178787_e(offset);
        return position;
    }

    protected boolean throwBlockOfHand(EntityCQREnderCalamity.E_CALAMITY_HAND hand, Vec3d velocity) {
        if (this.getStateOfHand(hand) == E_HAND_STATE.BLOCK) {
            Optional<IBlockState> handContent = ((EntityCQREnderCalamity)this.entity).getBlockFromHand(hand);
            if (!handContent.isPresent()) {
                return false;
            }
            Vec3d position = this.getPositionOfHand(hand);
            IBlockState block = (IBlockState)handContent.get();
            ProjectileThrownBlock blockProj = new ProjectileThrownBlock(this.world, (EntityLivingBase)this.entity, block, true);
            blockProj.func_70107_b(position.field_72450_a, position.field_72448_b, position.field_72449_c);
            blockProj.field_70159_w = velocity.field_72450_a;
            blockProj.field_70181_x = velocity.field_72448_b;
            blockProj.field_70179_y = velocity.field_72449_c;
            blockProj.field_70133_I = true;
            this.world.func_72838_d((Entity)blockProj);
            this.setStateOfHand(hand, E_HAND_STATE.THROWING);
            this.handCooldowns[hand.getIndex()] = 40;
            ((EntityCQREnderCalamity)this.entity).swingHand(hand);
            ((EntityCQREnderCalamity)this.entity).removeHandBlock(hand);
            return true;
        }
        return false;
    }

    protected void setStateOfHand(EntityCQREnderCalamity.E_CALAMITY_HAND hand, E_HAND_STATE state) {
        this.handstates[hand.getIndex()] = state;
    }

    public void forceDropAllBlocks() {
        for (EntityCQREnderCalamity.E_CALAMITY_HAND hand : EntityCQREnderCalamity.E_CALAMITY_HAND.values()) {
            this.throwBlockOfHand(hand, new Vec3d(0.0, -0.5, 0.0));
        }
    }

    @Override
    protected boolean canExecuteDuringPhase(EEnderCalamityPhase currentPhase) {
        return currentPhase.getPhaseObject().canPickUpBlocksDuringPhase() || currentPhase.getPhaseObject().canThrowBlocksDuringPhase();
    }

    static enum E_HAND_STATE {
        NO_BLOCK,
        BLOCK,
        THROWING;


        public E_HAND_STATE getNextState() {
            switch (this) {
                case BLOCK: {
                    return THROWING;
                }
                case NO_BLOCK: {
                    return BLOCK;
                }
                case THROWING: {
                    return NO_BLOCK;
                }
            }
            return BLOCK;
        }
    }
}

