/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.attack.special;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import team.cqr.cqrepoured.entity.ai.AbstractCQREntityAI;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.entity.projectiles.ProjectileHookShotHook;
import team.cqr.cqrepoured.item.ItemHookshotBase;

public class EntityAIHooker
extends AbstractCQREntityAI<AbstractEntityCQR> {
    protected int cooldown = 100;
    protected int MAX_COOLDOWN = 60;
    protected double MAX_RANGE = 256.0;
    protected double MIN_RANGE = 64.0;
    private ProjectileHookShotHook hook = null;
    protected STATE state = STATE.PREPARING;

    public EntityAIHooker(AbstractEntityCQR entity) {
        super(entity);
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (this.hasHookShoot((EntityLiving)this.entity)) {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            return this.entity.hasAttackTarget() && this.entity.func_70635_at().func_75522_a((Entity)this.entity.func_70638_az());
        }
        return false;
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.state = STATE.PREPARING;
        if (this.entity.func_70781_l()) {
            this.entity.func_70661_as().func_75499_g();
            double dist = this.entity.func_70068_e((Entity)this.entity.func_70638_az());
            if (dist > this.MAX_RANGE) {
                this.entity.func_70661_as().func_75497_a((Entity)this.entity.func_70638_az(), 1.1);
            } else if (dist >= this.MIN_RANGE) {
                this.entity.func_70661_as().func_75499_g();
                this.state = STATE.PREPARING_LAUNCH;
            } else {
                Vec3d v = this.entity.func_174791_d().func_178788_d(this.entity.func_70638_az().func_174791_d()).func_72432_b().func_186678_a(6.0);
                v = v.func_178787_e(this.entity.func_174791_d());
                this.entity.func_70661_as().func_75492_a(v.field_72450_a, v.field_72448_b, v.field_72449_c, 1.3);
            }
        }
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.hook != null && !this.hook.field_70128_L) {
            this.entity.func_70671_ap().func_75651_a((Entity)this.hook, 30.0f, 30.0f);
        } else if (this.entity.hasAttackTarget()) {
            this.entity.func_70671_ap().func_75651_a((Entity)this.entity.func_70638_az(), 30.0f, 30.0f);
        }
        switch (this.state) {
            case HOOK_FLYING: {
                if (this.entity.func_70781_l()) {
                    this.entity.func_70661_as().func_75499_g();
                }
                if (this.hook != null && !this.hook.field_70128_L) break;
                this.state = STATE.PREPARING;
                this.cooldown = this.MAX_COOLDOWN / 2;
                break;
            }
            case PREPARING: {
                double dist = this.entity.func_70068_e((Entity)this.entity.func_70638_az());
                if (dist > this.MAX_RANGE) {
                    this.entity.func_70661_as().func_75497_a((Entity)this.entity.func_70638_az(), 1.1);
                    break;
                }
                if (dist >= 64.0) {
                    this.entity.func_70661_as().func_75499_g();
                    this.state = STATE.PREPARING_LAUNCH;
                    break;
                }
                Vec3d v = this.entity.func_174791_d().func_178788_d(this.entity.func_70638_az().func_174791_d()).func_72432_b().func_186678_a(6.0);
                v = v.func_178787_e(this.entity.func_174791_d());
                this.entity.func_70661_as().func_75492_a(v.field_72450_a, v.field_72448_b, v.field_72449_c, 1.3);
                break;
            }
            case PREPARING_LAUNCH: {
                ItemStack hookItem;
                if (this.entity.func_70781_l()) {
                    this.entity.func_70661_as().func_75499_g();
                }
                if (!((hookItem = this.entity.func_184592_cb()).func_77973_b() instanceof ItemHookshotBase)) break;
                this.hook = ((ItemHookshotBase)hookItem.func_77973_b()).entityAIshoot(this.world, (EntityLivingBase)this.entity, (Entity)this.entity.func_70638_az(), EnumHand.OFF_HAND);
                this.state = STATE.HOOK_FLYING;
                break;
            }
        }
    }

    public boolean func_75253_b() {
        return super.func_75253_b() && this.entity.hasAttackTarget() && this.entity.func_70635_at().func_75522_a((Entity)this.entity.func_70638_az()) && this.hasHookShoot((EntityLiving)this.entity) && this.cooldown <= 0;
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.hook = null;
        this.state = STATE.PREPARING;
    }

    protected boolean hasHookShoot(EntityLiving ent) {
        ItemStack item = ent.func_184592_cb();
        if (!item.func_190926_b()) {
            return item.func_77973_b() instanceof ItemHookshotBase;
        }
        return false;
    }

    public static enum STATE {
        PREPARING,
        PREPARING_LAUNCH,
        HOOK_FLYING,
        HOOK_RETURNED;

    }
}

