/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai.attack.special;

import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import team.cqr.cqrepoured.entity.ai.attack.special.AbstractEntityAIAttackSpecial;
import team.cqr.cqrepoured.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.item.IRangedWeapon;
import team.cqr.cqrepoured.item.sword.ItemDagger;
import team.cqr.cqrepoured.item.sword.ItemGreatSword;

public class EntityAIAttackSpecialSpinAttack
extends AbstractEntityAIAttackSpecial {
    protected static final int COOLDOWN_BASE = 50;
    protected static final int ATTACK_DURATION = 200;
    protected static final float MAX_DISTANCE_TO_TARGET = 12.0f;
    protected Vec3d attackDirection = Vec3d.field_186680_a;
    protected short ticksCollided = 0;
    protected boolean targetWasNullInLastCycle = false;

    public EntityAIAttackSpecialSpinAttack() {
        super(false, false, 200, 50);
    }

    @Override
    public boolean shouldStartAttack(AbstractEntityCQR attacker, EntityLivingBase target) {
        if (!attacker.canUseSpinToWinAttack()) {
            return false;
        }
        ItemStack itemStackMain = attacker.func_184614_ca();
        ItemStack itemStackOff = attacker.func_184592_cb();
        return this.doesItemStackFitForSpinAttack(itemStackMain) && this.doesItemStackFitForSpinAttack(itemStackOff);
    }

    protected boolean doesItemStackFitForSpinAttack(ItemStack stack) {
        if (stack == null || stack.func_190926_b() || stack.func_77973_b() == Items.field_190931_a) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemShield || item instanceof IRangedWeapon || item instanceof ItemGreatSword) {
            return false;
        }
        return item instanceof ItemSword || item instanceof ItemDagger || item instanceof ItemAxe;
    }

    @Override
    public boolean shouldContinueAttack(AbstractEntityCQR attacker, EntityLivingBase target) {
        return !(target != null && !(attacker.func_70032_d((Entity)target) <= 12.0f) || attacker.field_70123_F && this.ticksCollided >= 20);
    }

    @Override
    public boolean isInterruptible(AbstractEntityCQR entity) {
        return false;
    }

    @Override
    public void startAttack(AbstractEntityCQR attacker, EntityLivingBase target) {
        attacker.setSpinToWin(true);
        this.calcAttackDirection(attacker, target);
    }

    private void calcAttackDirection(AbstractEntityCQR attacker, EntityLivingBase target) {
        this.attackDirection = target.func_174791_d().func_178788_d(attacker.func_174791_d()).func_72432_b().func_186678_a(0.25);
        this.attackDirection = this.attackDirection.func_178786_a(0.0, this.attackDirection.field_72448_b, 0.0);
    }

    @Override
    public void continueAttack(AbstractEntityCQR attacker, EntityLivingBase target, int tick) {
        boolean oldTargetWasNull = this.targetWasNullInLastCycle;
        this.targetWasNullInLastCycle = target == null || target.field_70128_L;
        this.ticksCollided = attacker.field_70123_F ? (short)(this.ticksCollided + 1) : (short)0;
        if (!this.targetWasNullInLastCycle && oldTargetWasNull != this.targetWasNullInLastCycle) {
            this.calcAttackDirection(attacker, target);
        }
        attacker.field_70159_w = this.attackDirection.field_72450_a;
        attacker.field_70179_y = this.attackDirection.field_72449_c;
        attacker.field_70133_I = true;
        double radius = 1.5 * (double)attacker.getSizeVariation();
        List affectedEntities = attacker.func_130014_f_().func_175674_a((Entity)attacker, attacker.func_174813_aQ().func_186662_g(radius), TargetUtil.createPredicateNonAlly(attacker.getFaction()));
        affectedEntities.forEach(entity -> {
            if (entity == null) {
                return;
            }
            if (entity instanceof MultiPartEntityPart) {
                return;
            }
            if ((double)attacker.func_70032_d((Entity)entity) > radius) {
                return;
            }
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase living = (EntityLivingBase)entity;
                float dmg = (float)attacker.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                dmg = (float)((double)dmg + 0.75 * (double)EnchantmentHelper.func_152377_a((ItemStack)attacker.func_184614_ca(), (EnumCreatureAttribute)living.func_70668_bt()));
                dmg = (float)((double)dmg + 0.75 * (double)EnchantmentHelper.func_152377_a((ItemStack)attacker.func_184592_cb(), (EnumCreatureAttribute)living.func_70668_bt()));
                float knockbackStrength = 0.6125f * attacker.getSizeVariation();
                living.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)attacker), dmg);
                living.func_70653_a(entity, knockbackStrength, 1.0, 1.0);
            }
        });
    }

    @Override
    public void stopAttack(AbstractEntityCQR attacker, EntityLivingBase target) {
    }

    @Override
    public void resetAttack(AbstractEntityCQR attacker) {
        attacker.setSpinToWin(false);
        this.ticksCollided = 0;
    }
}

