/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.entity.ai;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import team.cqr.cqrepoured.entity.ai.AbstractCQREntityAI;
import team.cqr.cqrepoured.entity.ai.target.TargetUtil;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;

public class EntityAISearchMount
extends AbstractCQREntityAI<AbstractEntityCQR> {
    public static final String TAG_TAMED_BY_CQR_MOB = "tamed_by_cqr_mob";
    protected static final double MOUNT_SEARCH_RADIUS = 16.0;
    protected static final double DISTANCE_TO_MOUNT = 2.0;
    protected static final boolean FORCE_MOUNTING = true;
    protected static final double WALK_SPEED_TO_MOUNT = 1.0;
    protected EntityLiving entityToMount = null;

    public EntityAISearchMount(AbstractEntityCQR entity) {
        super(entity);
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (!this.entity.canMountEntity()) {
            return false;
        }
        if (this.entity.func_184218_aH()) {
            return false;
        }
        if (this.random.nextInt(20) == 0) {
            boolean hasSaddle = this.hasSaddle();
            Vec3d vec1 = this.entity.func_174791_d().func_72441_c(16.0, 8.0, 16.0);
            Vec3d vec2 = this.entity.func_174791_d().func_178786_a(16.0, 8.0, 16.0);
            AxisAlignedBB aabb = new AxisAlignedBB(vec1.field_72450_a, vec1.field_72448_b, vec1.field_72449_c, vec2.field_72450_a, vec2.field_72448_b, vec2.field_72449_c);
            List possibleMounts = this.world.func_175647_a(EntityLiving.class, aabb, input -> {
                if (!TargetUtil.PREDICATE_MOUNTS.apply(input)) {
                    return false;
                }
                if (!this.entity.func_70635_at().func_75522_a((Entity)input)) {
                    return false;
                }
                return hasSaddle || input.func_184216_O().contains(TAG_TAMED_BY_CQR_MOB);
            });
            if (!possibleMounts.isEmpty()) {
                this.entityToMount = (EntityLiving)TargetUtil.getNearestEntity((EntityLiving)this.entity, possibleMounts);
                return true;
            }
        }
        return false;
    }

    private boolean hasSaddle() {
        return this.isSaddle(this.entity.func_184614_ca()) || this.isSaddle(this.entity.func_184592_cb());
    }

    private boolean isSaddle(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() == Items.field_151141_av;
    }

    public boolean func_75253_b() {
        if (!this.entity.canMountEntity()) {
            return false;
        }
        if (this.entity.func_184218_aH()) {
            return false;
        }
        if (this.entityToMount == null) {
            return false;
        }
        if (!this.hasSaddle() && !this.entityToMount.func_184216_O().contains(TAG_TAMED_BY_CQR_MOB)) {
            return false;
        }
        if (!this.entityToMount.func_70089_S()) {
            return false;
        }
        if (this.entityToMount.func_184207_aI()) {
            return false;
        }
        if ((double)this.entity.func_70032_d((Entity)this.entityToMount) > 16.0) {
            return false;
        }
        return this.entity.func_70781_l();
    }

    public void func_75249_e() {
        if ((double)this.entity.func_70032_d((Entity)this.entityToMount) > 2.0) {
            this.entity.func_70661_as().func_75497_a((Entity)this.entityToMount, 1.0);
        }
    }

    public void func_75246_d() {
        if ((double)this.entity.func_70032_d((Entity)this.entityToMount) > 2.0) {
            this.entity.func_70661_as().func_75497_a((Entity)this.entityToMount, 1.0);
        } else {
            if (this.entityToMount instanceof AbstractHorse) {
                AbstractHorse horse = (AbstractHorse)this.entityToMount;
                horse.func_184779_b(this.entity.getPersistentID());
                this.world.func_72960_a((Entity)horse, (byte)7);
                horse.func_110234_j(true);
                horse.func_110251_o(true);
                horse.func_174820_d(400, new ItemStack(Items.field_151141_av));
                horse.func_174820_d(401, new ItemStack(Items.field_151138_bX));
            }
            this.entity.func_70661_as().func_75499_g();
            this.entity.func_184205_a((Entity)this.entityToMount, true);
            if (!this.entityToMount.func_184216_O().contains(TAG_TAMED_BY_CQR_MOB)) {
                this.entityToMount.func_184211_a(TAG_TAMED_BY_CQR_MOB);
                if (this.isSaddle(this.entity.func_184614_ca())) {
                    this.entity.func_184614_ca().func_190918_g(1);
                } else if (this.isSaddle(this.entity.func_184592_cb())) {
                    this.entity.func_184592_cb().func_190918_g(1);
                }
            }
        }
    }

    public void func_75251_c() {
        this.entityToMount = null;
        this.entity.func_70661_as().func_75499_g();
    }
}

