/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.model.entity.boss;

import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import team.cqr.cqrepoured.client.model.geo.ModelGeoCQRBase;
import team.cqr.cqrepoured.entity.boss.endercalamity.EntityCQREnderCalamity;

public class ModelEnderCalamity
extends ModelGeoCQRBase<EntityCQREnderCalamity> {
    private static final ResourceLocation ANIMATION_RESLOC = new ResourceLocation("cqrepoured", "animations/ender_calamity.animation.json");
    private static final String BONE_IDENT_ROOT = "root";
    private static final String BONE_IDENT_BODY = "body";

    public ModelEnderCalamity(ResourceLocation model, ResourceLocation textureDefault, String entityName) {
        super(model, textureDefault, entityName);
    }

    public ResourceLocation getAnimationFileLocation(EntityCQREnderCalamity animatable) {
        return ANIMATION_RESLOC;
    }

    public void setLivingAnimations(EntityCQREnderCalamity entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone rootBone = this.getAnimationProcessor().getBone(BONE_IDENT_ROOT);
        IBone bodyBone = this.getAnimationProcessor().getBone(BONE_IDENT_BODY);
        float correctPitch = bodyBone.getRotationX();
        if (entity.rotateBodyPitch()) {
            float pitch = (float)Math.toRadians(this.getPitch(entity, customPredicate.getPartialTick()) - 90.0f);
            bodyBone.setRotationX(pitch -= rootBone.getRotationX());
        } else {
            bodyBone.setRotationX(correctPitch);
        }
    }

    protected float getPitch(EntityCQREnderCalamity entity, float partialTicks) {
        return this.interpolateRotation(entity.prevRotationPitchCQR, entity.rotationPitchCQR, partialTicks);
    }

    protected float interpolateRotation(float prevRotation, float rotation, float partialTicks) {
        return prevRotation + MathHelper.func_76142_g((float)(rotation - prevRotation)) * partialTicks;
    }
}

