/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.model.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.item.ItemHookshotBase;
import team.cqr.cqrepoured.item.gun.ItemMusket;
import team.cqr.cqrepoured.item.gun.ItemRevolver;
import team.cqr.cqrepoured.item.spear.ItemSpearBase;
import team.cqr.cqrepoured.item.sword.ItemGreatSword;

public class ModelCQRBiped
extends ModelBiped {
    public ModelRenderer bipedLeftArmwear = null;
    public ModelRenderer bipedRightArmwear = null;
    public ModelRenderer bipedLeftLegwear = null;
    public ModelRenderer bipedRightLegwear = null;
    public ModelRenderer bipedBodyWear = null;
    public ModelRenderer bipedCape = null;
    public boolean hasExtraLayers = true;

    public ModelCQRBiped(int textureWidthIn, int textureHeightIn, boolean hasExtraLayer) {
        super(0.0f, 0.0f, textureWidthIn, textureHeightIn);
        this.hasExtraLayers = hasExtraLayer;
        this.bipedCape = new ModelRenderer((ModelBase)this, 0, 0);
        this.bipedCape.func_78787_b(64, 32);
        this.bipedCape.func_78790_a(-5.0f, 0.0f, -1.0f, 10, 16, 1, 0.0f);
        this.field_178724_i = new ModelRenderer((ModelBase)this, 32, 48);
        this.field_178724_i.func_78790_a(-1.0f, -2.0f, -2.0f, 4, 12, 4, 0.0f);
        this.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
        this.field_178722_k = new ModelRenderer((ModelBase)this, 16, 48);
        this.field_178722_k.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, 0.0f);
        this.field_178722_k.func_78793_a(1.9f, 12.0f, 0.0f);
        this.initExtraLayer();
        this.setClothingLayerVisible(hasExtraLayer);
    }

    protected void initExtraLayer() {
        this.field_178724_i = new ModelRenderer((ModelBase)this, 32, 48);
        this.field_178724_i.func_78790_a(-1.0f, -2.0f, -2.0f, 4, 12, 4, 0.0f);
        this.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
        this.bipedRightArmwear = new ModelRenderer((ModelBase)this, 40, 32);
        this.bipedRightArmwear.func_78790_a(-3.0f, -2.0f, -2.0f, 4, 12, 4, 0.25f);
        this.bipedRightArmwear.func_78793_a(-5.0f, 2.0f, 10.0f);
        this.bipedLeftArmwear = new ModelRenderer((ModelBase)this, 48, 48);
        this.bipedLeftArmwear.func_78790_a(-1.0f, -2.0f, -2.0f, 4, 12, 4, 0.25f);
        this.bipedLeftArmwear.func_78793_a(5.0f, 2.0f, 0.0f);
        this.bipedLeftLegwear = new ModelRenderer((ModelBase)this, 0, 48);
        this.bipedLeftLegwear.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, 0.25f);
        this.bipedLeftLegwear.func_78793_a(1.9f, 12.0f, 0.0f);
        this.bipedRightLegwear = new ModelRenderer((ModelBase)this, 0, 32);
        this.bipedRightLegwear.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, 0.25f);
        this.bipedRightLegwear.func_78793_a(-1.9f, 12.0f, 0.0f);
        this.bipedBodyWear = new ModelRenderer((ModelBase)this, 16, 32);
        this.bipedBodyWear.func_78790_a(-4.0f, 0.0f, -2.0f, 8, 12, 4, 0.25f);
        this.bipedBodyWear.func_78793_a(0.0f, 0.0f, 0.0f);
    }

    public void setRotateAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    public void renderCape(float scale) {
        this.bipedCape.func_78785_a(scale);
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entityIn) {
        ItemStack stack;
        boolean isSpinToWinActive;
        boolean bl = isSpinToWinActive = entityIn instanceof AbstractEntityCQR && ((AbstractEntityCQR)entityIn).isSpinToWinActive() && !this.field_78093_q;
        if (isSpinToWinActive) {
            limbSwing = 0.0f;
            limbSwingAmount = 0.0f;
            float f = ageInTicks * 16.0f;
            GlStateManager.func_179114_b((float)f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        this.bipedCape.field_78797_d = entityIn.func_70093_af() ? 2.0f : 0.0f;
        super.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor, entityIn);
        if (entityIn instanceof AbstractEntityCQR) {
            AbstractEntityCQR cqrEnt = (AbstractEntityCQR)entityIn;
            if (isSpinToWinActive) {
                this.field_178724_i.field_78808_h = (float)Math.toRadians(-90.0);
                this.field_178723_h.field_78808_h = (float)Math.toRadians(90.0);
            } else if (cqrEnt.isSpellCharging() && cqrEnt.isSpellAnimated()) {
                this.renderSpellAnimation(cqrEnt, ageInTicks);
            } else {
                boolean flagSide;
                boolean bl2 = flagSide = cqrEnt.func_184591_cq() == EnumHandSide.LEFT;
                if (cqrEnt.hasAttackTarget() && (cqrEnt.func_184614_ca().func_77973_b() instanceof ItemRevolver || cqrEnt.func_184614_ca().func_77973_b() instanceof ItemHookshotBase) && !(cqrEnt.func_184614_ca().func_77973_b() instanceof ItemMusket)) {
                    if (flagSide) {
                        this.field_178724_i.field_78795_f -= new Float(Math.toRadians(90.0)).floatValue();
                    } else {
                        this.field_178723_h.field_78795_f -= new Float(Math.toRadians(90.0)).floatValue();
                    }
                }
                if (cqrEnt.hasAttackTarget() && (cqrEnt.func_184592_cb().func_77973_b() instanceof ItemRevolver || cqrEnt.func_184592_cb().func_77973_b() instanceof ItemHookshotBase) && !(cqrEnt.func_184592_cb().func_77973_b() instanceof ItemMusket)) {
                    if (flagSide) {
                        this.field_178723_h.field_78795_f -= new Float(Math.toRadians(90.0)).floatValue();
                    } else {
                        this.field_178724_i.field_78795_f -= new Float(Math.toRadians(90.0)).floatValue();
                    }
                }
            }
        }
        if ((stack = ((AbstractEntityCQR)entityIn).func_184614_ca()).func_77973_b() instanceof ItemSpearBase) {
            this.renderSpearHoldingAnimation();
        }
        if (stack.func_77973_b() instanceof ItemGreatSword) {
            this.renderGreatSwordHoldingAnimation();
        }
        ModelCQRBiped.func_178685_a((ModelRenderer)this.field_178722_k, (ModelRenderer)this.bipedLeftLegwear);
        ModelCQRBiped.func_178685_a((ModelRenderer)this.field_178721_j, (ModelRenderer)this.bipedRightLegwear);
        ModelCQRBiped.func_178685_a((ModelRenderer)this.field_178724_i, (ModelRenderer)this.bipedLeftArmwear);
        ModelCQRBiped.func_178685_a((ModelRenderer)this.field_178723_h, (ModelRenderer)this.bipedRightArmwear);
        ModelCQRBiped.func_178685_a((ModelRenderer)this.field_78115_e, (ModelRenderer)this.bipedBodyWear);
    }

    protected void renderSpearHoldingAnimation() {
        float f = (float)Math.toRadians(40.0);
        this.field_78115_e.field_78795_f = 0.0f;
        this.field_78115_e.field_78796_g = f;
        this.field_78115_e.field_78808_h = 0.0f;
        Vec3d v = new Vec3d(-5.0, 0.0, 0.0).func_178785_b(f);
        this.field_178723_h.field_78800_c = (float)v.field_72450_a;
        this.field_178723_h.field_78798_e = (float)v.field_72449_c;
        this.field_178723_h.field_78795_f = 0.0f;
        this.field_178723_h.field_78796_g = f;
        this.field_178723_h.field_78808_h = 0.0f;
        Vec3d v1 = new Vec3d(5.0, 0.0, 0.0).func_178785_b(f);
        this.field_178724_i.field_78800_c = (float)v1.field_72450_a;
        this.field_178724_i.field_78798_e = (float)v1.field_72449_c;
        this.field_178724_i.field_78795_f = 0.0f;
        this.field_178724_i.field_78796_g = f;
        this.field_178724_i.field_78808_h = 0.0f;
        float f1 = MathHelper.func_76126_a((float)(this.field_78095_p * (float)Math.PI));
        this.field_178723_h.field_78795_f += (float)Math.toRadians(-10.0f - 20.0f * f1);
        this.field_178723_h.field_78796_g += (float)Math.toRadians(-45.0);
        this.field_178724_i.field_78795_f += (float)Math.toRadians(-45.0f - 25.0f * f1);
        this.field_178724_i.field_78796_g += (float)Math.toRadians(30.0f - 10.0f * f1);
    }

    protected void renderGreatSwordHoldingAnimation() {
        float f3 = MathHelper.func_76126_a((float)(this.field_78095_p * (float)Math.PI * 2.0f));
        float f = (float)Math.toRadians(20.0f + 30.0f * f3);
        this.field_78115_e.field_78795_f = 0.0f;
        this.field_78115_e.field_78796_g = f;
        this.field_78115_e.field_78808_h = 0.0f;
        if (this.field_78095_p > 0.0f) {
            // empty if block
        }
        Vec3d v = new Vec3d(-5.0, 0.0, 0.0).func_178785_b(f);
        this.field_178723_h.field_78800_c = (float)v.field_72450_a;
        this.field_178723_h.field_78798_e = (float)v.field_72449_c;
        this.field_178723_h.field_78795_f = 0.0f;
        this.field_178723_h.field_78796_g = f;
        this.field_178723_h.field_78808_h = 0.0f;
        Vec3d v1 = new Vec3d(5.0, 0.0, 0.0).func_178785_b(f);
        this.field_178724_i.field_78800_c = (float)v1.field_72450_a;
        this.field_178724_i.field_78798_e = (float)v1.field_72449_c;
        this.field_178724_i.field_78795_f = 0.0f;
        this.field_178724_i.field_78796_g = f;
        this.field_178724_i.field_78808_h = 0.0f;
        float f1 = MathHelper.func_76126_a((float)(this.field_78095_p * (float)Math.PI));
        this.field_178723_h.field_78795_f += (float)Math.toRadians(-40.0f - 60.0f * f1);
        this.field_178723_h.field_78796_g += (float)Math.toRadians(-40.0);
        this.field_178723_h.field_78808_h += (float)Math.toRadians(0.0f * f1);
        this.field_178724_i.field_78795_f += (float)Math.toRadians(-35.0f - 60.0f * f1);
        this.field_178724_i.field_78796_g += (float)Math.toRadians(50.0);
        this.field_178724_i.field_78808_h += (float)Math.toRadians(0.0f * f1);
    }

    protected void renderSpellAnimation(AbstractEntityCQR entity, float ageInTicks) {
        this.field_178723_h.field_78798_e = 0.0f;
        this.field_178723_h.field_78800_c = -5.0f;
        this.field_178724_i.field_78798_e = 0.0f;
        this.field_178724_i.field_78800_c = 5.0f;
        this.field_178723_h.field_78795_f = MathHelper.func_76134_b((float)(ageInTicks * 0.6662f)) * 0.25f;
        this.field_178724_i.field_78795_f = MathHelper.func_76134_b((float)(ageInTicks * 0.6662f)) * 0.25f;
        this.field_178723_h.field_78808_h = 2.3561945f;
        this.field_178724_i.field_78808_h = -2.3561945f;
        this.field_178723_h.field_78796_g = 0.0f;
        this.field_178724_i.field_78796_g = 0.0f;
    }

    public void func_178719_a(boolean visible) {
        super.func_178719_a(visible);
        this.bipedCape.field_78806_j = visible;
        if (this.hasExtraLayers) {
            this.setClothingLayerVisible(visible);
        }
    }

    public void func_78088_a(Entity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, entityIn);
        GlStateManager.func_179094_E();
        if (this.field_78091_s) {
            GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
            GlStateManager.func_179109_b((float)0.0f, (float)(16.0f * scale), (float)0.0f);
            this.field_78116_c.func_78785_a(scale);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179109_b((float)0.0f, (float)(24.0f * scale), (float)0.0f);
            this.field_78115_e.func_78785_a(scale);
            this.field_178723_h.func_78785_a(scale);
            this.field_178724_i.func_78785_a(scale);
            this.field_178721_j.func_78785_a(scale);
            this.field_178722_k.func_78785_a(scale);
            this.field_178720_f.func_78785_a(scale);
        } else {
            if (entityIn.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            }
            this.field_78116_c.func_78785_a(scale);
            this.field_78115_e.func_78785_a(scale);
            this.field_178723_h.func_78785_a(scale);
            this.field_178724_i.func_78785_a(scale);
            this.field_178721_j.func_78785_a(scale);
            this.field_178722_k.func_78785_a(scale);
            this.field_178720_f.func_78785_a(scale);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        if (this.hasExtraLayers) {
            this.bipedLeftLegwear.func_78785_a(scale);
            this.bipedRightLegwear.func_78785_a(scale);
            this.bipedLeftArmwear.func_78785_a(scale);
            this.bipedRightArmwear.func_78785_a(scale);
            this.bipedBodyWear.func_78785_a(scale);
        }
        GlStateManager.func_179121_F();
    }

    protected void setClothingLayerVisible(boolean visible) {
        try {
            this.bipedLeftArmwear.field_78806_j = visible;
            this.bipedRightArmwear.field_78806_j = visible;
            this.bipedLeftLegwear.field_78806_j = visible;
            this.bipedRightLegwear.field_78806_j = visible;
            this.bipedBodyWear.field_78806_j = visible;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void copyModelRotationPoint(ModelRenderer source, ModelRenderer target) {
        if (source == null || target == null) {
            return;
        }
        target.field_78800_c = source.field_78800_c;
        target.field_78797_d = source.field_78797_d;
        target.field_78798_e = source.field_78798_e;
    }
}

