/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.client.init;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.client.particle.ParticleBeam;
import team.cqr.cqrepoured.client.particle.ParticleMagicBell;
import team.cqr.cqrepoured.init.CQRParticleType;

@SideOnly(value=Side.CLIENT)
public class CQRParticleManager {
    private static final Int2ObjectMap<IParticleFactory> ID_PARTICLE_FACTORY_MAP = new Int2ObjectOpenHashMap();

    public static void init() {
        CQRParticleManager.registerParticleFactory(CQRParticleType.BEAM, new ParticleBeam.Factory());
        CQRParticleManager.registerParticleFactory(CQRParticleType.BLOCK_HIGHLIGHT, new ParticleMagicBell.Factory());
    }

    public static void registerParticleFactory(CQRParticleType particleType, IParticleFactory particleFactory) {
        ID_PARTICLE_FACTORY_MAP.put(particleType.getId(), (Object)particleFactory);
    }

    public static void spawnParticlesClient(CQRParticleType particleType, World world, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int count, double xOffset, double yOffset, double zOffset, int ... optionalArguments) {
        if (optionalArguments.length < particleType.getArgumentCount()) {
            CQRMain.logger.warn("Not enough arguments to spawn particle! {}", (Object)particleType);
            return;
        }
        IParticleFactory factory = (IParticleFactory)ID_PARTICLE_FACTORY_MAP.get(particleType.getId());
        if (factory == null) {
            CQRMain.logger.warn("No particle factory found! {}", (Object)particleType);
            return;
        }
        for (int i = 0; i < count; ++i) {
            double x = xCoord;
            double y = yCoord;
            double z = zCoord;
            if (xOffset != 0.0) {
                x += (Math.random() - Math.random()) * xOffset;
            }
            if (yOffset != 0.0) {
                y += (Math.random() - Math.random()) * yOffset;
            }
            if (zOffset != 0.0) {
                z += (Math.random() - Math.random()) * zOffset;
            }
            Particle particle = factory.func_178902_a(particleType.getId(), world, x, y, z, xSpeed, ySpeed, zSpeed, optionalArguments);
            Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
        }
    }
}

