/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.capability.electric;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.network.server.packet.SPacketUpdateElectrocuteCapability;
import team.cqr.cqrepoured.util.EntityUtil;

public class CapabilityElectricShock {
    private final EntityLivingBase entity;
    private UUID originalCasterID;
    private Entity target;
    private int remainingTicks = -1;
    private int cooldown = -1;
    private int remainingSpreads = 16;

    public CapabilityElectricShock(EntityLivingBase entity) {
        this.entity = entity;
        this.originalCasterID = null;
    }

    public NBTBase writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("cooldown", this.cooldown);
        compound.func_74768_a("ticks", this.remainingTicks);
        compound.func_74768_a("remainingSpreads", this.remainingSpreads);
        if (this.target != null) {
            compound.func_74782_a("targetID", (NBTBase)NBTUtil.func_186862_a((UUID)this.target.getPersistentID()));
        }
        if (this.originalCasterID != null) {
            compound.func_74782_a("casterID", (NBTBase)NBTUtil.func_186862_a((UUID)this.originalCasterID));
        }
        return compound;
    }

    public void setRemainingTicks(int value) {
        boolean preUpdateActivity = this.isElectrocutionActive();
        this.remainingTicks = value;
        this.cooldown = 200;
        if (!this.entity.field_70170_p.field_72995_K && preUpdateActivity != this.isElectrocutionActive()) {
            this.sendUpdate();
        }
    }

    protected void sendUpdate() {
        CQRMain.NETWORK.sendToAllTracking((IMessage)new SPacketUpdateElectrocuteCapability(this.entity), (Entity)this.entity);
        if (this.entity instanceof EntityPlayerMP) {
            CQRMain.NETWORK.sendTo((IMessage)new SPacketUpdateElectrocuteCapability(this.entity), (EntityPlayerMP)this.entity);
        }
    }

    public void setCasterID(UUID casterID) {
        this.originalCasterID = casterID;
    }

    @Nullable
    public UUID getCasterID() {
        return this.originalCasterID;
    }

    public boolean isElectrocutionActive() {
        return this.remainingTicks > 0;
    }

    @Nullable
    public Entity getTarget() {
        return this.target;
    }

    public void setTarget(Entity entity) {
        Entity preUpdateTarget = this.target;
        this.target = entity;
        if (!this.entity.field_70170_p.field_72995_K && preUpdateTarget != this.getTarget()) {
            this.sendUpdate();
        }
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public boolean reduceRemainingTicks() {
        boolean preUpdateActivity = this.isElectrocutionActive();
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.remainingTicks < 0) {
            this.target = null;
            return false;
        }
        --this.remainingTicks;
        if (!this.entity.field_70170_p.field_72995_K && preUpdateActivity != this.isElectrocutionActive()) {
            this.sendUpdate();
        }
        return this.remainingTicks >= 0;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.remainingTicks = nbt.func_74762_e("ticks");
        this.cooldown = nbt.func_74762_e("cooldown");
        this.remainingSpreads = nbt.func_74762_e("remainingSpreads");
        if (nbt.func_150297_b("targetID", 10)) {
            UUID targetID = NBTUtil.func_186860_b((NBTTagCompound)nbt.func_74775_l("targetID"));
            this.target = EntityUtil.getEntityByUUID(this.entity.func_130014_f_(), targetID);
        }
        if (nbt.func_150297_b("casterID", 10)) {
            this.originalCasterID = NBTUtil.func_186860_b((NBTTagCompound)nbt.func_74775_l("casterID"));
        }
    }

    public int getRemainignSpreads() {
        return this.remainingSpreads;
    }

    public void reduceSpreads() {
        --this.remainingSpreads;
    }

    public void setRemainingSpreads(int remainignSpreads) {
        this.remainingSpreads = remainignSpreads;
    }

    public boolean canSpread() {
        return this.remainingTicks >= 20;
    }
}

