/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.capability;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import team.cqr.cqrepoured.capability.armor.CapabilityCooldownHandlerProvider;
import team.cqr.cqrepoured.capability.electric.CapabilityElectricShockProvider;
import team.cqr.cqrepoured.capability.extraitemhandler.CapabilityExtraItemHandlerProvider;
import team.cqr.cqrepoured.capability.protectedregions.CapabilityProtectedRegionDataProvider;
import team.cqr.cqrepoured.entity.bases.AbstractEntityCQR;

@Mod.EventBusSubscriber(modid="cqrepoured")
public class CapabilityHandler {
    @SubscribeEvent
    public static void onEntityAttachCapabilitiesEvent(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityLivingBase) {
            event.addCapability(CapabilityCooldownHandlerProvider.REGISTRY_NAME, (ICapabilityProvider)CapabilityCooldownHandlerProvider.createProvider());
        }
        if (event.getObject() instanceof AbstractEntityCQR) {
            event.addCapability(CapabilityExtraItemHandlerProvider.REGISTRY_NAME, (ICapabilityProvider)CapabilityExtraItemHandlerProvider.createProvider(3));
        }
        if (event.getObject() instanceof EntityLivingBase) {
            event.addCapability(CapabilityElectricShockProvider.REGISTRY_NAME, (ICapabilityProvider)CapabilityElectricShockProvider.createProvider((EntityLivingBase)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void onChunkAttachCapabilitiesEvent(AttachCapabilitiesEvent<Chunk> event) {
        event.addCapability(CapabilityProtectedRegionDataProvider.LOCATION, (ICapabilityProvider)CapabilityProtectedRegionDataProvider.createProvider((Chunk)event.getObject()));
    }

    public static void writeToItemStackNBT(ItemStack stack, String key, NBTTagCompound compound) {
        NBTTagCompound stackCompound = stack.func_77978_p();
        if (stackCompound == null) {
            stackCompound = new NBTTagCompound();
            stack.func_77982_d(stackCompound);
        }
        stackCompound.func_74782_a(key, (NBTBase)compound);
    }

    public static NBTTagCompound readFromItemStackNBT(ItemStack stack, String key) {
        NBTTagCompound stackCompound = stack.func_77978_p();
        return stackCompound != null ? stackCompound.func_74775_l(key) : new NBTTagCompound();
    }
}

