/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.csg;

import com.brandon3055.csg.LogHelper;
import com.brandon3055.csg.lib.PlayerSlot;
import com.brandon3055.csg.lib.StackReference;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.io.IOUtils;

public class DataManager {
    private static File configFile;
    public static Map<PlayerSlot, StackReference> spawnInventory;
    public static Map<String, Map<PlayerSlot, StackReference>> kits;

    public static void initialize(File config) {
        File cManager = new File(config, "brandon3055/CSG");
        if (!cManager.exists()) {
            cManager.mkdirs();
        }
        configFile = new File(cManager, "Config.json");
        try {
            DataManager.loadConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveConfig() throws IOException {
        if (spawnInventory == null) {
            LogHelper.error("Could not save config because inventory array was null!");
            return;
        }
        JsonObject obj = new JsonObject();
        JsonObject inv = new JsonObject();
        spawnInventory.forEach((playerSlot, stackReference) -> inv.addProperty(playerSlot.toString(), stackReference.toString()));
        obj.add("inventory", (JsonElement)inv);
        if (kits.size() > 0) {
            JsonObject kitsObj = new JsonObject();
            kits.forEach((name, kit) -> {
                JsonObject kitObj = new JsonObject();
                kit.forEach((playerSlot, stackReference) -> kitObj.addProperty(playerSlot.toString(), stackReference.toString()));
                kitsObj.add(name, (JsonElement)kitObj);
            });
            obj.add("kits", (JsonElement)kitsObj);
        }
        JsonWriter writer = new JsonWriter((Writer)new FileWriter(configFile));
        writer.setIndent("  ");
        Streams.write((JsonElement)obj, (JsonWriter)writer);
        writer.flush();
        IOUtils.closeQuietly((Closeable)writer);
    }

    public static void loadConfig() throws IOException {
        if (!configFile.exists()) {
            spawnInventory = null;
            LogHelper.warn("Custom Spawn Inventory has not been configured yet! Canceling config load!");
            return;
        }
        JsonParser parser = new JsonParser();
        FileReader reader = new FileReader(configFile);
        JsonElement element = parser.parse((Reader)reader);
        IOUtils.closeQuietly((Reader)reader);
        if (!element.isJsonObject()) {
            LogHelper.warn("Detected invalid config json! Canceling config load!");
            return;
        }
        JsonObject obj = element.getAsJsonObject();
        if (obj.has("inventory") && obj.get("inventory").isJsonObject()) {
            LogHelper.info("Reading starting inventory config");
            spawnInventory = new HashMap<PlayerSlot, StackReference>();
            JsonObject inv = obj.get("inventory").getAsJsonObject();
            inv.entrySet().forEach(entry -> {
                PlayerSlot slot = PlayerSlot.fromString((String)entry.getKey());
                StackReference stack = StackReference.fromString(((JsonElement)entry.getValue()).getAsJsonPrimitive().getAsString());
                spawnInventory.put(slot, stack);
            });
            LogHelper.info("Loaded " + spawnInventory.size() + " starting items.");
        }
        if (obj.has("kits") && obj.get("kits").isJsonObject()) {
            LogHelper.info("Reading kits from config");
            JsonObject kits = obj.get("kits").getAsJsonObject();
            kits.entrySet().forEach(entry -> {
                String name = (String)entry.getKey();
                JsonObject items = ((JsonElement)entry.getValue()).getAsJsonObject();
                Map kitMap = kits.computeIfAbsent(name, s -> new HashMap());
                items.entrySet().forEach(kitEntry -> {
                    PlayerSlot slot = PlayerSlot.fromString((String)kitEntry.getKey());
                    StackReference stack = StackReference.fromString(((JsonElement)kitEntry.getValue()).getAsJsonPrimitive().getAsString());
                    kitMap.put(slot, stack);
                });
                LogHelper.info("Loaded " + kitMap.size() + " items for kit " + name);
            });
        }
    }

    public static void givePlayerStartGear(EntityPlayer player) {
        if (spawnInventory == null) {
            player.func_145747_a(new TextComponentString("Custom Starting Gear has not been configured!").func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
            player.func_145747_a((ITextComponent)new TextComponentString("If you are an operator use /csg_config to get more info."));
            return;
        }
        player.field_71071_by.func_174888_l();
        for (PlayerSlot slot : spawnInventory.keySet()) {
            ItemStack stack = spawnInventory.get(slot).createStack();
            if (stack == null) {
                player.func_145747_a((ITextComponent)new TextComponentString("[CSG] Something went wrong! Could not create stack - " + spawnInventory.get(slot).toString()));
                continue;
            }
            slot.setStackInSlot(player, stack);
        }
    }

    public static void givePlayerKit(EntityPlayer player, String kit) {
        if (!kits.containsKey(kit)) {
            player.func_145747_a(new TextComponentString("The requested kit \"" + kit + "\" does not exist!").func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
            return;
        }
        Map<PlayerSlot, StackReference> kitItems = kits.get(kit);
        player.field_71071_by.func_174888_l();
        for (PlayerSlot slot : kitItems.keySet()) {
            ItemStack stack = kitItems.get(slot).createStack();
            if (stack == null) {
                player.func_145747_a((ITextComponent)new TextComponentString("[CSG] Something went wrong! Could not create stack - " + kitItems.get(slot).toString()));
                continue;
            }
            slot.setStackInSlot(player, stack);
        }
    }

    static {
        spawnInventory = null;
        kits = new LinkedHashMap<String, Map<PlayerSlot, StackReference>>();
    }
}

