/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.torocraft.torohealth.config.ConfigurationHandler;
import net.torocraft.torohealth.display.BarDisplay;
import net.torocraft.torohealth.display.EntityDisplay;
import net.torocraft.torohealth.display.HeartsDisplay;
import net.torocraft.torohealth.display.NumericDisplay;
import net.torocraft.torohealth.display.ToroHealthDisplay;

public class GuiEntityStatus
extends Gui {
    private static final int PADDING_FROM_EDGE = 3;
    private static final ResourceLocation SKIN_BASIC = new ResourceLocation("torohealthmod", "textures/gui/default_skin_basic.png");
    private static final ResourceLocation SKIN_HEAVY = new ResourceLocation("torohealthmod", "textures/gui/default_skin_heavy.png");
    private final Minecraft mc;
    private final ToroHealthDisplay entityDisplay;
    private final ToroHealthDisplay heartsDisplay;
    private final ToroHealthDisplay numericDisplay;
    private final ToroHealthDisplay barDisplay;
    int screenX = 3;
    int screenY = 3;
    int displayHeight;
    int displayWidth;
    int x;
    int y;
    private EntityLivingBase entity;
    private int age = 0;
    private boolean showHealthBar = false;

    public GuiEntityStatus() {
        this(Minecraft.func_71410_x());
    }

    public GuiEntityStatus(Minecraft mc) {
        this.mc = mc;
        this.entityDisplay = new EntityDisplay(mc);
        this.heartsDisplay = new HeartsDisplay(mc, this);
        this.numericDisplay = new NumericDisplay(mc, this);
        this.barDisplay = new BarDisplay(mc, this);
        this.entityDisplay.setPosition(50, 50);
        this.heartsDisplay.setPosition(25, 150);
        this.numericDisplay.setPosition(130, 150);
        this.barDisplay.setPosition(25, 200);
    }

    @SubscribeEvent
    public void drawHealthBar(RenderGameOverlayEvent.Pre event) {
        if (!this.showHealthBar || event.getType() != RenderGameOverlayEvent.ElementType.CHAT) {
            return;
        }
        this.updateGuiAge();
        if (!this.checkRange()) {
            return;
        }
        this.updatePositions();
        this.drawSkin();
        this.draw();
    }

    private boolean checkRange() {
        if (this.entity == null) {
            return false;
        }
        Float range = ConfigurationHandler.displayRange;
        return range.floatValue() <= 0.0f || this.entity.func_70068_e(Minecraft.func_71410_x().func_175606_aa()) <= (double)(range.floatValue() * range.floatValue());
    }

    private void drawSkin() {
        if (ConfigurationHandler.skin.equals("NONE")) {
            return;
        }
        if (ConfigurationHandler.skin.equals("HEAVY")) {
            this.mc.func_110434_K().func_110577_a(SKIN_HEAVY);
        } else {
            this.mc.func_110434_K().func_110577_a(SKIN_BASIC);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Gui.func_146110_a((int)(this.screenX - 10), (int)(this.screenY - 10), (float)0.0f, (float)0.0f, (int)160, (int)60, (float)160.0f, (float)60.0f);
    }

    private void updateGuiAge() {
        String entityStatusDisplay = ConfigurationHandler.entityStatusDisplay;
        this.age += 15;
        if (this.age > ConfigurationHandler.hideDelay || entityStatusDisplay.equals("OFF")) {
            this.hideHealthBar();
        }
    }

    private void updatePositions() {
        this.adjustForDisplayPositionSetting();
        this.x = this.screenX;
        this.y = this.screenY;
        if (ConfigurationHandler.showEntityModel) {
            this.entityDisplay.setPosition(this.x, this.y);
            this.x += 40;
        }
        if (ConfigurationHandler.statusDisplayPosition.contains("BOTTOM")) {
            this.y += 6;
        }
        this.numericDisplay.setPosition(this.x, this.y);
        this.barDisplay.setPosition(this.x, this.y);
        this.heartsDisplay.setPosition(this.x, this.y);
    }

    private void draw() {
        if (ConfigurationHandler.showEntityModel) {
            this.entityDisplay.draw();
        }
        if ("NUMERIC".equals(ConfigurationHandler.entityStatusDisplay)) {
            this.numericDisplay.draw();
        } else if ("BAR".equals(ConfigurationHandler.entityStatusDisplay)) {
            this.barDisplay.draw();
        } else if ("HEARTS".equals(ConfigurationHandler.entityStatusDisplay)) {
            this.heartsDisplay.draw();
        }
    }

    private void adjustForDisplayPositionSetting() {
        if (ConfigurationHandler.showEntityModel) {
            this.displayHeight = 40;
            this.displayWidth = 140;
        } else {
            this.displayHeight = 32;
            this.displayWidth = 100;
        }
        ScaledResolution viewport = new ScaledResolution(this.mc);
        String displayPosition = ConfigurationHandler.statusDisplayPosition;
        int sh = viewport.func_78328_b();
        int sw = viewport.func_78326_a();
        if (displayPosition.contains("TOP") || displayPosition.equals("CUSTOM")) {
            this.screenY = 3;
        }
        if (displayPosition.contains("BOTTOM")) {
            this.screenY = sh - this.displayHeight - 3;
        }
        if (displayPosition.contains("LEFT") || displayPosition.equals("CUSTOM")) {
            this.screenX = 3;
        }
        if (displayPosition.contains("RIGHT")) {
            this.screenX = sw - this.displayWidth - 3;
        }
        if (displayPosition.contains("CENTER")) {
            this.screenX = (sw - this.displayWidth) / 2;
        }
        this.screenX += ConfigurationHandler.statusDisplayX.intValue();
        this.screenY += ConfigurationHandler.statusDisplayY.intValue();
    }

    private void showHealthBar() {
        this.showHealthBar = true;
    }

    private void hideHealthBar() {
        this.showHealthBar = false;
    }

    public void setEntity(EntityLivingBase entityToTrack) {
        this.showHealthBar();
        this.age = 0;
        if (this.entity != null && this.entity.func_110124_au().equals(entityToTrack.func_110124_au())) {
            return;
        }
        this.entity = entityToTrack;
        this.entityDisplay.setEntity(this.entity);
        this.heartsDisplay.setEntity(this.entity);
        this.numericDisplay.setEntity(this.entity);
        this.barDisplay.setEntity(this.entity);
    }
}

