/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth.display;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.util.math.MathHelper;
import net.torocraft.torohealth.display.ToroHealthDisplay;

public class EntityDisplay
implements ToroHealthDisplay {
    private static final int RENDER_HEIGHT = 30;
    private static final int RENDER_WIDTH = 18;
    private static final int PADDING = 2;
    private static final int WIDTH = 40;
    private static final int HEIGHT = 40;
    private int y;
    private float glX;
    private float glY;
    private EntityLivingBase entity;
    private Entity leashedToEntity;
    private float prevYawOffset;
    private float prevYaw;
    private float prevPitch;
    private float prevYawHead;
    private float prevPrevYahHead;
    private int scale = 1;

    public EntityDisplay(Minecraft mc) {
    }

    @Override
    public void setPosition(int x, int y) {
        this.y = y;
        this.glX = (float)x + 20.0f;
        this.updateScale();
    }

    @Override
    public void setEntity(EntityLivingBase entity) {
        this.entity = entity;
        this.updateScale();
    }

    @Override
    public void draw() {
        try {
            this.pushEntityLeasedTo();
            this.pushEntityRotations();
            this.glDraw();
            this.popEntityRotations();
            this.popEntityLeasedTo();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void updateScale() {
        if (this.entity == null) {
            this.glY = (float)this.y + 40.0f - 2.0f;
            return;
        }
        int scaleY = MathHelper.func_76123_f((float)(30.0f / this.entity.field_70131_O));
        int scaleX = MathHelper.func_76123_f((float)(18.0f / this.entity.field_70130_N));
        this.scale = Math.min(scaleX, scaleY);
        this.glY = (float)this.y + 35.0f;
        if (this.entity instanceof EntityGhast) {
            this.glY -= 10.0f;
        }
    }

    private void glDraw() {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.glX, (float)this.glY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-this.scale), (float)this.scale, (float)this.scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-100.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)this.entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    private void popEntityLeasedTo() {
        if (this.entity instanceof EntityLiving && this.leashedToEntity != null) {
            ((EntityLiving)this.entity).func_110162_b(this.leashedToEntity, false);
            this.leashedToEntity = null;
        }
    }

    private void pushEntityLeasedTo() {
        if (this.entity instanceof EntityLiving && ((EntityLiving)this.entity).func_110167_bD()) {
            this.leashedToEntity = ((EntityLiving)this.entity).func_110166_bE();
            ((EntityLiving)this.entity).func_110162_b(null, false);
        }
    }

    private void popEntityRotations() {
        this.entity.field_70761_aq = this.prevYawOffset;
        this.entity.field_70177_z = this.prevYaw;
        this.entity.field_70125_A = this.prevPitch;
        this.entity.field_70759_as = this.prevYawHead;
        this.entity.field_70758_at = this.prevPrevYahHead;
    }

    private void pushEntityRotations() {
        this.prevYawOffset = this.entity.field_70761_aq;
        this.prevYaw = this.entity.field_70177_z;
        this.prevPitch = this.entity.field_70125_A;
        this.prevYawHead = this.entity.field_70759_as;
        this.prevPrevYahHead = this.entity.field_70758_at;
        this.entity.field_70761_aq = 0.0f;
        this.entity.field_70177_z = 0.0f;
        this.entity.field_70125_A = 0.0f;
        this.entity.field_70759_as = 0.0f;
        this.entity.field_70758_at = 0.0f;
    }
}

