/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth.display;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.torocraft.torohealth.display.AbstractHealthDisplay;
import net.torocraft.torohealth.display.ToroHealthDisplay;

public class BarDisplay
extends AbstractHealthDisplay
implements ToroHealthDisplay {
    private static final ResourceLocation GUI_BARS_TEXTURES = new ResourceLocation("torohealthmod", "textures/gui/bars.png");
    private static final int BAR_WIDTH = 92;
    private final Minecraft mc;
    private final Gui gui;
    private int y;
    private int barX;
    private int barY;

    public BarDisplay(Minecraft mc, Gui gui) {
        this.mc = mc;
        this.gui = gui;
    }

    @Override
    public void setPosition(int x, int y) {
        this.y = y;
        this.barX = x + 4;
        this.barY = y + 12;
    }

    @Override
    public void draw() {
        if (this.entity == null) {
            return;
        }
        this.renderBossHealth();
    }

    public void renderBossHealth() {
        String name = this.getEntityName();
        String health = (int)Math.ceil(this.entity.func_110143_aJ()) + "/" + (int)this.entity.func_110138_aP();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.func_110434_K().func_110577_a(GUI_BARS_TEXTURES);
        this.renderHealthBar();
        this.mc.field_71466_p.func_175063_a(name, (float)this.barX, (float)(this.y + 2), 0xFFFFFF);
        this.mc.field_71466_p.func_175063_a(health, (float)this.barX, (float)(this.y + 20), 0xFFFFFF);
    }

    private void renderHealthBar() {
        Color color = this.determineColor();
        float percent = this.entity.func_110143_aJ() / this.entity.func_110138_aP();
        this.gui.func_73729_b(this.barX, this.barY, 0, color.ordinal() * 5 * 2, 92, 5);
        int healthWidth = (int)(percent * 92.0f);
        if (healthWidth > 0) {
            this.gui.func_73729_b(this.barX, this.barY, 0, color.ordinal() * 5 * 2 + 5, healthWidth, 5);
        }
    }

    private Color determineColor() {
        switch (this.determineRelation()) {
            case FOE: {
                return Color.RED;
            }
            case FRIEND: {
                return Color.GREEN;
            }
        }
        return Color.WHITE;
    }

    public static enum Relation {
        FRIEND,
        FOE,
        UNKNOWN;

    }

    public static enum Color {
        PINK,
        BLUE,
        RED,
        GREEN,
        YELLOW,
        PURPLE,
        WHITE;

    }
}

