/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.translation.I18n;
import slimeknights.mantle.util.RecipeMatchRegistry;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.IToolMod;
import slimeknights.tconstruct.library.modifiers.ModifierAspect;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public abstract class Modifier
extends RecipeMatchRegistry
implements IModifier {
    public static final String LOC_Name = "modifier.%s.name";
    public static final String LOC_Desc = "modifier.%s.desc";
    public static final String LOC_Extra = "modifier.%s.extra";
    protected static final Random random = new Random();
    public final String identifier;
    protected final List<ModifierAspect> aspects = Lists.newLinkedList();
    private static final AttributeModifier ANTI_KNOCKBACK_MOD = new AttributeModifier("Anti Modifier Knockback", 1.0, 0);

    public Modifier(String identifier) {
        this.identifier = Util.sanitizeLocalizationString(identifier);
        TinkerRegistry.registerModifier(this);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    protected void addAspects(ModifierAspect ... aspects) {
        this.aspects.addAll(Arrays.asList(aspects));
    }

    @Override
    public final boolean canApply(ItemStack stack, ItemStack original) throws TinkerGuiException {
        Set<Enchantment> enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack).keySet();
        NBTTagList traits = TagUtil.getTraitsTagList(stack);
        for (int i = 0; i < traits.func_74745_c(); ++i) {
            String id = traits.func_150307_f(i);
            ITrait trait = TinkerRegistry.getTrait(id);
            if (trait == null) continue;
            if (!this.canApplyTogether(trait) || !trait.canApplyTogether(this)) {
                throw new TinkerGuiException(Util.translateFormatted("gui.error.incompatible_trait", this.getLocalizedName(), trait.getLocalizedName()));
            }
            Modifier.canApplyWithEnchantment(trait, enchantments);
        }
        NBTTagList modifiers = TagUtil.getBaseModifiersTagList(stack);
        for (int i = 0; i < modifiers.func_74745_c(); ++i) {
            String id = modifiers.func_150307_f(i);
            IModifier mod = TinkerRegistry.getModifier(id);
            if (mod == null) continue;
            if (!this.canApplyTogether(mod) || !mod.canApplyTogether(this)) {
                throw new TinkerGuiException(Util.translateFormatted("gui.error.incompatible_modifiers", this.getLocalizedName(), mod.getLocalizedName()));
            }
            Modifier.canApplyWithEnchantment(mod, enchantments);
        }
        Modifier.canApplyWithEnchantment(this, enchantments);
        for (ModifierAspect aspect : this.aspects) {
            if (aspect.canApply(stack, original)) continue;
            return false;
        }
        return this.canApplyCustom(stack);
    }

    private static void canApplyWithEnchantment(IToolMod iToolMod, Set<Enchantment> enchantments) throws TinkerGuiException {
        for (Enchantment enchantment : enchantments) {
            if (iToolMod.canApplyTogether(enchantment)) continue;
            String enchName = I18n.func_74838_a((String)enchantment.func_77320_a());
            throw new TinkerGuiException(Util.translateFormatted("gui.error.incompatible_enchantments", iToolMod.getLocalizedName(), enchName));
        }
    }

    @Override
    public boolean canApplyTogether(Enchantment enchantment) {
        return true;
    }

    @Override
    public boolean canApplyTogether(IToolMod otherModifier) {
        return true;
    }

    protected boolean canApplyCustom(ItemStack stack) throws TinkerGuiException {
        return true;
    }

    @Override
    public void updateNBT(NBTTagCompound modifierTag) {
    }

    @Override
    public void apply(ItemStack stack) {
        NBTTagCompound root = TagUtil.getTagSafe(stack);
        this.apply(root);
        stack.func_77982_d(root);
    }

    @Override
    public void apply(NBTTagCompound root) {
        NBTTagList tagList;
        if (!TinkerUtil.hasModifier(root, this.getIdentifier())) {
            tagList = TagUtil.getBaseModifiersTagList(root);
            tagList.func_74742_a((NBTBase)new NBTTagString(this.getIdentifier()));
            TagUtil.setBaseModifiersTagList(root, tagList);
        }
        NBTTagCompound modifierTag = new NBTTagCompound();
        tagList = TagUtil.getModifiersTagList(root);
        int index = TinkerUtil.getIndexInList(tagList, this.identifier);
        if (index >= 0) {
            modifierTag = tagList.func_150305_b(index);
        }
        for (ModifierAspect aspect : this.aspects) {
            aspect.updateNBT(root, modifierTag);
        }
        this.updateNBT(modifierTag);
        if (!modifierTag.func_82582_d()) {
            ModifierNBT data = ModifierNBT.readTag(modifierTag);
            if (!this.identifier.equals(data.identifier)) {
                data.identifier = this.identifier;
                data.write(modifierTag);
            }
        }
        if (index >= 0) {
            tagList.func_150304_a(index, (NBTBase)modifierTag);
        } else {
            tagList.func_74742_a((NBTBase)modifierTag);
        }
        TagUtil.setModifiersTagList(root, tagList);
        this.applyEffect(root, modifierTag);
    }

    @Override
    public String getTooltip(NBTTagCompound modifierTag, boolean detailed) {
        StringBuilder sb = new StringBuilder();
        ModifierNBT data = ModifierNBT.readTag(modifierTag);
        sb.append(this.getLocalizedName());
        if (data.level > 1) {
            sb.append(" ");
            sb.append(TinkerUtil.getRomanNumeral(data.level));
        }
        return sb.toString();
    }

    public String getLeveledTooltip(NBTTagCompound modifierTag, boolean detailed) {
        ModifierNBT.IntegerNBT data = ModifierNBT.readInteger(modifierTag);
        return this.getLeveledTooltip(data.level, detailed ? " " + data.extraInfo : "");
    }

    public String getLeveledTooltip(int level, @Nullable String suffix) {
        String basic = this.getLocalizedName();
        if (level == 0) {
            return basic;
        }
        if (level > 1) {
            basic = basic + " " + TinkerUtil.getRomanNumeral(level);
        }
        for (int i = level; i > 1; --i) {
            if (!I18n.func_94522_b((String)String.format(LOC_Name + i, this.getIdentifier()))) continue;
            basic = I18n.func_74838_a((String)String.format(LOC_Name + i, this.getIdentifier()));
            break;
        }
        if (suffix != null) {
            basic = basic + suffix;
        }
        return basic;
    }

    @Override
    public String getLocalizedName() {
        return Util.translate(LOC_Name, this.getIdentifier());
    }

    @Override
    public String getLocalizedDesc() {
        return Util.translate(LOC_Desc, this.getIdentifier());
    }

    @Override
    public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
        return ImmutableList.of();
    }

    @Override
    public boolean equalModifier(NBTTagCompound modifierTag1, NBTTagCompound modifierTag2) {
        ModifierNBT data1 = ModifierNBT.readTag(modifierTag1);
        ModifierNBT data2 = ModifierNBT.readTag(modifierTag2);
        return data1.identifier.equals(data2.identifier) && data1.level == data2.level;
    }

    @Override
    public boolean hasTexturePerMaterial() {
        return false;
    }

    protected static boolean attackEntitySecondary(DamageSource source, float damage, Entity entity, boolean ignoreInvulv, boolean resetInvulv) {
        return Modifier.attackEntitySecondary(source, damage, entity, ignoreInvulv, resetInvulv, true);
    }

    protected static boolean attackEntitySecondary(DamageSource source, float damage, Entity entity, boolean ignoreInvulv, boolean resetInvulv, boolean noKnockback) {
        Optional<EntityLivingBase> entityLivingBase = Optional.of(entity).filter(e -> e instanceof EntityLivingBase).map(e -> (EntityLivingBase)e);
        Optional<IAttributeInstance> knockbackAttribute = entityLivingBase.map(living -> living.func_110148_a(SharedMonsterAttributes.field_111266_c)).filter(attribute -> !attribute.func_180374_a(ANTI_KNOCKBACK_MOD));
        float oldLastDamage = entityLivingBase.map(living -> Float.valueOf(living.field_110153_bc)).orElse(Float.valueOf(0.0f)).floatValue();
        if (noKnockback) {
            knockbackAttribute.ifPresent(attribute -> attribute.func_111121_a(ANTI_KNOCKBACK_MOD));
        }
        if (ignoreInvulv) {
            entity.field_70172_ad = 0;
        }
        boolean hit = entity.func_70097_a(source, damage);
        entityLivingBase.ifPresent(living -> living.field_110153_bc += oldLastDamage);
        if (hit && resetInvulv) {
            entity.field_70172_ad = 0;
        }
        if (noKnockback) {
            knockbackAttribute.ifPresent(attribute -> attribute.func_111124_b(ANTI_KNOCKBACK_MOD));
        }
        return hit;
    }

    @Override
    public boolean hasItemsToApplyWith() {
        return !this.items.isEmpty();
    }
}

