/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.hexxit.hexxitworld.util;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PotionSpec {
    private final Supplier<Potion> potionLazy;
    @Nullable
    private Potion potion = null;
    private final int potency;

    public PotionSpec(Supplier<Potion> potionLazy, int potency) {
        this.potionLazy = potionLazy;
        this.potency = potency;
    }

    public Potion getPotion() {
        return Objects.requireNonNull(this.getPotionUnsafe());
    }

    @Nullable
    private Potion getPotionUnsafe() {
        return this.potion != null ? this.potion : (this.potion = this.potionLazy.get());
    }

    public int getPotency() {
        return this.potency;
    }

    public PotionEffect instantiate(int duration) {
        Potion potion;
        return new PotionEffect(potion, (potion = this.getPotion()).func_76403_b() ? 1 : duration, this.potency);
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedString() {
        Potion potion = this.getPotionUnsafe();
        return String.format("%s %d", potion != null ? I18n.func_135052_a((String)this.getPotion().func_76393_a(), (Object[])new Object[0]).trim() : "?", this.potency + 1);
    }
}

