/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.hexxit.hexxitworld.network;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleItemPickup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.technicpack.hexxit.hexxitworld.init.HwSounds;

public class SPacketFieldDropPickup
implements IMessage {
    private boolean hasDropEntity;
    private int dropEntityId;
    private int playerEntityId;
    private Type dropType;

    public SPacketFieldDropPickup(@Nullable Entity dropEntity, EntityPlayer player, Type dropType) {
        if (dropEntity == null) {
            this.hasDropEntity = false;
            this.dropEntityId = -1;
        } else {
            this.hasDropEntity = true;
            this.dropEntityId = dropEntity.func_145782_y();
        }
        this.playerEntityId = player.func_145782_y();
        this.dropType = dropType;
    }

    public SPacketFieldDropPickup() {
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer pktBuf = new PacketBuffer(buf);
        if (this.hasDropEntity) {
            pktBuf.writeBoolean(true);
            pktBuf.func_150787_b(this.dropEntityId);
        } else {
            pktBuf.writeBoolean(false);
        }
        pktBuf.func_150787_b(this.playerEntityId);
        pktBuf.writeByte(this.dropType.ordinal());
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer pktBuf = new PacketBuffer(buf);
        if (pktBuf.readBoolean()) {
            this.hasDropEntity = true;
            this.dropEntityId = pktBuf.func_150792_a();
        } else {
            this.hasDropEntity = false;
            this.dropEntityId = -1;
        }
        this.playerEntityId = pktBuf.func_150792_a();
        this.dropType = (Type)((Object)Type.VALUES.get((int)pktBuf.readByte()));
    }

    public static class Handler
    implements IMessageHandler<SPacketFieldDropPickup, IMessage> {
        @Nullable
        public IMessage onMessage(final SPacketFieldDropPickup message, MessageContext ctx) {
            final Minecraft mc = Minecraft.func_71410_x();
            mc.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    if (mc.field_71439_g == null || mc.field_71441_e == null) {
                        return;
                    }
                    Entity player = mc.field_71441_e.func_73045_a(message.playerEntityId);
                    if (player == null) {
                        return;
                    }
                    switch (message.dropType) {
                        case HEART: {
                            mc.field_71441_e.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, HwSounds.ITEM_HEART_PICKUP, SoundCategory.PLAYERS, 0.75f, 1.0f, false);
                            break;
                        }
                        case EMERALD_SHARD: {
                            mc.field_71441_e.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, HwSounds.ITEM_EMERALD_DROP_PICKUP_SMALL, SoundCategory.PLAYERS, 0.75f, 1.0f, false);
                            break;
                        }
                        case EMERALD_PIECE: {
                            mc.field_71441_e.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, HwSounds.ITEM_EMERALD_DROP_PICKUP_LARGE, SoundCategory.PLAYERS, 0.75f, 1.0f, false);
                        }
                    }
                    if (!message.hasDropEntity) {
                        return;
                    }
                    Entity dropEntity = mc.field_71441_e.func_73045_a(message.dropEntityId);
                    if (dropEntity == null) {
                        return;
                    }
                    mc.field_71452_i.func_78873_a((Particle)new ParticleItemPickup((World)mc.field_71441_e, dropEntity, player, 0.5f));
                }
            });
            return null;
        }
    }

    public static enum Type {
        HEART,
        EMERALD_SHARD,
        EMERALD_PIECE;

        public static final ImmutableList<Type> VALUES;

        static {
            VALUES = ImmutableList.copyOf((Object[])Type.values());
        }
    }
}

