/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.hexxit.hexxitworld.item;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.technicpack.hexxit.hexxitworld.HexxitWorld;
import net.technicpack.hexxit.hexxitworld.HwConfig;
import net.technicpack.hexxit.hexxitworld.init.HwItems;
import net.technicpack.hexxit.hexxitworld.item.base.HexxitItem;
import net.technicpack.hexxit.hexxitworld.item.base.ItemIdentity;
import net.technicpack.hexxit.hexxitworld.network.SPacketPermanentBuffUse;
import net.technicpack.hexxit.hexxitworld.util.ModifiableAttributeModifier;

public class ItemPermanentBuff
extends Item
implements HexxitItem {
    private static final double HEART_CONT_HEALTH = 2.0;
    private static final ModifiableAttributeModifier ATTR_MOD_HEART_CONTAINERS = new ModifiableAttributeModifier("Heart Containers", "0e00be04-88bc-4622-9004-2ceac763e2e0", 0);
    private static final Style TEXT_STYLE_WARNING = new Style().func_150238_a(TextFormatting.DARK_RED);

    public ItemPermanentBuff() {
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    @Override
    public Collection<? extends ItemIdentity> getIdentities() {
        return Type.VALUES;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (Type type : Type.VALUES) {
                items.add((Object)type.newStack(1));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        Type type = Type.getForStack(stack);
        switch (type) {
            case HEART_CONTAINER: {
                AttributeModifier attrMod;
                IAttributeInstance attr = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
                if (HwConfig.heartContainerMax > 0 && (attrMod = ATTR_MOD_HEART_CONTAINERS.get(attr)) != null && attrMod.func_111164_d() >= (double)HwConfig.heartContainerMax * 2.0 - 1.0E-5) {
                    player.func_145747_a(new TextComponentTranslation("hexxitworld.notif.max_heart_containers", new Object[0]).func_150255_a(TEXT_STYLE_WARNING));
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
                ATTR_MOD_HEART_CONTAINERS.replace(attr, h -> h + 2.0);
                player.func_70691_i(player.func_110138_aP());
            }
        }
        stack.func_190918_g(1);
        player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 12);
        HexxitWorld.PROXY.getNetworkWrapper().sendToAllAround((IMessage)new SPacketPermanentBuffUse(player, type), new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 32.0));
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public static void copyPermanentBuffs(EntityPlayer oldPlayer, EntityPlayer newPlayer) {
        IAttributeInstance oldAttrHp = oldPlayer.func_110148_a(SharedMonsterAttributes.field_111267_a);
        IAttributeInstance newAttrHp = newPlayer.func_110148_a(SharedMonsterAttributes.field_111267_a);
        AttributeModifier oldAttrModHeartConts = ATTR_MOD_HEART_CONTAINERS.get(oldAttrHp);
        if (oldAttrModHeartConts != null) {
            ATTR_MOD_HEART_CONTAINERS.reapply(newAttrHp, oldAttrModHeartConts.func_111164_d());
            newPlayer.func_70606_j(newPlayer.func_110138_aP());
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + Type.getForStack((ItemStack)stack).key;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flags) {
        switch (Type.getForStack(stack)) {
            case HEART_CONTAINER: {
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"hexxitworld.tooltip.heart_container", (Object[])new Object[0]));
            }
        }
    }

    public IRarity getForgeRarity(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public static enum Type implements ItemIdentity
    {
        HEART_CONTAINER;

        public static final ImmutableList<Type> VALUES;
        public final String key = this.name().toLowerCase();

        public static Type getForMeta(int i) {
            return i >= 0 && i < VALUES.size() ? (Type)VALUES.get(i) : HEART_CONTAINER;
        }

        public static Type getForStack(ItemStack stack) {
            return Type.getForMeta(stack.func_77960_j());
        }

        @Override
        public int getMeta() {
            return this.ordinal();
        }

        @Override
        public String getModelKey() {
            return this.key;
        }

        @Override
        public ItemStack newStack(int count) {
            return new ItemStack((Item)HwItems.PERMABUFF, count, this.getMeta());
        }

        static {
            VALUES = ImmutableList.copyOf((Object[])Type.values());
        }
    }
}

