/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.hexxit.hexxitworld.item;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.technicpack.hexxit.hexxitworld.HexxitWorld;
import net.technicpack.hexxit.hexxitworld.init.HwItems;
import net.technicpack.hexxit.hexxitworld.init.HwSounds;
import net.technicpack.hexxit.hexxitworld.item.base.HexxitItem;
import net.technicpack.hexxit.hexxitworld.item.base.ItemIdentity;
import net.technicpack.hexxit.hexxitworld.item.base.ItemPickupCallback;
import net.technicpack.hexxit.hexxitworld.network.SPacketFieldDropPickup;

public class ItemMaterial
extends Item
implements HexxitItem,
ItemPickupCallback {
    public ItemMaterial() {
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    @Override
    public Collection<? extends ItemIdentity> getIdentities() {
        return Type.VALUES;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (Type type : Type.VALUES) {
                items.add((Object)type.newStack(1));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        switch (Type.getForStack(stack)) {
            case EMERALD_SHARD: {
                return ItemMaterial.exchange(player, stack, Type.EMERALD_PIECE::newStack);
            }
            case EMERALD_PIECE: {
                return ItemMaterial.exchange(player, stack, c -> new ItemStack(Items.field_151166_bC, c));
            }
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private static ActionResult<ItemStack> exchange(EntityPlayer player, ItemStack stack, IntFunction<ItemStack> exStackFactory) {
        int count = stack.func_190916_E();
        if (count < 8) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (player.field_70170_p.field_72995_K) {
            player.func_184185_a(HwSounds.ITEM_EMERALD_EXCHANGE, 1.0f, 0.9f + 0.2f * player.field_70170_p.field_73012_v.nextFloat());
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (player.func_70093_af()) {
            int exchCount = count / 8;
            ItemMaterial.giveItemsNoReturns(player, exStackFactory.apply(exchCount));
            stack.func_190918_g(8 * exchCount);
        } else {
            ItemMaterial.giveItemsNoReturns(player, exStackFactory.apply(1));
            stack.func_190918_g(8);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private static void giveItemsNoReturns(EntityPlayer player, ItemStack stack) {
        EntityItem itemEntity;
        player.field_71071_by.func_70441_a(stack);
        if (!stack.func_190926_b() && (itemEntity = player.func_71019_a(stack, false)) != null) {
            itemEntity.func_174868_q();
            itemEntity.func_145797_a(player.func_70005_c_());
        }
    }

    @Override
    public void onPickedUp(EntityPlayer player, ItemStack stack, Entity itemEntity) {
        switch (Type.getForStack(stack)) {
            case EMERALD_PIECE: {
                HexxitWorld.PROXY.getNetworkWrapper().sendToAllAround((IMessage)new SPacketFieldDropPickup(itemEntity, player, SPacketFieldDropPickup.Type.EMERALD_PIECE), new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 32.0));
                break;
            }
            case EMERALD_SHARD: {
                HexxitWorld.PROXY.getNetworkWrapper().sendToAllAround((IMessage)new SPacketFieldDropPickup(itemEntity, player, SPacketFieldDropPickup.Type.EMERALD_SHARD), new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 32.0));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + Type.getForStack((ItemStack)stack).key;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flags) {
        switch (Type.getForStack(stack)) {
            case EMERALD_SHARD: 
            case EMERALD_PIECE: {
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"hexxitworld.tooltip.emerald_combine", (Object[])new Object[0]));
            }
        }
    }

    public IRarity getForgeRarity(ItemStack stack) {
        switch (Type.getForStack(stack)) {
            case HEART_PIECE: {
                return EnumRarity.UNCOMMON;
            }
        }
        return EnumRarity.COMMON;
    }

    public static enum Type implements ItemIdentity
    {
        EMERALD_SHARD,
        EMERALD_PIECE,
        HEART_PIECE;

        public static final ImmutableList<Type> VALUES;
        public final String key = this.name().toLowerCase();

        public static Type getForMeta(int i) {
            return i >= 0 && i < VALUES.size() ? (Type)VALUES.get(i) : EMERALD_SHARD;
        }

        public static Type getForStack(ItemStack stack) {
            return Type.getForMeta(stack.func_77960_j());
        }

        @Override
        public int getMeta() {
            return this.ordinal();
        }

        @Override
        public String getModelKey() {
            return this.key;
        }

        @Override
        public ItemStack newStack(int count) {
            return new ItemStack((Item)HwItems.MATERIAL, count, this.getMeta());
        }

        static {
            VALUES = ImmutableList.copyOf((Object[])Type.values());
        }
    }
}

