/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.hexxit.hexxitworld.item;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.technicpack.hexxit.hexxitworld.HexxitWorld;
import net.technicpack.hexxit.hexxitworld.init.HwItems;
import net.technicpack.hexxit.hexxitworld.item.ItemMaterial;
import net.technicpack.hexxit.hexxitworld.item.base.HexxitItem;
import net.technicpack.hexxit.hexxitworld.item.base.ItemIdentity;
import net.technicpack.hexxit.hexxitworld.item.base.ItemSpecialPickup;
import net.technicpack.hexxit.hexxitworld.network.SPacketFieldDropPickup;

public class ItemFieldDrop
extends Item
implements HexxitItem,
ItemSpecialPickup {
    public ItemFieldDrop() {
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    @Override
    public Collection<? extends ItemIdentity> getIdentities() {
        return Type.VALUES;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)Type.HEART.newStack(1));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (this.handlePickup(player, stack, null)) {
            stack.func_190918_g(1);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @Override
    public boolean handlePickup(EntityPlayer player, ItemStack stack, @Nullable Entity itemEntity) {
        Type type = Type.getForStack(stack);
        switch (type) {
            case HEART: {
                player.func_70691_i(2.0f);
                break;
            }
            case EMERALD_DROP_SHARD: {
                if (player.field_71071_by.func_70441_a(ItemMaterial.Type.EMERALD_SHARD.newStack(1))) break;
                return false;
            }
            case EMERALD_DROP_PIECE: {
                if (player.field_71071_by.func_70441_a(ItemMaterial.Type.EMERALD_PIECE.newStack(1))) break;
                return false;
            }
        }
        HexxitWorld.PROXY.getNetworkWrapper().sendToAllAround((IMessage)new SPacketFieldDropPickup(itemEntity, player, type.effectType), new NetworkRegistry.TargetPoint(player.field_71093_bK, player.field_70165_t, player.field_70163_u, player.field_70161_v, 32.0));
        return true;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + Type.getForStack((ItemStack)stack).key;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flags) {
        tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"hexxitworld.tooltip.right_click_use", (Object[])new Object[0]));
    }

    public static enum Type implements ItemIdentity
    {
        HEART(SPacketFieldDropPickup.Type.HEART),
        EMERALD_DROP_SHARD(SPacketFieldDropPickup.Type.EMERALD_SHARD),
        EMERALD_DROP_PIECE(SPacketFieldDropPickup.Type.EMERALD_PIECE);

        public static final ImmutableList<Type> VALUES;
        public final String key;
        public final SPacketFieldDropPickup.Type effectType;

        public static Type getForMeta(int i) {
            return i >= 0 && i < VALUES.size() ? (Type)VALUES.get(i) : HEART;
        }

        public static Type getForStack(ItemStack stack) {
            return Type.getForMeta(stack.func_77960_j());
        }

        private Type(SPacketFieldDropPickup.Type effectType) {
            this.effectType = effectType;
            this.key = this.name().toLowerCase();
        }

        @Override
        public int getMeta() {
            return this.ordinal();
        }

        @Override
        public String getModelKey() {
            return this.key;
        }

        @Override
        public ItemStack newStack(int count) {
            return new ItemStack((Item)HwItems.FIELD_DROP, count, this.getMeta());
        }

        static {
            VALUES = ImmutableList.copyOf((Object[])Type.values());
        }
    }
}

