/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.hexxit.hexxitworld.item;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.technicpack.hexxit.hexxitworld.init.HwItems;
import net.technicpack.hexxit.hexxitworld.init.HwSounds;
import net.technicpack.hexxit.hexxitworld.integration.IntElenaiDodge;
import net.technicpack.hexxit.hexxitworld.integration.IntQuark;
import net.technicpack.hexxit.hexxitworld.item.base.HexxitItem;
import net.technicpack.hexxit.hexxitworld.item.base.ItemIdentity;
import net.technicpack.hexxit.hexxitworld.util.PotionSpec;

public class ItemElixir
extends Item
implements HexxitItem {
    private static final String TAG_CHARGE_COUNT = "ChargeCount";
    private static final String TOOLTIP_FORMAT_CHARGES = String.format("%s%%s: %s%%d%s/%s%%d", TextFormatting.DARK_AQUA, TextFormatting.WHITE, TextFormatting.GRAY, TextFormatting.WHITE);
    private static final String TOOLTIP_FORMAT_DURATION = String.format("%s%%s: %s%%s", TextFormatting.DARK_AQUA, TextFormatting.WHITE);
    private static final String TOOLTIP_EFFECT_BULLET = TextFormatting.GREEN + "+ " + TextFormatting.GRAY;

    public ItemElixir() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    @Override
    public Collection<? extends ItemIdentity> getIdentities() {
        return Type.VALUES;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (Type type : Type.VALUES) {
                items.add((Object)type.newStack(1));
            }
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entity) {
        if (world.field_72995_K) {
            return stack;
        }
        world.func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, HwSounds.ITEM_ELIXIR_USE, SoundCategory.PLAYERS, 1.0f, 1.0f);
        Type type = Type.getForStack(stack);
        for (PotionSpec effect : type.effects) {
            entity.func_70690_d(effect.instantiate(type.duration));
        }
        int chargeCount = ItemElixir.getChargeCount(stack);
        if (chargeCount <= 1) {
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo))) {
                return ItemStack.field_190927_a;
            }
            return new ItemStack(Items.field_151069_bo);
        }
        ItemElixir.setChargeCount(stack, chargeCount - 1);
        return stack;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + Type.getForStack((ItemStack)stack).key;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flags) {
        Type type = Type.getForStack(stack);
        tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)type.getTooltipLocalizationKey(), (Object[])new Object[0]));
        tooltip.add("");
        tooltip.add(String.format(TOOLTIP_FORMAT_CHARGES, I18n.func_135052_a((String)"hexxitworld.tooltip.charges", (Object[])new Object[0]), ItemElixir.getChargeCount(stack), type.maxChargeCount));
        tooltip.add(String.format(TOOLTIP_FORMAT_DURATION, I18n.func_135052_a((String)"hexxitworld.tooltip.duration", (Object[])new Object[0]), StringUtils.func_76337_a((int)type.duration)));
        tooltip.add("");
        for (PotionSpec effect : type.effects) {
            tooltip.add(TOOLTIP_EFFECT_BULLET + effect.getLocalizedString());
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return ItemElixir.getChargeCount(stack) < Type.getForStack((ItemStack)stack).maxChargeCount;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)ItemElixir.getChargeCount(stack) / (double)Type.getForStack((ItemStack)stack).maxChargeCount;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 4185085;
    }

    public IRarity getForgeRarity(ItemStack stack) {
        switch (Type.getForStack(stack)) {
            case STAR: 
            case LIFE: {
                return EnumRarity.UNCOMMON;
            }
            case HEALTH: {
                return EnumRarity.RARE;
            }
            case EYE: {
                return EnumRarity.EPIC;
            }
        }
        return EnumRarity.COMMON;
    }

    private static int getChargeCount(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return Type.getForStack((ItemStack)stack).maxChargeCount;
        }
        NBTTagCompound tag = Objects.requireNonNull(stack.func_77978_p());
        return tag.func_150297_b(TAG_CHARGE_COUNT, 3) ? tag.func_74762_e(TAG_CHARGE_COUNT) : Type.getForStack((ItemStack)stack).maxChargeCount;
    }

    private static void setChargeCount(ItemStack stack, int count) {
        NBTTagCompound tag;
        if (stack.func_77942_o()) {
            tag = Objects.requireNonNull(stack.func_77978_p());
        } else {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        tag.func_74768_a(TAG_CHARGE_COUNT, count);
    }

    public static enum Type implements ItemIdentity
    {
        STAR(1, 3000, new PotionSpec(() -> MobEffects.field_188423_x, 0), new PotionSpec(() -> MobEffects.field_188425_z, 0), new PotionSpec(() -> MobEffects.field_76424_c, 1), new PotionSpec(() -> MobEffects.field_76420_g, 1), new PotionSpec(() -> IntElenaiDodge.POTION_NIMBLE, 0)),
        EYE(3, 3600, new PotionSpec(() -> MobEffects.field_76439_r, 0), new PotionSpec(() -> MobEffects.field_76420_g, 2), new PotionSpec(() -> MobEffects.field_76429_m, 1), new PotionSpec(() -> MobEffects.field_76444_x, 1), new PotionSpec(() -> IntQuark.POTION_DANGER_SIGHT, 0)),
        LIFE(2, 200, new PotionSpec(() -> MobEffects.field_76428_l, 3), new PotionSpec(() -> MobEffects.field_76429_m, 0)),
        HEALTH(1, 3600, new PotionSpec(() -> MobEffects.field_180152_w, 9), new PotionSpec(() -> MobEffects.field_76432_h, 9), new PotionSpec(() -> MobEffects.field_76428_l, 0));

        public static final ImmutableList<Type> VALUES;
        public final int maxChargeCount;
        public final int duration;
        public final ImmutableList<PotionSpec> effects;
        public final String key;

        public static Type getForMeta(int i) {
            return i >= 0 && i < VALUES.size() ? (Type)VALUES.get(i) : STAR;
        }

        public static Type getForStack(ItemStack stack) {
            return Type.getForMeta(stack.func_77960_j());
        }

        private Type(int maxChargeCount, int duration, PotionSpec ... effects) {
            this.maxChargeCount = maxChargeCount;
            this.duration = duration;
            this.effects = ImmutableList.copyOf((Object[])effects);
            this.key = this.name().toLowerCase();
        }

        @Override
        public int getMeta() {
            return this.ordinal();
        }

        @Override
        public String getModelKey() {
            return "elixir_" + this.key;
        }

        public String getTooltipLocalizationKey() {
            return "hexxitworld.tooltip.elixir." + this.key;
        }

        @Override
        public ItemStack newStack(int count) {
            return new ItemStack((Item)HwItems.ELIXIR, count, this.getMeta());
        }

        static {
            VALUES = ImmutableList.copyOf((Object[])Type.values());
        }
    }
}

