/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.hexxit.hexxitworld.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.technicpack.hexxit.hexxitworld.HwConfig;
import net.technicpack.hexxit.hexxitworld.entity.EntityItemEffectOnPickup;
import net.technicpack.hexxit.hexxitworld.init.HwLootTables;
import net.technicpack.hexxit.hexxitworld.item.ItemMaterial;
import net.technicpack.hexxit.hexxitworld.item.ItemPermanentBuff;
import net.technicpack.hexxit.hexxitworld.item.base.ItemPickupCallback;
import net.technicpack.hexxit.hexxitworld.item.base.ItemSpecialPickup;

@Mod.EventBusSubscriber(modid="hexxitworld")
public class DropHandler {
    @SubscribeEvent
    public static void onBlockDrops(BlockEvent.HarvestDropsEvent event) {
        Block block;
        EntityPlayer player = event.getHarvester();
        if (player == null) {
            return;
        }
        World world = event.getWorld();
        if (world.field_72995_K || !(world instanceof WorldServer)) {
            return;
        }
        IBlockState state = event.getState();
        if (!DropHandler.isGrass(state, block = state.func_177230_c()) || event.isSilkTouching() || player.func_184614_ca().func_77973_b() instanceof ItemShears) {
            return;
        }
        BlockPos pos = event.getPos();
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.5;
        double z = (double)pos.func_177952_p() + 0.5;
        for (ItemStack stack : DropHandler.generateDrops((WorldServer)world, HwLootTables.FIELD_DROPS_GRASS, player, (float)event.getFortuneLevel() * 0.5f, null)) {
            world.func_72838_d((Entity)DropHandler.createItemDrop(stack, world, x, y, z));
        }
    }

    private static boolean isGrass(IBlockState state, Block block) {
        if (block == Blocks.field_150329_H) {
            return true;
        }
        if (block == Blocks.field_150398_cm) {
            switch ((BlockDoublePlant.EnumPlantType)state.func_177229_b((IProperty)BlockDoublePlant.field_176493_a)) {
                case GRASS: 
                case FERN: {
                    return true;
                }
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onMobDrops(LivingDropsEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K || !(entity.field_70170_p instanceof WorldServer)) {
            return;
        }
        if (!entity.func_184222_aU() && HwConfig.dropChanceBossHeartContainer > 0.0 && entity.field_70170_p.field_73012_v.nextDouble() < HwConfig.dropChanceBossHeartContainer) {
            event.getDrops().add(DropHandler.createItemDrop(ItemPermanentBuff.Type.HEART_CONTAINER.newStack(1), (Entity)entity));
            return;
        }
        DamageSource dmgSrc = event.getSource();
        if (!event.isRecentlyHit() || !(dmgSrc.func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        if (!(entity instanceof EntityMob)) {
            DropHandler.addMobDrops(event.getDrops(), entity, HwLootTables.FIELD_DROPS_MOBS_PASSIVE, dmgSrc, event.getLootingLevel());
            return;
        }
        if ((double)entity.func_110138_aP() >= HwConfig.bigMobHealthThreshold && HwConfig.dropChanceBigMobHeartPiece > 0.0 && (double)entity.field_70170_p.field_73012_v.nextFloat() < HwConfig.dropChanceBigMobHeartPiece) {
            event.getDrops().add(DropHandler.createItemDrop(ItemMaterial.Type.HEART_PIECE.newStack(1), (Entity)entity));
            return;
        }
        DropHandler.addMobDrops(event.getDrops(), entity, HwLootTables.FIELD_DROPS_MOBS_HOSTILE, dmgSrc, event.getLootingLevel());
    }

    private static void addMobDrops(List<EntityItem> drops, EntityLivingBase entity, ResourceLocation table, DamageSource dmgSrc, int looting) {
        for (ItemStack dropStack : DropHandler.generateDrops((WorldServer)entity.field_70170_p, table, (EntityPlayer)Objects.requireNonNull(dmgSrc.func_76346_g()), (float)looting * 0.5f, dmgSrc)) {
            drops.add(DropHandler.createItemDrop(dropStack, (Entity)entity));
        }
    }

    private static List<ItemStack> generateDrops(WorldServer world, ResourceLocation lootTable, EntityPlayer player, float bonusLuck, @Nullable DamageSource dmgSrc) {
        LootContext.Builder lootCtxBuilder = new LootContext.Builder(world).func_186470_a(player).func_186469_a(player.func_184817_da() + bonusLuck);
        if (dmgSrc != null) {
            lootCtxBuilder.func_186473_a(dmgSrc);
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack stack : world.func_184146_ak().func_186521_a(lootTable).func_186462_a(world.field_73012_v, lootCtxBuilder.func_186471_a())) {
            if (stack.func_77973_b() instanceof ItemSpecialPickup || stack.func_77973_b() instanceof ItemPickupCallback) {
                int count = stack.func_190916_E();
                stack.func_190920_e(1);
                for (int i = 0; i < count; ++i) {
                    result.add(stack.func_77946_l());
                }
                continue;
            }
            result.add(stack);
        }
        return result;
    }

    private static EntityItem createItemDrop(ItemStack stack, Entity sourceEntity) {
        return DropHandler.createItemDrop(stack, sourceEntity.field_70170_p, sourceEntity.field_70165_t, sourceEntity.field_70163_u, sourceEntity.field_70161_v);
    }

    private static EntityItem createItemDrop(ItemStack stack, World world, double x, double y, double z) {
        EntityItemEffectOnPickup itemEntity = new EntityItemEffectOnPickup(world, x, y, z, stack);
        itemEntity.field_70159_w = world.field_73012_v.nextGaussian() * 0.07;
        itemEntity.field_70181_x = world.field_73012_v.nextGaussian() * 0.07 + 0.2;
        itemEntity.field_70179_y = world.field_73012_v.nextGaussian() * 0.07;
        itemEntity.func_174869_p();
        return itemEntity;
    }
}

