/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.hexxit.hexxitworld.client.handler;

import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.technicpack.hexxit.hexxitworld.init.HwItems;
import net.technicpack.hexxit.hexxitworld.item.ItemMaterial;

@Mod.EventBusSubscriber(modid="hexxitworld", value={Side.CLIENT})
public class EmeraldTooltipHandler {
    private static final int SHARD_VALUE = 1;
    private static final int PIECE_VALUE = 8;
    private static final int GEM_VALUE = 64;
    private static final int BLOCK_VALUE = 576;
    private static final String TOOLTIP_FORMAT = TextFormatting.GREEN + "[ %,d %s (%,dx%,d) ]";

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        int unitValue = -1;
        if (item == Items.field_151166_bC) {
            unitValue = 64;
        } else if (item == Item.func_150898_a((Block)Blocks.field_150475_bE)) {
            unitValue = 576;
        } else if (item == HwItems.MATERIAL) {
            switch (ItemMaterial.Type.getForStack(stack)) {
                case EMERALD_SHARD: {
                    unitValue = 1;
                    break;
                }
                case EMERALD_PIECE: {
                    unitValue = 8;
                }
            }
        }
        if (unitValue != -1) {
            int stackSize = stack.func_190916_E();
            event.getToolTip().add(String.format(TOOLTIP_FORMAT, unitValue * stackSize, I18n.func_135052_a((String)"hexxitworld.tooltip.emerald_value", (Object[])new Object[0]), stackSize, unitValue));
        }
    }
}

