/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.hexxit.hexxitworld.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.technicpack.hexxit.hexxitworld.HexxitWorld;
import net.technicpack.hexxit.hexxitworld.RegistryHandler;
import net.technicpack.hexxit.hexxitworld.item.base.HexxitItem;
import net.technicpack.hexxit.hexxitworld.item.base.ItemIdentity;
import org.apache.commons.lang3.tuple.Pair;

public class ClientRegistryHandler
extends RegistryHandler {
    private final List<Pair<String, Item>> itemModelRegQueue = new ArrayList<Pair<String, Item>>();

    @Override
    protected RegistryHandler.ItemRegistrar createItemRegistrar(RegistryEvent.Register<Item> event) {
        RegistryHandler.ItemRegistrar registrar = super.createItemRegistrar(event);
        return (name, item) -> {
            registrar.register(name, item);
            this.itemModelRegQueue.add((Pair<String, Item>)Pair.of((Object)name, (Object)item));
        };
    }

    @SubscribeEvent
    public void onRegisterModels(ModelRegistryEvent event) {
        for (Pair<String, Item> entry : this.itemModelRegQueue) {
            Item item = (Item)entry.getValue();
            if (item instanceof HexxitItem) {
                for (ItemIdentity itemIdentity : ((HexxitItem)item).getIdentities()) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)itemIdentity.getMeta(), (ModelResourceLocation)new ModelResourceLocation(HexxitWorld.resource(itemIdentity.getModelKey()), "inventory"));
                }
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(HexxitWorld.resource((String)entry.getKey()), "inventory"));
        }
        this.itemModelRegQueue.clear();
    }
}

