/*
 * Decompiled with CFR 0.152.
 */
package net.technicpack.hexxit.hexxitworld;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.technicpack.hexxit.hexxitworld.init.HwItems;

public class RegistryHandler {
    private final List<Consumer<ItemRegistrar>> itemRegQueue = new ArrayList<Consumer<ItemRegistrar>>();

    public void registerBlocks(RegistryEvent.Register<Block> event, Consumer<BlockRegistrar> body) {
        body.accept(this.createBlockRegistrar(event));
    }

    protected BlockRegistrar createBlockRegistrar(RegistryEvent.Register<Block> event) {
        IForgeRegistry reg = event.getRegistry();
        return (name, block, itemBlockFactory) -> {
            block.setRegistryName(name);
            block.func_149663_c("hexxitworld:" + name);
            block.func_149647_a(HwItems.TAB_HW);
            reg.register((IForgeRegistryEntry)block);
            this.itemRegQueue.add(ir -> ir.register(name, (Item)itemBlockFactory.apply(block)));
        };
    }

    public void registerItems(RegistryEvent.Register<Item> event, Consumer<ItemRegistrar> body) {
        ItemRegistrar registrar = this.createItemRegistrar(event);
        body.accept(registrar);
        for (Consumer<ItemRegistrar> entry : this.itemRegQueue) {
            entry.accept(registrar);
        }
        this.itemRegQueue.clear();
    }

    protected ItemRegistrar createItemRegistrar(RegistryEvent.Register<Item> event) {
        IForgeRegistry reg = event.getRegistry();
        return (name, item) -> {
            item.setRegistryName(name);
            item.func_77655_b("hexxitworld:" + name);
            item.func_77637_a(HwItems.TAB_HW);
            reg.register((IForgeRegistryEntry)item);
        };
    }

    @FunctionalInterface
    public static interface ItemRegistrar {
        public void register(String var1, Item var2);
    }

    @FunctionalInterface
    public static interface BlockRegistrar {
        public void register(String var1, Block var2, Function<Block, ItemBlock> var3);

        default public void register(String name, Block block) {
            this.register(name, block, ItemBlock::new);
        }
    }
}

