/*
 * Decompiled with CFR 0.152.
 */
package meldexun.reachfix.util;

import java.util.UUID;
import meldexun.reachfix.ReachFix;
import meldexun.reachfix.config.ReachFixConfig;
import meldexun.reachfix.integration.SpartanWeaponry;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;

public class ReachFixUtil {
    private static final UUID REACH_UUID = UUID.fromString("00d4860f-b487-4402-b424-373a52566330");
    private static final String REACH_STRING = "reachfix:base_reach";

    public static void updateBaseReachModifier(EntityPlayer player) {
        ReachFixUtil.updateBaseReachModifier(player, player.func_184812_l_());
    }

    public static void updateBaseReachModifier(EntityPlayer player, boolean creative) {
        ReachFixConfig config = ReachFixConfig.getInstance();
        IAttributeInstance attribute = player.func_110148_a(EntityPlayer.REACH_DISTANCE);
        attribute.func_188479_b(REACH_UUID);
        attribute.func_111121_a(new AttributeModifier(REACH_UUID, REACH_STRING, (creative ? config.reachCreative : config.reach) - 5.0, 0).func_111168_a(false));
    }

    public static double getBlockReach(EntityPlayer player, EnumHand hand) {
        double reach = player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e();
        if (ReachFix.isSpartanWeaponryInstalled) {
            reach += SpartanWeaponry.getReachBonus(player, hand);
        }
        return reach;
    }

    public static double getEntityReach(EntityPlayer player, EnumHand hand) {
        ReachFixConfig config = ReachFixConfig.getInstance();
        return Math.max(ReachFixUtil.getBlockReach(player, hand) + (player.func_184812_l_() ? config.entityReachCreative - config.reachCreative : config.entityReach - config.reach), 0.0);
    }
}

