/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.mixin;

import javax.annotation.ParametersAreNonnullByDefault;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfig;
import mod.acgaming.universaltweaks.tweaks.mixin.EntityLivingAccessor;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={EntityMob.class})
public abstract class UTMobDespawnMixin
extends EntityCreature {
    public boolean pickedItems = false;

    public UTMobDespawnMixin(World worldIn) {
        super(worldIn);
    }

    @ParametersAreNonnullByDefault
    public void func_175445_a(EntityItem itemEntity) {
        super.func_175445_a(itemEntity);
        if (!UTConfig.TWEAKS_ENTITIES.utMobDespawnToggle) {
            return;
        }
        if (UTConfig.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTMobDespawn ::: Update equipment");
        }
        this.pickedItems = true;
        ((EntityLivingAccessor)((Object)this)).setPersistenceRequired(this.func_145818_k_());
    }

    public void func_70623_bb() {
        Event.Result result;
        if (!UTConfig.TWEAKS_ENTITIES.utMobDespawnToggle) {
            super.func_70623_bb();
            return;
        }
        if (((EntityLivingAccessor)((Object)this)).getPersistenceRequired()) {
            this.field_70708_bq = 0;
        } else if ((this.field_70708_bq & 0x1F) == 31 && (result = ForgeEventFactory.canEntityDespawn((EntityLiving)this)) != Event.Result.DEFAULT) {
            if (result == Event.Result.DENY) {
                this.field_70708_bq = 0;
            } else {
                this.dropEquipmentAndDespawn();
            }
        } else {
            EntityPlayer entity = this.field_70170_p.func_72890_a((Entity)this, -1.0);
            if (entity != null) {
                double d0 = entity.field_70165_t - this.field_70165_t;
                double d1 = entity.field_70163_u - this.field_70163_u;
                double d2 = entity.field_70161_v - this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (this.func_70692_ba() && d3 > 16384.0) {
                    this.dropEquipmentAndDespawn();
                }
                if (this.field_70708_bq > 600 && this.field_70146_Z.nextInt(800) == 0 && d3 > 1024.0 && this.func_70692_ba()) {
                    this.dropEquipmentAndDespawn();
                } else if (d3 < 1024.0) {
                    this.field_70708_bq = 0;
                }
            }
        }
    }

    public void dropEquipmentAndDespawn() {
        if (UTConfig.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTMobDespawn ::: Despawn entity");
        }
        if (this.pickedItems) {
            for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                ItemStack itemstack = this.func_184582_a(entityequipmentslot);
                if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemstack)) continue;
                this.func_70099_a(itemstack, 0.0f);
            }
        }
        this.func_70106_y();
    }
}

