/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.mods.roost.contenttweaker.mixin;

import com.setycz.chickens.handler.SpawnType;
import com.setycz.chickens.registry.ChickensRegistry;
import com.setycz.chickens.registry.ChickensRegistryItem;
import com.teamacronymcoders.base.modulesystem.ModuleBase;
import com.teamacronymcoders.contenttweaker.modules.chickens.ChickenFactory;
import com.teamacronymcoders.contenttweaker.modules.chickens.ChickenModule;
import com.teamacronymcoders.contenttweaker.modules.chickens.ChickenRepresentation;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfig;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChickenModule.class}, remap=false)
public abstract class UTChickenModuleMixin
extends ModuleBase {
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        if (!UTConfig.MOD_INTEGRATION.ROOST.utRoostEarlyRegisterCTChickens) {
            return;
        }
        if (UTConfig.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTChickenModuleMixin ::: Register chickens (pre-init)");
        }
        this.utRegisterChickens();
    }

    @Inject(method={"init"}, at={@At(value="INVOKE", target="Lcom/teamacronymcoders/contenttweaker/modules/chickens/ChickenFactory;registerChickens()V")}, cancellable=true)
    public void utCTChickenInit(FMLInitializationEvent e, CallbackInfo ci) {
        if (UTConfig.MOD_INTEGRATION.ROOST.utRoostEarlyRegisterCTChickens) {
            if (UTConfig.DEBUG.utDebugToggle) {
                UniversalTweaks.LOGGER.debug("UTChickenModuleMixin ::: Finish setting up chickens (init)");
            }
            this.utInitChickens();
            ci.cancel();
        }
    }

    private void utRegisterChickens() {
        for (ChickenRepresentation chickenRepresentation : ChickenFactory.CHICKEN_REPRESENTATIONS) {
            ChickensRegistryItem item = new ChickensRegistryItem(new ResourceLocation("contenttweaker", chickenRepresentation.name), chickenRepresentation.name, chickenRepresentation.textureLocation.getInternal(), ItemStack.field_190927_a, chickenRepresentation.backgroundColor.getIntColor(), chickenRepresentation.foregroundColor.getIntColor(), null, null);
            ChickensRegistry.register((ChickensRegistryItem)item);
        }
        if (UTConfig.DEBUG.utDebugToggle) {
            CraftTweakerAPI.logInfo((String)"UTChickenModuleMixin ::: Dumping chicken registry!");
            for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
                CraftTweakerAPI.logInfo((String)("UTChickenModuleMixin ::: " + chicken.getRegistryName().toString()));
            }
        }
    }

    private void utInitChickens() {
        if (UTConfig.DEBUG.utDebugToggle) {
            CraftTweakerAPI.logInfo((String)"UTChickenModuleMixin ::: Dumping chicken registry! (in init)");
            for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
                CraftTweakerAPI.logInfo((String)("UTChickenModuleMixin ::: " + chicken.getRegistryName().toString()));
            }
        }
        for (ChickenRepresentation chickenRepresentation : ChickenFactory.CHICKEN_REPRESENTATIONS) {
            ChickensRegistryItem parentTwoItem;
            ResourceLocation registryName = new ResourceLocation("contenttweaker", chickenRepresentation.name);
            ChickensRegistryItem item = ChickensRegistry.getByRegistryName((String)registryName.toString());
            if (item == null) {
                CraftTweakerAPI.logError((String)("Failed to find chicken item " + registryName + " in registry"));
                return;
            }
            ChickensRegistryItem parentOneItem = chickenRepresentation.parentOne != null ? ChickensRegistry.getByResourceLocation((ResourceLocation)chickenRepresentation.parentOne.getInternal()) : null;
            ChickensRegistryItem chickensRegistryItem = parentTwoItem = chickenRepresentation.parentTwo != null ? ChickensRegistry.getByResourceLocation((ResourceLocation)chickenRepresentation.parentTwo.getInternal()) : null;
            if (parentOneItem != null && parentTwoItem != null) {
                item.setParentsNew(parentOneItem, parentTwoItem);
            } else {
                item.setNoParents();
            }
            if (chickenRepresentation.layItem != null) {
                item.setLayItem(CraftTweakerMC.getItemStack((IItemStack)chickenRepresentation.layItem));
            }
            if (chickenRepresentation.dropItem != null) {
                item.setDropItem(CraftTweakerMC.getItemStack((IItemStack)chickenRepresentation.dropItem));
            }
            if (chickenRepresentation.spawnType != null) {
                SpawnType actualSpawnType = null;
                for (SpawnType spawnTypeEnum : SpawnType.values()) {
                    if (!spawnTypeEnum.toString().equalsIgnoreCase(chickenRepresentation.spawnType)) continue;
                    actualSpawnType = spawnTypeEnum;
                }
                if (actualSpawnType != null) {
                    item.setSpawnType(actualSpawnType);
                } else {
                    CraftTweakerAPI.logError((String)("Failed to find SpawnType for String: " + chickenRepresentation.spawnType));
                }
            }
            item.setLayCoefficient(chickenRepresentation.layCoefficient);
        }
    }
}

