/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.config;

import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.bugfixes.blocks.blockoverlay.UTBlockOverlayLists;
import mod.acgaming.universaltweaks.core.UTLoadingPlugin;
import mod.acgaming.universaltweaks.mods.botania.UTBotaniaFancySkybox;
import mod.acgaming.universaltweaks.tweaks.UTLoadSound;
import mod.acgaming.universaltweaks.tweaks.breakablebedrock.UTBreakableBedrock;
import mod.acgaming.universaltweaks.tweaks.incurablepotions.UTIncurablePotions;
import mod.acgaming.universaltweaks.tweaks.swingthroughgrass.UTSwingThroughGrassLists;
import mod.acgaming.universaltweaks.util.UTObsoleteModsScreenHandler;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="universaltweaks", name="UniversalTweaks")
public class UTConfig {
    @Config.LangKey(value="cfg.universaltweaks.bugfixes.blocks")
    @Config.Name(value="Bugfixes: Blocks")
    public static final BugfixesBlocksCategory BUGFIXES_BLOCKS = new BugfixesBlocksCategory();
    @Config.LangKey(value="cfg.universaltweaks.bugfixes.entities")
    @Config.Name(value="Bugfixes: Entities")
    public static final BugfixesEntitiesCategory BUGFIXES_ENTITIES = new BugfixesEntitiesCategory();
    @Config.LangKey(value="cfg.universaltweaks.bugfixes.misc")
    @Config.Name(value="Bugfixes: Misc")
    public static final BugfixesMiscCategory BUGFIXES_MISC = new BugfixesMiscCategory();
    @Config.LangKey(value="cfg.universaltweaks.bugfixes.world")
    @Config.Name(value="Bugfixes: World")
    public static final BugfixesWorldCategory BUGFIXES_WORLD = new BugfixesWorldCategory();
    @Config.LangKey(value="cfg.universaltweaks.debug")
    @Config.Name(value="Debug")
    public static final DebugCategory DEBUG = new DebugCategory();
    @Config.LangKey(value="cfg.universaltweaks.modintegration")
    @Config.Name(value="Mod Integration")
    public static final ModIntegrationCategory MOD_INTEGRATION = new ModIntegrationCategory();
    @Config.LangKey(value="cfg.universaltweaks.tweaks.blocks")
    @Config.Name(value="Tweaks: Blocks")
    public static final TweaksBlocksCategory TWEAKS_BLOCKS = new TweaksBlocksCategory();
    @Config.LangKey(value="cfg.universaltweaks.tweaks.entities")
    @Config.Name(value="Tweaks: Entities")
    public static final TweaksEntitiesCategory TWEAKS_ENTITIES = new TweaksEntitiesCategory();
    @Config.LangKey(value="cfg.universaltweaks.tweaks.items")
    @Config.Name(value="Tweaks: Items")
    public static final TweaksItemsCategory TWEAKS_ITEMS = new TweaksItemsCategory();
    @Config.LangKey(value="cfg.universaltweaks.tweaks.misc")
    @Config.Name(value="Tweaks: Misc")
    public static final TweaksMiscCategory TWEAKS_MISC = new TweaksMiscCategory();
    @Config.LangKey(value="cfg.universaltweaks.tweaks.performance")
    @Config.Name(value="Tweaks: Performance")
    public static final TweaksPerformanceCategory TWEAKS_PERFORMANCE = new TweaksPerformanceCategory();
    @Config.LangKey(value="cfg.universaltweaks.tweaks.world")
    @Config.Name(value="Tweaks: World")
    public static final TweaksWorldCategory TWEAKS_WORLD = new TweaksWorldCategory();

    @Mod.EventBusSubscriber(modid="universaltweaks")
    public static class EventHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("universaltweaks")) {
                ConfigManager.sync((String)"universaltweaks", (Config.Type)Config.Type.INSTANCE);
                if (UTConfig.TWEAKS_BLOCKS.BREAKABLE_BEDROCK.utBreakableBedrockToggle) {
                    UTBreakableBedrock.initToolList();
                }
                if (UTConfig.TWEAKS_MISC.SWING_THROUGH_GRASS.utSwingThroughGrassToggle) {
                    UTSwingThroughGrassLists.initLists();
                }
                if (UTConfig.TWEAKS_MISC.INCURABLE_POTIONS.utIncurablePotionsToggle) {
                    UTIncurablePotions.initPotionList();
                }
                if (UTLoadingPlugin.isClient) {
                    if (UTConfig.BUGFIXES_BLOCKS.BLOCK_OVERLAY.utBlockOverlayToggle) {
                        UTBlockOverlayLists.initLists();
                    }
                    if (Loader.isModLoaded((String)"botania")) {
                        UTBotaniaFancySkybox.initDimList();
                    }
                    if (UTConfig.TWEAKS_MISC.LOAD_SOUNDS.utLoadSoundMode != TweaksMiscCategory.LoadSoundsCategory.EnumSoundModes.NOTHING) {
                        UTLoadSound.initLists();
                    }
                }
                UTObsoleteModsScreenHandler.shouldDisplay = true;
                UniversalTweaks.LOGGER.info("Universal Tweaks config reloaded");
            }
        }
    }

    public static class ModIntegrationCategory {
        @Config.LangKey(value="cfg.universaltweaks.modintegration.bop")
        @Config.Name(value="Biomes O' Plenty")
        public final BiomesOPlentyCategory BIOMES_O_PLENTY = new BiomesOPlentyCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.botania")
        @Config.Name(value="Botania")
        public final BotaniaCategory BOTANIA = new BotaniaCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.esm")
        @Config.Name(value="Epic Siege Mod")
        public final EpicSiegeModCategory EPIC_SIEGE_MOD = new EpicSiegeModCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.forestry")
        @Config.Name(value="Forestry")
        public final ForestryCategory FORESTRY = new ForestryCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.moc")
        @Config.Name(value="Mo' Creatures")
        public final MoCreaturesCategory MO_CREATURES = new MoCreaturesCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.roost")
        @Config.Name(value="Roost")
        public final RoostCategory ROOST = new RoostCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.sd")
        @Config.Name(value="Storage Drawers")
        public final StorageDrawersCategory STORAGE_DRAWERS = new StorageDrawersCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.tc")
        @Config.Name(value="Thaumcraft")
        public final ThaumcraftCategory THAUMCRAFT = new ThaumcraftCategory();
        @Config.LangKey(value="cfg.universaltweaks.modintegration.tcon")
        @Config.Name(value="Tinkers' Construct")
        public final TinkersConstructCategory TINKERS_CONSTRUCT = new TinkersConstructCategory();

        public static class TinkersConstructCategory {
            @Config.Name(value="Gaseous Fluids")
            @Config.Comment(value={"Excludes gaseous fluids from being transferable via faucets"})
            public boolean utTConGaseousFluidsToggle = false;
            @Config.Name(value="Projectile Despawning")
            @Config.Comment(value={"Despawns unbreakable projectiles faster to improve framerates"})
            public boolean utTConProjectileToggle = true;
            @Config.Name(value="Offhand Shuriken")
            @Config.Comment(value={"Suppresses special abilities of long swords and rapiers when shurikens are wielded in the offhand"})
            public boolean utTConShurikenToggle = true;
            @Config.Name(value="Ore Dictionary Cache")
            @Config.Comment(value={"Caches all ore dictionary smelting recipes to speed up game loading"})
            public boolean utTConOreDictCacheToggle = true;
        }

        public static class ThaumcraftCategory {
            @Config.Name(value="Firebat Particles")
            @Config.Comment(value={"Adds particles to firebats similar to legacy versions"})
            public boolean utTCFirebatParticlesToggle = true;
            @Config.Name(value="Flower Bounding Box")
            @Config.Comment(value={"Fixes the bounding box always being at the center in both cinderpearls and shimmerleafs"})
            public boolean utTCFlowerBoundingBoxToggle = true;
            @Config.Name(value="Stable Thaumometer")
            @Config.Comment(value={"Stops the thaumometer from bobbing rapidly when using it to scan objects"})
            public boolean utTCStableThaumometerToggle = true;
            @Config.Name(value="Wisp Particles")
            @Config.Comment(value={"Increases particle size of wisps similar to legacy versions"})
            public boolean utTCWispParticlesToggle = true;
        }

        public static class StorageDrawersCategory {
            @Config.Name(value="Item Handlers")
            @Config.Comment(value={"Fixes voiding of items when nearing full capacity", "Fixes slotless item handler implementation not allowing the extraction from compacting item drawers with the vending upgrade", "Caches the drawer controller tile to avoid getting the TE from the world every time a drawer slave is interacted with"})
            public boolean utSDItemHandlers = true;
            @Config.Name(value="Render Range")
            @Config.Comment(value={"Approximate range in blocks at which drawers render contained items", "0 for default unlimited range"})
            public int utSDRenderRange = 0;
        }

        public static class RoostCategory {
            @Config.Name(value="ContentTweaker: Early Register CT Chickens")
            @Config.Comment(value={"Improves load time by registering CT chickens early for Roost to detect them", "Note: All CT chickens must be specified in \"Custom Chickens\" for this tweak to work!", "Note: The .zs files creating custom chickens must be loaded with '#loader preinit', not '#loader contenttweaker'!"})
            public boolean utRoostEarlyRegisterCTChickens = true;
            @Config.Name(value="Custom Chickens")
            @Config.Comment(value={"Adds custom chickens from mods (e.g. ContentTweaker) to Roost's stock texture check", "Syntax: name", "name     Chicken name"})
            public String[] utRoostChickenMods = new String[0];
        }

        public static class MoCreaturesCategory {
            @Config.Name(value="Custom Modded Biomes")
            @Config.Comment(value={"Adds support for modded biome spawns", "Syntax: modid;name;key;tag;filename", "modid    Mod ID required for this to be added", "name     Mod name", "key      Used for class lookups, needs to be a unique part of the modded package, e.g. mod.acgaming.*universaltweaks*.mods", "tag      Short tag for logs", "filename Filename to use for the generated config"})
            public String[] utMoCBiomeMods = new String[]{"pvj;vibrantjourneys;vibrantjourneys;PVJ;ProjectVibrantJourneys.cfg", "traverse;traverse;traverse;TRAV;Traverse.cfg", "dimdoors;dimdoors;dimdoors;DD;DimDoors.cfg"};
        }

        public static class ForestryCategory {
            @Config.Name(value="Arborist Villager Trades")
            @Config.Comment(value={"Adds custom emerald to germling trades to the arborist villager", "Syntax:        level;emeralds_min;emeralds_max;germlings_min;germlings_max;type;complexity_min;complexity_max", "level          Level when this trade becomes available (how much trading needs to be done)", "emeralds_min   Lower random limit for emeralds", "emeralds_max   Upper random limit for emeralds", "germlings_min  Lower random limit for germlings", "germlings_max  Upper random limit for germlings", "type           Type of germling, can be either pollen or sapling", "complexity_min Lower limit of allele complexity", "complexity_max Upper limit of allele complexity", "", "Example for a level 5 trade for a single sapling with a complexity between 6 and 10, costing between 10 to 40 emeralds:", "5;10;40;1;1;sapling;6;10"})
            public String[] utFOArboristDeals = new String[0];
            @Config.Name(value="Disable Bee Damage Armor Bypass")
            @Config.Comment(value={"Disables damage caused by bees bypassing player armor"})
            public boolean utFOBeeDamageArmorBypassToggle = true;
            @Config.Name(value="Extra Trees: Gather Windfall")
            @Config.Comment(value={"Allows Forestry farms to pick up ExtraTrees fruit"})
            public boolean utFOGatherWindfallToggle = true;
        }

        public static class EpicSiegeModCategory {
            @Config.Name(value="Disable Digger AI Debug")
            @Config.Comment(value={"Disables leftover debug logging inside the digger AI of the beta builds"})
            public boolean utESMDiggerDebugToggle = true;
        }

        public static class BotaniaCategory {
            @Config.Name(value="Fancy Skybox")
            @Config.Comment(value={"Enables the Botania Garden of Glass skybox for custom dimensions", "Abides by Botania's 'enableFancySkybox' config option", "Example: 43"})
            public Integer[] utBotaniaSkyboxDims = new Integer[0];
        }

        public static class BiomesOPlentyCategory {
            @Config.Name(value="Hot Spring Water")
            @Config.Comment(value={"Fixes rapid inflection of regeneration effects in hot spring water"})
            public boolean utBoPHotSpringWaterToggle = true;
        }
    }

    public static class DebugCategory {
        @Config.Name(value="Bypass Config Versioning")
        @Config.Comment(value={"Disables config resets on mod updates", "Please note that you will face duplicate/invalid config settings"})
        public boolean utBypassConfigVersioningToggle = false;
        @Config.Name(value="Bypass Incompatibility Warnings")
        @Config.Comment(value={"For those who live life on the edge, may or may not include Jons"})
        public boolean utBypassIncompatibilityToggle = false;
        @Config.Name(value="Config Version")
        @Config.Comment(value={"Version number of the config file", "Do not touch!"})
        public String utConfigVersion = "1.12.2-1.5.0";
        @Config.Name(value="Debug Logging")
        @Config.Comment(value={"Enables debug logging"})
        public boolean utDebugToggle = false;
        @Config.Name(value="Obsolete Mods Screen")
        @Config.Comment(value={"Enables a screen displaying incompatible mods on game load"})
        public boolean utObsoleteModsToggle = true;
        @Config.Name(value="Show Loading Time")
        @Config.Comment(value={"Prints the time the game needed to launch to the log"})
        public boolean utLoadingTimeToggle = true;
    }

    public static class TweaksWorldCategory {
        @Config.LangKey(value="cfg.universaltweaks.tweaks.world.chunkgenlimit")
        @Config.Name(value="Chunk Gen Limit")
        public final ChunkGenLimitCategory CHUNK_GEN_LIMIT = new ChunkGenLimitCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.world.dimensionunload")
        @Config.Name(value="Dimension Unload")
        public final DimensionUnloadCategory DIMENSION_UNLOAD = new DimensionUnloadCategory();
        @Config.Name(value="Stronghold Replacement")
        @Config.Comment(value={"Replaces stronghold generation with a safer variant"})
        public boolean utStrongholdToggle = true;
        @Config.Name(value="Tidy Chunk")
        @Config.Comment(value={"Tidies newly generated chunks by removing scattered item entities"})
        public boolean utTidyChunkToggle = false;

        public static class DimensionUnloadCategory {
            @Config.Name(value="[1] Dimension Unload Toggle")
            @Config.Comment(value={"Unloads dimensions not in use to free up resources"})
            public boolean utUnloaderToggle = true;
            @Config.Name(value="[2] Interval")
            @Config.Comment(value={"Time (in ticks) to wait before checking dimensions"})
            public int utUnloaderInterval = 600;
            @Config.Name(value="[3] Blacklist")
            @Config.Comment(value={"List of dimensions which should not be unloaded", "Can be dimension name or ID", "Uses regular expressions"})
            public String[] utUnloaderBlacklist = new String[]{"0", "overworld"};
        }

        public static class ChunkGenLimitCategory {
            @Config.Name(value="[1] Chunk Gen Limit Toggle")
            @Config.Comment(value={"Limits maximum chunk generation per tick for improved server performance"})
            public boolean utChunkGenLimitToggle = false;
            @Config.Name(value="[2] Ticks")
            @Config.Comment(value={"Maximum chunks to generate per tick per dimension"})
            public int utChunkGenLimitTicks = 2;
            @Config.Name(value="[3] Time")
            @Config.Comment(value={"Maximum time in ms to spend generating chunks per tick per dimension"})
            public int utChunkGenLimitTime = 5;
        }
    }

    public static class TweaksPerformanceCategory {
        @Config.Name(value="Check Animated Models")
        @Config.Comment(value={"Improves model load times by checking if an animated model exists before trying to load it"})
        public boolean utCheckAnimatedModelsToggle = true;
        @Config.Name(value="Crafting Cache")
        @Config.Comment(value={"Adds an IRecipe cache to improve recipe performance in larger modpacks"})
        public boolean utCraftingCacheToggle = true;
        @Config.Name(value="Disable Audio Debug")
        @Config.Comment(value={"Improves loading times by removing debug code for missing sounds and subtitles"})
        public boolean utDisableAudioDebugToggle = true;
        @Config.Name(value="Fast Dye Blending")
        @Config.Comment(value={"Replaces color lookup for sheep to check a predefined table rather than querying the recipe registry"})
        public boolean utDyeBlendingToggle = true;
        @Config.Name(value="Fast Prefix Checking")
        @Config.Comment(value={"Optimizes Forge's ID prefix checking and removes prefix warnings impacting load time"})
        public boolean utPrefixCheckToggle = true;
        @Config.Name(value="Fast World Loading")
        @Config.Comment(value={"Skips initial world chunk loading & garbage collection to speed up world loading"})
        public boolean utWorldLoadingToggle = false;
    }

    public static class TweaksMiscCategory {
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.incurablepotions")
        @Config.Name(value="Incurable Potions")
        public final IncurablePotionsCategory INCURABLE_POTIONS = new IncurablePotionsCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.loadsounds")
        @Config.Name(value="Load Sounds")
        public final LoadSoundsCategory LOAD_SOUNDS = new LoadSoundsCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.rallyhealth")
        @Config.Name(value="Rally Health")
        public final RallyHealthCategory RALLY_HEALTH = new RallyHealthCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.smoothscrolling")
        @Config.Name(value="Smooth Scrolling")
        public final SmoothScrollingCategory SMOOTH_SCROLLING = new SmoothScrollingCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.stg")
        @Config.Name(value="Swing Through Grass")
        public final SwingThroughGrassCategory SWING_THROUGH_GRASS = new SwingThroughGrassCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.misc.toastcontrol")
        @Config.Name(value="Toast Control")
        public final ToastControlCategory TOAST_CONTROL = new ToastControlCategory();
        @Config.Name(value="Damage Tilt")
        @Config.Comment(value={"Restores feature to tilt the camera when damaged"})
        public boolean utDamageTiltToggle = true;
        @Config.Name(value="Disable Narrator")
        @Config.Comment(value={"Disables the narrator functionality entirely"})
        public boolean utDisableNarratorToggle = true;
        @Config.Name(value="End Portal Parallax")
        @Config.Comment(value={"Re-implements parallax rendering of the end portal from 1.10 and older"})
        public boolean utEndPortalParallaxToggle = true;
        @Config.Name(value="Infinite Music")
        @Config.Comment(value={"Lets background music play continuously without delays"})
        public boolean utInfiniteMusicToggle = false;
        @Config.Name(value="Linear XP Amount")
        @Config.Comment(value={"Sets the amount of XP needed for each level, effectively removing the increasing level scaling", "0 for vanilla default"})
        public int utLinearXP = 0;
        @Config.Name(value="No Lightning Flash")
        @Config.Comment(value={"Disables the flashing of skybox and ground brightness on lightning strikes"})
        public boolean utLightningFlashToggle = false;
        @Config.Name(value="No Night Vision Flash")
        @Config.Comment(value={"Disables the flashing effect when the night vision potion effect is about to run out"})
        public boolean utNightVisionFlashToggle = false;
        @Config.Name(value="No Potion Shift")
        @Config.Comment(value={"Disables the inventory shift when potion effects are active"})
        public boolean utPotionShiftToggle = true;
        @Config.Name(value="No Redstone Lighting")
        @Config.Comment(value={"Disables lighting of active redstone, repeaters, and comparators to improve performance"})
        public boolean utRedstoneLightingToggle = false;
        @Config.Name(value="Offhand Improvement")
        @Config.Comment(value={"Prevents placing offhand blocks when blocks or food are held in the mainhand"})
        public boolean utOffhandToggle = true;
        @Config.Name(value="Remove Realms Button")
        @Config.Comment(value={"Removes the redundant Minecraft Realms button from the main menu"})
        public boolean utRealmsButtonToggle = true;
        @Config.Name(value="Remove Recipe Book")
        @Config.Comment(value={"Removes the recipe book button from GUIs"})
        public boolean utRecipeBookToggle = false;
        @Config.Name(value="Remove Snooper")
        @Config.Comment(value={"Forcefully turns off the snooper and hides the snooper settings button from the options menu"})
        public boolean utSnooperToggle = true;
        @Config.Name(value="Skip Credits")
        @Config.Comment(value={"Skips the credits screen after the player goes through the end podium portal"})
        public boolean utSkipCreditsToggle = false;
        @Config.Name(value="Toggle Cheats Button")
        @Config.Comment(value={"Adds a button to the pause menu to toggle cheats"})
        public boolean utToggleCheatsToggle = true;
        @Config.Name(value="Uncap FPS")
        @Config.Comment(value={"Removes the hardcoded 30 FPS limit in screens like the main menu"})
        public boolean utUncapFPSToggle = true;

        public static class ToastControlCategory {
            @Config.RequiresMcRestart
            @Config.Name(value="[1] Toast Control Toggle")
            @Config.Comment(value={"Enables the control of toasts (pop-up text boxes)"})
            public boolean utToastControlToggle = true;
            @Config.Name(value="[2] Disable Advancement Toasts")
            @Config.Comment(value={"Determines if advancement toasts are blocked. Enabling will block ALL advancements."})
            public boolean utToastControlAdvancementsToggle = false;
            @Config.Name(value="[3] Disable Recipe Toasts")
            @Config.Comment(value={"Determines if recipe unlock toasts are blocked. Blocks \"you have unlocked a new recipe\" toasts."})
            public boolean utToastControlRecipesToggle = true;
            @Config.Name(value="[4] Disable System Toasts")
            @Config.Comment(value={"Determines if system toasts are blocked. This is used only for the narrator toggle notification right now."})
            public boolean utToastControlSystemToggle = true;
            @Config.RequiresMcRestart
            @Config.Name(value="[5] Disable Tutorial Toasts")
            @Config.Comment(value={"Determines if tutorial toasts are blocked. Blocks useless things like use WASD to move."})
            public boolean utToastControlTutorialToggle = true;
        }

        public static class SwingThroughGrassCategory {
            @Config.Name(value="[1] Swing Through Grass Toggle")
            @Config.Comment(value={"Allows hitting entities through grass instead of breaking it"})
            public boolean utSwingThroughGrassToggle = true;
            @Config.Name(value="[2] Blacklist")
            @Config.Comment(value={"Excludes blocks from the swing through grass tweak", "Syntax: modid:block"})
            public String[] utSwingThroughGrassBlacklist = new String[0];
            @Config.Name(value="[3] Whitelist")
            @Config.Comment(value={"Includes blocks in the swing through grass tweak", "Syntax: modid:block"})
            public String[] utSwingThroughGrassWhitelist = new String[0];
        }

        public static class SmoothScrollingCategory {
            @Config.Name(value="[1] Smooth Scrolling Toggle")
            @Config.Comment(value={"Adds smooth scrolling to in-game lists"})
            public boolean utSmoothScrollingToggle = true;
            @Config.Name(value="[2] Bounce Back Multiplier")
            public double utSmoothScrollingBounce = 0.24;
            @Config.Name(value="[3] Scroll Duration")
            public int utSmoothScrollingDuration = 600;
            @Config.Name(value="[4] Scroll Step")
            public double utSmoothScrollingStep = 19.0;
        }

        public static class RallyHealthCategory {
            @Config.Name(value="[1] Rally Health Toggle")
            @Config.Comment(value={"Adds Bloodborne's Rally system to Minecraft", "Regain lost health when attacking back within the risk time"})
            public boolean utRallyHealthToggle = false;
            @Config.Name(value="[2] Risk Time")
            @Config.Comment(value={"Determines the risk time in ticks"})
            public int utRallyHealthRiskTime = 60;
            @Config.Name(value="[3] Heal Chance")
            @Config.Comment(value={"Determines the chance to regain health in percent"})
            public int utRallyHealthHealChance = 80;
            @Config.Name(value="[4] Indication Sound")
            @Config.Comment(value={"Plays an indication sound effect when health is regained"})
            public boolean utRallyHealthSound = false;
        }

        public static class LoadSoundsCategory {
            @Config.Name(value="[1] Mode")
            @Config.Comment(value={"Play load sound on..."})
            public EnumSoundModes utLoadSoundMode = EnumSoundModes.NOTHING;
            @Config.Name(value="[2] Minecraft Loaded Sounds")
            @Config.Comment(value={"Sounds to play when Minecraft is loaded", "Syntax: eventname;pitch"})
            public String[] utLoadSoundMC = new String[]{"entity.experience_orb.pickup;1.0", "entity.player.levelup;1.0"};
            @Config.Name(value="[3] World Loaded Sounds")
            @Config.Comment(value={"Sounds to play when the world is loaded", "Syntax: eventname;pitch"})
            public String[] utLoadSoundWorld = new String[]{"entity.experience_orb.pickup;1.0", "entity.player.levelup;1.0"};

            public static enum EnumSoundModes {
                NOTHING,
                MINECRAFT,
                WORLD,
                MINECRAFT_AND_WORLD;

            }
        }

        public static class IncurablePotionsCategory {
            @Config.Name(value="[1] Incurable Potions Toggle")
            @Config.Comment(value={"Determines if potion effects are curable with curative items like buckets of milk"})
            public boolean utIncurablePotionsToggle = true;
            @Config.Name(value="[2] Potion Effect List")
            @Config.Comment(value={"Syntax: modid:potioneffect"})
            public String[] utIncurablePotionsList = new String[0];
            @Config.Name(value="[3] List Mode")
            @Config.Comment(value={"Blacklist Mode: Potion effects incurable by curative items, others are curable", "Whitelist Mode: Potion effects curable by curative items, others are incurable"})
            public EnumLists utIncurablePotionsListMode = EnumLists.BLACKLIST;
        }
    }

    public static class TweaksItemsCategory {
        @Config.LangKey(value="cfg.universaltweaks.tweaks.items.itementities")
        @Config.Name(value="Item Entities")
        public final ItemEntitiesCategory ITEM_ENTITIES = new ItemEntitiesCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.items.mending")
        @Config.Name(value="Mending")
        public final MendingCategory MENDING = new MendingCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.items.parry")
        @Config.Name(value="Shield Parry")
        public final ParryCategory PARRY = new ParryCategory();
        @Config.Name(value="Auto Switch Tools")
        @Config.Comment(value={"Switches the selected hotbar slot to a proper tool if required"})
        public boolean utAutoSwitchToggle = false;
        @Config.Name(value="No Attack Cooldown")
        @Config.Comment(value={"Disables the 1.9 combat update attack cooldown"})
        public boolean utAttackCooldownToggle = false;
        @Config.Name(value="No Leftover Breath Bottles")
        @Config.Comment(value={"Disables Dragon's Breath from being a container item and leaving off empty bottles when a stack is brewed with"})
        public boolean utLeftoverBreathBottleToggle = true;
        @Config.Name(value="Bow Infinity")
        @Config.Comment(value={"Bows enchanted with Infinity no longer require arrows"})
        public boolean utBowInfinityToggle = true;
        @Config.Name(value="Super Hot Torch")
        @Config.Comment(value={"Enables one-time ignition of entities by hitting them with a torch"})
        public boolean utSuperHotTorchToggle = false;
        @Config.Name(value="XP Bottle Amount")
        @Config.Comment(value={"Sets the amount of experience spawned by bottles o' enchanting", "-1 for vanilla default"})
        public int utXPBottleAmount = -1;

        public static class ParryCategory {
            @Config.Name(value="[1] Shield Parry Toggle")
            @Config.Comment(value={"Allows parrying of projectiles with shields"})
            public boolean utParryToggle = false;
            @Config.Name(value="[2] Arrow Time Window")
            @Config.Comment(value={"Determines the amount of time an arrow can be parried after raising the shield", "Measured in ticks"})
            public int utParryArrowTimeWindow = 40;
            @Config.Name(value="[3] Fireball Time Window")
            @Config.Comment(value={"Determines the amount of time a fireball can be parried after raising the shield", "Measured in ticks"})
            public int utParryFireballTimeWindow = 40;
            @Config.Name(value="[4] Throwable Time Window")
            @Config.Comment(value={"Determines the amount of time a throwable can be parried after raising the shield", "Measured in ticks"})
            public int utParryThrowableTimeWindow = 40;
            @Config.Name(value="[5] Rebound Enchantment")
            @Config.Comment(value={"Adds the Rebound enchantment for extended parry time windows"})
            public boolean utParryReboundToggle = true;
            @Config.Name(value="[6] Rebound Treasure Enchantment")
            @Config.Comment(value={"Makes the Rebound enchantment exclusive to enchanted books as loot"})
            public boolean utParryReboundTreasure = false;
            @Config.Name(value="[7] Rebound Max Level")
            @Config.Comment(value={"Maximum enchantment level for the Rebound enchantment"})
            public int utParryReboundMaxLevel = 5;
            @Config.Name(value="[8] Rebound Multiplier")
            @Config.Comment(value={"Multiplier for the parry time windows"})
            public float utParryReboundMultiplier = 0.25f;
        }

        public static class MendingCategory {
            @Config.Name(value="[1] Mending Toggle")
            @Config.Comment(value={"Implements modern mending behavior to only repair damaged equipment with XP"})
            public boolean utMendingToggle = true;
            @Config.Name(value="[2] Ratio")
            @Config.Comment(value={"Determines the amount of durability mending will repair, on average, per point of experience"})
            public float utMendingRatio = 2.0f;
            @Config.Name(value="[3] Overpowered")
            @Config.Comment(value={"Repairs damaged items from the entire inventory with XP"})
            public boolean utMendingOPToggle = false;
        }

        public static class ItemEntitiesCategory {
            @Config.Name(value="[01] Item Entities Toggle")
            @Config.Comment(value={"Enables the modification of item entity properties"})
            public boolean utItemEntitiesToggle = true;
            @Config.Name(value="[02] Physics")
            @Config.Comment(value={"Adds physical aspects such as collision boxes to item entities"})
            public boolean utIEPhysicsToggle = false;
            @Config.Name(value="[03] Automatic Pickup")
            @Config.Comment(value={"Item entities can be picked up automatically", "When disabled, item entities can be picked up by right-clicking (requires 'Physics' option)"})
            public boolean utIEAutomaticPickupToggle = true;
            @Config.Name(value="[04] Sneaking Pickup")
            @Config.Comment(value={"Item entities can only be picked up when sneaking"})
            public boolean utIESneakingPickupToggle = false;
            @Config.Name(value="[05] Collection Tool")
            @Config.Comment(value={"Tools which enable picking up items automatically", "Example -> minecraft:bucket"})
            public String[] utIECollectionTools = new String[0];
            @Config.Name(value="[06] Pickup Delay")
            @Config.Comment(value={"Determines the delay in ticks until item entities can be picked up", "-1 for vanilla default"})
            public int utIEPickupDelay = -1;
            @Config.Name(value="[07] Lifespan")
            @Config.Comment(value={"Determines the time in ticks until item entities get despawned", "-1 for vanilla default"})
            public int utIELifespan = -1;
            @Config.Name(value="[08] No Combination")
            @Config.Comment(value={"Stops combination of item entities"})
            public boolean utIENoCombinationToggle = false;
            @Config.Name(value="[09] Smart Combination")
            @Config.Comment(value={"Stops combination of item entities if their maximum stack size is reached"})
            public boolean utIESmartCombinationToggle = true;
            @Config.Name(value="[10] Smart Combination Radius")
            @Config.Comment(value={"The radius (in blocks) that dropped items should check around them for other dropped items to combine with", "Depends on the Smart Combination toggle"})
            public double utIESmartCombinationRadius = 2.0;
            @Config.Name(value="[11] Smart Combination Y-Axis Check")
            @Config.Comment(value={"Allows dropped items to also check above and below them for combination", "Depends on the Smart Combination toggle"})
            public boolean utIESmartCombinationYAxis = true;
            @Config.Name(value="[12] Rotation")
            @Config.Comment(value={"Enables the rotation effect"})
            public boolean utIERotationToggle = true;
            @Config.Name(value="[13] Bobbing")
            @Config.Comment(value={"Enables the bobbing effect"})
            public boolean utIEBobbingToggle = true;
            @Config.Name(value="[14] Clear Despawn")
            @Config.Comment(value={"Makes item entities flash when they're about to despawn"})
            public boolean utIEClearDespawnToggle = false;
            @Config.Name(value="[15] Clear Despawn: Flashing Time")
            @Config.Comment(value={"Determines the time in seconds item entities have left before despawn to start flashing"})
            public int utIEClearDespawnTime = 20;
            @Config.Name(value="[16] Clear Despawn: Urgent Flashing")
            @Config.Comment(value={"Makes item entities flash faster as they get closer to despawning"})
            public boolean utIEClearDespawnUrgentToggle = true;
        }
    }

    public static class TweaksEntitiesCategory {
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.attributes")
        @Config.Name(value="Attributes")
        public final AttributesCategory ATTRIBUTES = new AttributesCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.betterburning")
        @Config.Name(value="Better Burning")
        public final BetterBurningCategory BETTER_BURNING = new BetterBurningCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.easybreeding")
        @Config.Name(value="Easy Breeding")
        public final EasyBreedingCategory EASY_BREEDING = new EasyBreedingCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.collisiondamage")
        @Config.Name(value="Collision Damage")
        public final CollisionDamageCategory COLLISION_DAMAGE = new CollisionDamageCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.nogolems")
        @Config.Name(value="No Golems")
        public final NoGolemsCategory NO_GOLEMS = new NoGolemsCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.playerspeed")
        @Config.Name(value="Player Speed")
        public final PlayerSpeedCategory PLAYER_SPEED = new PlayerSpeedCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.entities.waterfalldamage")
        @Config.Name(value="Water Fall Damage")
        public final WaterFallDamageCategory WATER_FALL_DAMAGE = new WaterFallDamageCategory();
        @Config.Name(value="AI Replacement")
        @Config.Comment(value={"Replaces entity AI for improved server performance"})
        public boolean utAIReplacementToggle = true;
        @Config.Name(value="AI Removal")
        @Config.Comment(value={"Removes entity AI for improved server performance"})
        public boolean utAIRemovalToggle = false;
        @Config.Name(value="Auto Jump Replacement")
        @Config.Comment(value={"Replaces auto jump with an increased step height"})
        public boolean utAutoJumpToggle = true;
        @Config.Name(value="Better Ignition")
        @Config.Comment(value={"Enables ignition of entities by right-clicking instead of awkwardly lighting the block under them"})
        public boolean utBetterIgnitionToggle = true;
        @Config.Name(value="Boat Speed")
        @Config.Comment(value={"Sets the acceleration value for controlling boats"})
        public double utBoatSpeed = 0.04;
        @Config.Name(value="Creeper Confetti")
        @Config.Comment(value={"Replaces deadly creeper explosions with delightful confetti"})
        public boolean utCreeperConfettiToggle = false;
        @Config.Name(value="Charged Creeper Spawning Chance")
        @Config.Comment(value={"Sets the chance for creepers to spawn charged"})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double utChargedCreeperSpawnChance = 0.0;
        @Config.Name(value="Disable Sleeping")
        @Config.Comment(value={"Disables skipping night by using a bed while making it still able to set spawn"})
        public boolean utSleepingToggle = false;
        @Config.Name(value="Husk & Stray Spawning")
        @Config.Comment(value={"Lets husks and strays spawn underground like regular zombies and skeletons"})
        public boolean utHuskStraySpawningToggle = true;
        @Config.Name(value="Mob Despawn Improvement")
        @Config.Comment(value={"Mobs carrying picked up items will drop their equipment and despawn properly"})
        public boolean utMobDespawnToggle = true;
        @Config.Name(value="No Saddled Wandering")
        @Config.Comment(value={"Stops horses wandering around when saddled"})
        public boolean utSaddledWanderingToggle = true;

        public static class WaterFallDamageCategory {
            @Config.Name(value="[1] Water Fall Damage Toggle")
            @Config.Comment(value={"Re-implements an improved version of pre-1.4 fall damage in water"})
            public boolean utFallDamageToggle = false;
            @Config.Name(value="[2] Damage Reduction")
            @Config.Comment(value={"How much fall damage gets reduced by water per tick"})
            public float utFallDamageValue = 2.0f;
        }

        public static class PlayerSpeedCategory {
            @Config.Name(value="[1] Player Speed Toggle")
            @Config.Comment(value={"Enables the modification of base and maximum player speeds"})
            public boolean utPlayerSpeedToggle = false;
            @Config.Name(value="[2] Walk Speed")
            @Config.Comment(value={"Determines the player's base walk speed"})
            public double utPlayerWalkSpeed = 0.1;
            @Config.Name(value="[3] Fly Speed")
            @Config.Comment(value={"Determines the player's base fly speed"})
            public double utPlayerFlySpeed = 0.05;
            @Config.Name(value="[4] Max Speed")
            @Config.Comment(value={"Determines the player's maximum speed", "Increase if you get the infamous 'Player moved too quickly' messages"})
            public double utPlayerMaxSpeed = 100.0;
            @Config.Name(value="[5] Max Elytra Speed")
            @Config.Comment(value={"Determines the player's maximum speed when flying with elytra", "Increase if you get the infamous 'Player moved too quickly' messages"})
            public double utPlayerMaxElytraSpeed = 300.0;
            @Config.Name(value="[6] Max Vehicle Speed")
            @Config.Comment(value={"Determines the player's maximum speed when riding a vehicle or mount", "Increase if you get the infamous 'Player moved too quickly' messages"})
            public double utPlayerVehicleSpeed = 100.0;
        }

        public static class NoGolemsCategory {
            @Config.Name(value="[1] Iron Golem Toggle")
            @Config.Comment(value={"Disables the manual creation of iron golems"})
            public boolean utNGIronGolemToggle = false;
            @Config.Name(value="[2] Snow Golem Toggle")
            @Config.Comment(value={"Disables the manual creation of snow golems"})
            public boolean utNGSnowGolemToggle = false;
            @Config.Name(value="[3] Wither Toggle")
            @Config.Comment(value={"Disables the manual creation of withers"})
            public boolean utNGWitherToggle = false;
        }

        public static class CollisionDamageCategory {
            @Config.Name(value="[1] Collision Damage Toggle")
            @Config.Comment(value={"Applies horizontal collision damage to the player akin to elytra collision"})
            public boolean utCollisionDamageToggle = false;
            @Config.Name(value="[2] Damage Factor")
            @Config.Comment(value={"The damage factor that gets multiplied with the player speed", "Vanilla default for elytra damage is 10"})
            public int utCollisionDamageFactor = 10;
        }

        public static class EasyBreedingCategory {
            @Config.Name(value="[1] Easy Breeding Toggle")
            @Config.Comment(value={"Enables easy breeding of animals by tossing food on the ground"})
            public boolean utEasyBreedingToggle = false;
            @Config.Name(value="[2] Search Distance")
            @Config.Comment(value={"Determines the distance for animals to search for food"})
            public double utEasyBreedingDistance = 10.0;
        }

        public static class BetterBurningCategory {
            @Config.Name(value="[1] Cooked Items")
            @Config.Comment(value={"Fixes some edge cases where fire damage sources won't cause mobs to drop their cooked items"})
            public boolean utBBCookedToggle = true;
            @Config.Name(value="[2] Extinguishing")
            @Config.Comment(value={"If entities have fire resistance, they get extinguished right away when on fire"})
            public boolean utBBExtinguishToggle = true;
            @Config.Name(value="[3] Fire Overlay")
            @Config.Comment(value={"Prevents the fire animation overlay from being displayed when the player is immune to fire"})
            public boolean utBBOverlayToggle = true;
            @Config.Name(value="[4] Flaming Arrows")
            @Config.Comment(value={"Allows skeletons to shoot flaming arrows when on fire (30% chance * regional difficulty)"})
            public boolean utBBArrowsToggle = true;
            @Config.Name(value="[5] Spreading Fire")
            @Config.Comment(value={"Allows fire to spread from entity to entity (30% chance * regional difficulty)"})
            public boolean utBBSpreadingToggle = true;
        }

        public static class AttributesCategory {
            @Config.Name(value="[01] Attributes Toggle")
            @Config.Comment(value={"Sets custom ranges for entity attributes"})
            public boolean utAttributesToggle = true;
            @Config.Name(value="[02] Max Health Min")
            public double utAttributeMaxHealthMin = -65536.0;
            @Config.Name(value="[03] Max Health Max")
            public double utAttributeMaxHealthMax = 65536.0;
            @Config.Name(value="[04] Follow Range Min")
            public double utAttributeFollowRangeMin = -65536.0;
            @Config.Name(value="[05] Follow Range Max")
            public double utAttributeFollowRangeMax = 65536.0;
            @Config.Name(value="[06] Knockback Resistance Min")
            public double utAttributeKnockbackResistanceMin = -65536.0;
            @Config.Name(value="[07] Knockback Resistance Max")
            public double utAttributeKnockbackResistanceMax = 65536.0;
            @Config.Name(value="[08] Movement Speed Min")
            public double utAttributeMovementSpeedMin = -65536.0;
            @Config.Name(value="[09] Movement Speed Max")
            public double utAttributeMovementSpeedMax = 65536.0;
            @Config.Name(value="[10] Flying Speed Min")
            public double utAttributeFlyingSpeedMin = -65536.0;
            @Config.Name(value="[11] Flying Speed Max")
            public double utAttributeFlyingSpeedMax = 65536.0;
            @Config.Name(value="[12] Attack Damage Min")
            public double utAttributeAttackDamageMin = -65536.0;
            @Config.Name(value="[13] Attack Damage Max")
            public double utAttributeAttackDamageMax = 65536.0;
            @Config.Name(value="[14] Attack Speed Min")
            public double utAttributeAttackSpeedMin = -65536.0;
            @Config.Name(value="[15] Attack Speed Max")
            public double utAttributeAttackSpeedMax = 65536.0;
            @Config.Name(value="[16] Armor Min")
            public double utAttributeArmorMin = -65536.0;
            @Config.Name(value="[17] Armor Max")
            public double utAttributeArmorMax = 65536.0;
            @Config.Name(value="[18] Armor Toughness Min")
            public double utAttributeArmorToughnessMin = -65536.0;
            @Config.Name(value="[19] Armor Toughness Max")
            public double utAttributeArmorToughnessMax = 65536.0;
            @Config.Name(value="[20] Luck Min")
            public double utAttributeLuckMin = -65536.0;
            @Config.Name(value="[21] Luck Max")
            public double utAttributeLuckMax = 65536.0;
        }
    }

    public static class TweaksBlocksCategory {
        @Config.LangKey(value="cfg.universaltweaks.tweaks.blocks.betterplacement")
        @Config.Name(value="Better Placement")
        public final BetterPlacementCategory BETTER_PLACEMENT = new BetterPlacementCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.blocks.breakablebedrock")
        @Config.Name(value="Breakable Bedrock")
        public final BreakableBedrockCategory BREAKABLE_BEDROCK = new BreakableBedrockCategory();
        @Config.LangKey(value="cfg.universaltweaks.tweaks.blocks.finitewater")
        @Config.Name(value="Finite Water")
        public final FiniteWaterCategory FINITE_WATER = new FiniteWaterCategory();
        @Config.Name(value="Bed Obstruction Replacement")
        @Config.Comment(value={"Replaces bed obstruction checks with an improved version"})
        public boolean utBedObstructionToggle = true;
        @Config.Name(value="Better Harvest")
        @Config.Comment(value={"Prevents breaking lower parts of sugar cane and cacti as well as unripe crops, unless sneaking"})
        public boolean utBetterHarvestToggle = false;
        @Config.Name(value="Cactus Size")
        @Config.Comment(value={"Determines how tall cacti can grow"})
        public int utCactusSize = 3;
        @Config.Name(value="Fast Leaf Decay")
        @Config.Comment(value={"Makes leaves decay faster when trees are chopped"})
        public boolean utLeafDecayToggle = true;
        @Config.Name(value="Fence/Wall Jump")
        @Config.Comment(value={"Allows the player to jump over fences and walls"})
        public boolean utFenceWallJumpToggle = true;
        @Config.Name(value="Hardcore Buckets")
        @Config.Comment(value={"Prevents placing of liquid source blocks in the world"})
        public boolean utHardcoreBucketsToggle = false;
        @Config.Name(value="Sugar Cane Size")
        @Config.Comment(value={"Determines how tall sugar cane can grow"})
        public int utSugarCaneSize = 3;

        public static class FiniteWaterCategory {
            @Config.Name(value="[1] Finite Water Toggle")
            @Config.Comment(value={"Prevents creation of infinite water sources"})
            public boolean utFiniteWaterToggle = false;
            @Config.Name(value="[2] Allow Water Biomes")
            @Config.Comment(value={"Allows creation of infinite water sources in ocean and river biomes"})
            public boolean utFiniteWaterWaterBiomes = true;
            @Config.Name(value="[3] Minimum Altitude")
            @Config.Comment(value={"Inclusive minimum altitude at which water is infinite"})
            public int utFiniteWaterInfMin = 0;
            @Config.Name(value="[4] Maximum Altitude")
            @Config.Comment(value={"Inclusive maximum altitude at which water is infinite"})
            public int utFiniteWaterInfMax = 63;
        }

        public static class BreakableBedrockCategory {
            @Config.Name(value="[1] Breakable Bedrock Toggle")
            @Config.Comment(value={"Allows customizable mining of bedrock"})
            public boolean utBreakableBedrockToggle = false;
            @Config.Name(value="[2] Tool List")
            @Config.Comment(value={"List of tools concerning mining bedrock", "If empty, allows every tool to be used", "Syntax: modid:tool"})
            public String[] utBreakableBedrockToolList = new String[0];
            @Config.Name(value="[3] List Mode")
            @Config.Comment(value={"Blacklist Mode: Tools which can't mine bedrock, others can", "Whitelist Mode: Tools which can mine bedrock, others can't"})
            public EnumLists utBreakableBedrockToolListMode = EnumLists.BLACKLIST;
        }

        public static class BetterPlacementCategory {
            @Config.Name(value="[1] Better Placement Toggle")
            @Config.Comment(value={"Removes the delay between placing blocks"})
            public boolean utBetterPlacementToggle = false;
            @Config.Name(value="[2] Force New Location")
            @Config.Comment(value={"If the cursor must be moved to a new location before placing another block"})
            public boolean utBetterPlacementNewLoc = true;
            @Config.Name(value="[3] Creative Mode Only")
            @Config.Comment(value={"Only affects block placement in creative mode"})
            public boolean utBetterPlacementCreative = false;
        }
    }

    public static class BugfixesWorldCategory {
        @Config.Name(value="Chunk Saving")
        @Config.Comment(value={"Fixes loading of outdated chunks to prevent duplications, deletions and data corruption"})
        public boolean utChunkSavingToggle = true;
        @Config.Name(value="Frustum Culling")
        @Config.Comment(value={"Fixes invisible chunks in edge cases (small enclosed rooms at chunk borders)"})
        public boolean utFrustumCullingToggle = true;
        @Config.Name(value="Tile Entity Update Order")
        @Config.Comment(value={"Keeps the order of tile entities on chunk load"})
        public boolean utTELoadOrderToggle = true;
    }

    public static class BugfixesMiscCategory {
        @Config.LangKey(value="cfg.universaltweaks.bugfixes.misc.modelgap")
        @Config.Name(value="Model Gap")
        public final ModelGapCategory MODEL_GAP = new ModelGapCategory();
        @Config.Name(value="Accurate Smooth Lighting")
        @Config.Comment(value={"Improves the accuracy of smooth lighting by checking for suffocation and light opacity"})
        public boolean utAccurateSmoothLighting = true;
        @Config.Name(value="Depth Mask")
        @Config.Comment(value={"Fixes entity and particle rendering issues by enabling depth buffer writing"})
        public boolean utDepthMaskToggle = true;
        @Config.Name(value="Faster Background Startup")
        @Config.Comment(value={"Fixes slow background startup edge case caused by checking tooltips during the loading process"})
        public boolean utFasterBackgroundStartupToggle = false;
        @Config.Name(value="Help Command")
        @Config.Comment(value={"Replaces the help command, sorts and reports broken commands"})
        public boolean utHelpToggle = true;
        @Config.Name(value="Locale Crash")
        @Config.Comment(value={"Prevents various crashes with Turkish locale"})
        public boolean utLocaleToggle = true;

        public static class ModelGapCategory {
            @Config.Name(value="[1] Model Gap Toggle")
            @Config.Comment(value={"Fixes transparent gaps in all 3D models of blocks and items"})
            public boolean utModelGapToggle = true;
            @Config.Name(value="[2] Recess Value")
            @Config.Comment(value={"Quad X/Y offset", "Moves the quad toward the center of the item", "Use to hide gaps, keep as close to 0 as possible"})
            public double utModelGapRecess = 0.007;
            @Config.Name(value="[3] Expansion Value")
            @Config.Comment(value={"Quad expansion increment", "Enlarges each quad", "Use to hide gaps, keep as close to 0 as possible"})
            public double utModelGapExpansion = 0.008;
        }
    }

    public static class BugfixesEntitiesCategory {
        @Config.Name(value="Block Fire")
        @Config.Comment(value={"Prevents fire projectiles burning entities when blocking with shields"})
        public boolean utBlockFireToggle = true;
        @Config.Name(value="Boat Riding Offset")
        @Config.Comment(value={"Fixes entities glitching through the bottom of boats"})
        public boolean utBoatOffsetToggle = true;
        @Config.Name(value="Death Time")
        @Config.Comment(value={"Fixes corrupted entities exceeding the allowed death time"})
        public boolean utDeathTimeToggle = true;
        @Config.Name(value="Destroy Entity Packets")
        @Config.Comment(value={"Fixes lag caused by dead entities by sending additional packets when the player is not alive"})
        public boolean utDestroyPacketToggle = true;
        @Config.Name(value="Disconnect Dupe")
        @Config.Comment(value={"Fixes item dupes when players are dropping items and disconnecting"})
        public boolean utDisconnectDupeToggle = true;
        @Config.Name(value="Dimension Change Player States")
        @Config.Comment(value={"Fixes missing player states when changing dimensions by sending additional packets"})
        public boolean utDimensionChangeToggle = true;
        @Config.Name(value="Double Consumption")
        @Config.Comment(value={"Fixes consuming an item having a chance of also consuming a second item without any animation"})
        public boolean utDoubleConsumptionToggle = true;
        @Config.Name(value="Entity Bounding Box")
        @Config.Comment(value={"Saves entity bounding boxes to tags to prevent breakouts and suffocation"})
        public boolean utEntityAABBToggle = true;
        @Config.Name(value="Entity Desync")
        @Config.Comment(value={"Fixes entity motion desyncs most notable with arrows and thrown items"})
        public boolean utEntityDesyncToggle = true;
        @Config.Name(value="Entity NaN Values")
        @Config.Comment(value={"Prevents corruption of entities caused by invalid health or damage values"})
        public boolean utEntityNaNToggle = true;
        @Config.Name(value="Entity Suffocation")
        @Config.Comment(value={"Pushes entities out of blocks when growing up to prevent suffocation"})
        public boolean utEntitySuffocationToggle = true;
        @Config.Name(value="Entity Tracker")
        @Config.Comment(value={"Fixes entity tracker to prevent client-sided desyncs when teleporting or changing dimensions"})
        public boolean utEntityTrackerToggle = true;
        @Config.Name(value="Entity UUID")
        @Config.Comment(value={"Changes UUIDs of loaded entities in case their UUIDs are already assigned (and removes log spam)"})
        public boolean utEntityUUIDToggle = true;
        @Config.Name(value="Max Player Health")
        @Config.Comment(value={"Corrects maximum player health on joining by setting the last saved health value"})
        public boolean utMaxHealthToggle = true;
        @Config.Name(value="Player Saturation")
        @Config.Comment(value={"Fixes saturation depleting in peaceful mode"})
        public boolean utExhaustionToggle = true;
        @Config.Name(value="Skeleton Aim")
        @Config.Comment(value={"Fixes skeletons not looking at their targets when strafing"})
        public boolean utSkeletonAimToggle = true;
        @Config.Name(value="Villager Mantle Hoods")
        @Config.Comment(value={"Returns missing hoods to villager mantles"})
        public boolean utVillagerMantleToggle = true;
    }

    public static class BugfixesBlocksCategory {
        @Config.LangKey(value="cfg.universaltweaks.bugfixes.blocks.blockoverlay")
        @Config.Name(value="Block Overlay")
        public final BlockOverlayCategory BLOCK_OVERLAY = new BlockOverlayCategory();
        @Config.Name(value="Comparator Timing")
        @Config.Comment(value={"Fixes inconsistent delays of comparators to prevent redstone timing issues"})
        public boolean utComparatorTimingToggle = true;
        @Config.Name(value="Hopper Bounding Box")
        @Config.Comment(value={"Slims down the hopper bounding box for easier access of nearby blocks"})
        public boolean utDietHopperToggle = true;
        @Config.Name(value="Hopper Insert Safety Check")
        @Config.Comment(value={"Prevents crashes when the destination tile entity becomes unavailable during the item insert process", "Mainly utilized to suppress edge case symptoms with Thaumcraft's Thaumatorium"})
        public boolean utHopperInsertToggle = true;
        @Config.Name(value="Item Frame Void")
        @Config.Comment(value={"Prevents voiding held items when right + left clicking on an item frame simultaneously"})
        public boolean utItemFrameVoidToggle = true;
        @Config.Name(value="Ladder Flying Slowdown")
        @Config.Comment(value={"Disables climbing movement when flying"})
        public boolean utLadderFlyingToggle = true;
        @Config.Name(value="Mining Glitch")
        @Config.Comment(value={"Avoids the need for multiple mining attempts by sending additional movement packets"})
        public boolean utMiningGlitchToggle = true;
        @Config.Name(value="Piston Progress")
        @Config.Comment(value={"Properly saves the last state of pistons to tags"})
        public boolean utPistonTileToggle = true;

        public static class BlockOverlayCategory {
            @Config.Name(value="[1] Block Overlay Toggle")
            @Config.Comment(value={"Fixes x-ray when standing in non-suffocating blocks"})
            public boolean utBlockOverlayToggle = true;
            @Config.Name(value="[2] Blacklist")
            @Config.Comment(value={"Excludes blocks from the block overlay bugfix", "Syntax: modid:block"})
            public String[] utBlockOverlayBlacklist = new String[0];
            @Config.Name(value="[3] Whitelist")
            @Config.Comment(value={"Includes blocks in the block overlay bugfix", "Syntax: modid:block"})
            public String[] utBlockOverlayWhitelist = new String[0];
        }
    }

    public static enum EnumLists {
        WHITELIST,
        BLACKLIST;

    }
}

