/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.bugfixes.entities.maxhealth.mixin;

import javax.annotation.Nullable;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfig;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityLivingBase.class})
public abstract class UTMaxHealthMixin {
    @Unique
    @Nullable
    public Float actualHealth = null;

    @Shadow
    public abstract float func_110138_aP();

    @Shadow
    public abstract float func_110143_aJ();

    @Shadow
    public abstract void func_70606_j(float var1);

    @Inject(method={"readEntityFromNBT"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;setHealth(F)V")})
    public void utGetHealth(NBTTagCompound compound, CallbackInfo ci) {
        float savedHealth;
        if (!UTConfig.BUGFIXES_ENTITIES.utMaxHealthToggle) {
            return;
        }
        if (UTConfig.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTMaxHealth ::: Read entity from NBT");
        }
        if ((savedHealth = compound.func_74760_g("Health")) > this.func_110138_aP() && savedHealth > 0.0f) {
            this.actualHealth = Float.valueOf(savedHealth);
        }
    }

    @Inject(method={"onUpdate"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/EntityLivingBase;ticksExisted:I")})
    public void utSetHealth(CallbackInfo ci) {
        if (!UTConfig.BUGFIXES_ENTITIES.utMaxHealthToggle) {
            return;
        }
        if (UTConfig.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("UTMaxHealth ::: On update");
        }
        if (this.actualHealth != null && this.actualHealth.floatValue() > 0.0f && this.actualHealth.floatValue() > this.func_110143_aJ()) {
            this.func_70606_j(this.actualHealth.floatValue());
            this.actualHealth = null;
        }
    }
}

