/*
 * Decompiled with CFR 0.152.
 */
package us.drullk.parry;

import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@Mod(modid="parry", name="Shield Parrying", version="1.0", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber(modid="parry")
public class ShieldParry {
    public static final String MODID = "parry";
    public static final String NAME = "Shield Parrying";
    public static final String VERSION = "1.0";
    private static Logger LOGGER = LogManager.getLogger((String)"parry");
    private static Enchantment enchantment;
    private static final String enchantmentName = "parry";
    private static EnumEnchantmentType enchantmentTypeShield;

    @SubscribeEvent
    public static void registerEnchantment(RegistryEvent.Register<Enchantment> event) {
        enchantmentTypeShield = EnumHelper.addEnchantmentType((String)"shield", input -> input instanceof ItemShield || input != null && input.isShield(new ItemStack(input, 1, 0), null));
        enchantment = ((Enchantment)new EnchantmentPrecision(Enchantment.Rarity.COMMON).setRegistryName(new ResourceLocation("parry", "parry"))).func_77322_b("parry");
        event.getRegistry().register((IForgeRegistryEntry)enchantment);
    }

    @SubscribeEvent
    public static void arrowParry(ProjectileImpactEvent.Arrow event) {
        final EntityArrow projectile = event.getArrow();
        if (!projectile.func_130014_f_().field_72995_K) {
            EntityLivingBase entityBlocking;
            Entity entity = event.getRayTraceResult().field_72308_g;
            if (event.getEntity() != null && entity instanceof EntityLivingBase && (entityBlocking = (EntityLivingBase)entity).func_184583_d(new DamageSource("parry_this"){

                public Vec3d func_188404_v() {
                    return projectile.func_174791_d();
                }
            }) && entityBlocking.func_184607_cu().func_77973_b().func_77626_a(entityBlocking.func_184607_cu()) - entityBlocking.func_184605_cv() <= ShieldParry.applyTimerBonus(ModConfig.shieldParryTicksArrow, entityBlocking.func_184607_cu(), ModConfig.shieldEnchantmentMultiplierArrow)) {
                Vec3d playerVec3 = entityBlocking.func_70040_Z();
                projectile.func_70186_c(playerVec3.field_72450_a, playerVec3.field_72448_b, playerVec3.field_72449_c, 1.1f, 0.1f);
                projectile.field_70250_c = entityBlocking;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void fireballParry(ProjectileImpactEvent.Fireball event) {
        final EntityFireball projectile = event.getFireball();
        if (!projectile.func_130014_f_().field_72995_K) {
            EntityLivingBase entityBlocking;
            Entity entity = event.getRayTraceResult().field_72308_g;
            if (event.getEntity() != null && entity instanceof EntityLivingBase && (entityBlocking = (EntityLivingBase)entity).func_184583_d(new DamageSource("parry_this"){

                public Vec3d func_188404_v() {
                    return projectile.func_174791_d();
                }
            }) && entityBlocking.func_184607_cu().func_77973_b().func_77626_a(entityBlocking.func_184607_cu()) - entityBlocking.func_184605_cv() <= ShieldParry.applyTimerBonus(ModConfig.shieldParryTicksFireball, entityBlocking.func_184607_cu(), ModConfig.shieldEnchantmentMultiplierFireball)) {
                Vec3d playerVec3 = entityBlocking.func_70040_Z();
                projectile.field_70159_w = playerVec3.field_72450_a;
                projectile.field_70181_x = playerVec3.field_72448_b;
                projectile.field_70179_y = playerVec3.field_72449_c;
                projectile.field_70232_b = projectile.field_70159_w * 0.1;
                projectile.field_70233_c = projectile.field_70181_x * 0.1;
                projectile.field_70230_d = projectile.field_70179_y * 0.1;
                projectile.field_70235_a = entityBlocking;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void throwableParry(ProjectileImpactEvent.Throwable event) {
        final EntityThrowable projectile = event.getThrowable();
        if (!projectile.func_130014_f_().field_72995_K) {
            EntityLivingBase entityBlocking;
            Entity entity = event.getRayTraceResult().field_72308_g;
            if (event.getEntity() != null && entity instanceof EntityLivingBase && (entityBlocking = (EntityLivingBase)entity).func_184583_d(new DamageSource("parry_this"){

                public Vec3d func_188404_v() {
                    return projectile.func_174791_d();
                }
            }) && entityBlocking.func_184607_cu().func_77973_b().func_77626_a(entityBlocking.func_184607_cu()) - entityBlocking.func_184605_cv() <= ShieldParry.applyTimerBonus(ModConfig.shieldParryTicksThrowable, entityBlocking.func_184607_cu(), ModConfig.shieldEnchantmentMultiplierThrowable)) {
                Vec3d playerVec3 = entityBlocking.func_70040_Z();
                projectile.func_70186_c(playerVec3.field_72450_a, playerVec3.field_72448_b, playerVec3.field_72449_c, 1.1f, 0.1f);
                projectile.field_70192_c = entityBlocking;
                event.setCanceled(true);
            }
        }
    }

    private static int applyTimerBonus(int base, ItemStack stack, float multiplier) {
        return (int)((float)base + (float)(base * ShieldParry.getEnchantedLevel(stack)) * multiplier);
    }

    private static int getEnchantedLevel(ItemStack stack) {
        int level = 0;
        for (NBTBase nbt : stack.func_77986_q()) {
            NBTTagCompound compound;
            if (!(nbt instanceof NBTTagCompound) || Enchantment.func_185262_c((int)(compound = (NBTTagCompound)nbt).func_74765_d("id")) != enchantment) continue;
            level += compound.func_74765_d("lvl");
        }
        return level;
    }

    @Config(modid="parry")
    public static class ModConfig {
        @Config.Ignore
        private static final String config = "parry.";
        @Config.LangKey(value="parry.parry_window_arrow")
        @Config.RangeInt(min=0)
        public static int shieldParryTicksArrow = 40;
        @Config.LangKey(value="parry.parry_enchantment_bonus_arrow")
        @Config.RangeDouble(min=0.0)
        public static float shieldEnchantmentMultiplierArrow = 0.25f;
        @Config.LangKey(value="parry.parry_window_fireball")
        @Config.RangeInt(min=0)
        public static int shieldParryTicksFireball = 40;
        @Config.LangKey(value="parry.parry_enchantment_bonus_fireball")
        @Config.RangeDouble(min=0.0)
        public static float shieldEnchantmentMultiplierFireball = 0.25f;
        @Config.LangKey(value="parry.parry_window_throwable")
        @Config.RangeInt(min=0)
        public static int shieldParryTicksThrowable = 40;
        @Config.LangKey(value="parry.parry_enchantment_bonus_throwable")
        @Config.RangeDouble(min=0.0)
        public static float shieldEnchantmentMultiplierThrowable = 0.25f;
        @Config.LangKey(value="parry.parry_enchantment_max_level")
        @Config.RangeInt(min=0)
        public static int parryEnchantmentMaxLevel = 5;
    }

    private static class EnchantmentPrecision
    extends Enchantment {
        EnchantmentPrecision(Enchantment.Rarity rarityIn) {
            super(rarityIn, enchantmentTypeShield, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND});
        }

        public boolean canApplyAtEnchantingTable(ItemStack stack) {
            return stack.func_77973_b() instanceof ItemShield || stack.func_77973_b().isShield(stack, null);
        }

        public int func_77325_b() {
            return ModConfig.parryEnchantmentMaxLevel;
        }

        public boolean func_185261_e() {
            return true;
        }
    }
}

