/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.searedladder.common.block;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.smeltery.block.BlockEnumSmeltery;
import slimeknights.tconstruct.smeltery.block.BlockSearedGlass;

public class BlockSearedLadder
extends BlockEnumSmeltery<BlockSearedGlass.GlassType> {
    @Nonnull
    public static final PropertyBool BOTTOM = PropertyBool.func_177716_a((String)"bottom");
    @Nonnull
    public static final AxisAlignedBB BOTTOM_BOX = BlockSearedLadder.box(0.0, 0.0, 0.0, 16.0, 2.0, 16.0);
    @Nonnull
    public static final List<AxisAlignedBB> NORTH_BOX = ImmutableList.of((Object)BlockSearedLadder.box(0.0, 0.0, 2.0, 16.0, 16.0, 16.0), (Object)BlockSearedLadder.box(14.0, 0.0, 0.0, 16.0, 16.0, 2.0), (Object)BlockSearedLadder.box(0.0, 0.0, 0.0, 2.0, 16.0, 2.0));
    @Nonnull
    public static final List<AxisAlignedBB> SOUTH_BOX = ImmutableList.of((Object)BlockSearedLadder.box(0.0, 0.0, 0.0, 16.0, 16.0, 14.0), (Object)BlockSearedLadder.box(0.0, 0.0, 14.0, 2.0, 16.0, 16.0), (Object)BlockSearedLadder.box(14.0, 0.0, 14.0, 16.0, 16.0, 16.0));
    @Nonnull
    public static final List<AxisAlignedBB> EAST_BOX = ImmutableList.of((Object)BlockSearedLadder.box(0.0, 0.0, 0.0, 14.0, 16.0, 16.0), (Object)BlockSearedLadder.box(14.0, 0.0, 14.0, 16.0, 16.0, 16.0), (Object)BlockSearedLadder.box(14.0, 0.0, 0.0, 16.0, 16.0, 2.0));
    @Nonnull
    public static final List<AxisAlignedBB> WEST_BOX = ImmutableList.of((Object)BlockSearedLadder.box(2.0, 0.0, 0.0, 16.0, 16.0, 16.0), (Object)BlockSearedLadder.box(0.0, 0.0, 0.0, 2.0, 16.0, 2.0), (Object)BlockSearedLadder.box(0.0, 0.0, 14.0, 2.0, 16.0, 16.0));

    public BlockSearedLadder(@Nonnull Material material) {
        super(material, BlockSearedGlass.TYPE, BlockSearedGlass.GlassType.class);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockSearedGlass.TYPE, BOTTOM, BlockHorizontal.field_185512_D});
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176736_b() << 1 | ((Boolean)state.func_177229_b((IProperty)BOTTOM) != false ? 1 : 0);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BOTTOM, (Comparable)Boolean.valueOf((meta & 1) == 1)).func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.func_176731_b((int)(meta >> 1)));
    }

    @Nonnull
    public IBlockState func_180642_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)(placer.func_70093_af() ? placer.func_174811_aO() : placer.func_174811_aO().func_176734_d()));
        return state.func_177226_a((IProperty)BOTTOM, (Comparable)Boolean.valueOf(this.shouldBeBottom(state, worldIn.func_180495_p(pos.func_177977_b()))));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean doesSideBlockRendering(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return state.isSideSolid(world, pos, face);
    }

    public boolean isSideSolid(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        return state.func_193401_d(world, pos, side) == BlockFaceShape.SOLID;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        if (face == EnumFacing.DOWN && ((Boolean)state.func_177229_b((IProperty)BOTTOM)).booleanValue()) {
            return BlockFaceShape.SOLID;
        }
        return face.func_176740_k().func_176720_b() || state.func_177229_b((IProperty)BlockHorizontal.field_185512_D) == face ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tile.searedladder.seared_ladder.tooltip", (Object[])new Object[0]));
    }

    public void func_189540_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos) {
        boolean isBottom;
        if (pos.func_177977_b().equals((Object)fromPos) && (isBottom = ((Boolean)state.func_177229_b((IProperty)BOTTOM)).booleanValue()) != this.shouldBeBottom(state, worldIn.func_180495_p(fromPos))) {
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)BOTTOM, (Comparable)Boolean.valueOf(!isBottom)));
        }
    }

    public int func_180651_a(@Nonnull IBlockState state) {
        return 0;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public boolean isLadder(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityLivingBase entity) {
        return true;
    }

    public void func_185477_a(@Nonnull IBlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        this.getCollisionBoxList(state).forEach(aabb -> BlockSearedLadder.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, (List)collidingBoxes, (AxisAlignedBB)aabb));
    }

    @Nullable
    public RayTraceResult func_180636_a(@Nonnull IBlockState blockState, @Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        List list = this.getCollisionBoxList(blockState).stream().map(aabb -> this.func_185503_a(pos, start, end, (AxisAlignedBB)aabb)).filter(Objects::nonNull).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        RayTraceResult furthest = null;
        double dist = -1.0;
        for (RayTraceResult trace : list) {
            double newDist = trace.field_72307_f.func_72436_e(end);
            if (!(newDist > dist)) continue;
            furthest = trace;
            dist = newDist;
        }
        return furthest;
    }

    @Nonnull
    public List<AxisAlignedBB> getCollisionBoxList(@Nonnull IBlockState state) {
        ArrayList<AxisAlignedBB> collisions = new ArrayList<AxisAlignedBB>();
        switch ((EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)) {
            case NORTH: {
                collisions.addAll(NORTH_BOX);
                break;
            }
            case SOUTH: {
                collisions.addAll(SOUTH_BOX);
                break;
            }
            case EAST: {
                collisions.addAll(EAST_BOX);
                break;
            }
            case WEST: {
                collisions.addAll(WEST_BOX);
            }
        }
        if (((Boolean)state.func_177229_b((IProperty)BOTTOM)).booleanValue()) {
            collisions.add(BOTTOM_BOX);
        }
        return collisions;
    }

    public boolean shouldBeBottom(@Nonnull IBlockState state, @Nonnull IBlockState down) {
        return !this.func_149667_c(down.func_177230_c()) || down.func_177229_b((IProperty)BlockHorizontal.field_185512_D) != state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
    }

    @Nonnull
    static AxisAlignedBB box(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return new AxisAlignedBB(minX / 16.0, minY / 16.0, minZ / 16.0, maxX / 16.0, maxY / 16.0, maxZ / 16.0);
    }
}

