/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen.feature;

import java.util.Random;
import net.minecraft.block.BlockHardenedClay;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import vibrantjourneys.init.PVJBlocks;
import vibrantjourneys.util.EnumLeafType;
import vibrantjourneys.util.EnumWoodType;

public class WorldGenJacarandaTree
extends WorldGenAbstractTree {
    private IBlockState LOG = PVJBlocks.LOGS.get(EnumWoodType.JACARANDA.getID()).func_176223_P();
    private IBlockState LEAVES = PVJBlocks.LEAVES.get(EnumLeafType.JACARANDA.getID()).func_176223_P();

    public WorldGenJacarandaTree(boolean notify) {
        super(notify);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int i = rand.nextInt(4) + 5;
        while (world.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151586_h) {
            pos = pos.func_177977_b();
        }
        boolean flag = true;
        if (pos.func_177956_o() >= 1 && pos.func_177956_o() + i + 1 <= 256) {
            for (int j = pos.func_177956_o(); j <= pos.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == pos.func_177956_o()) {
                    k = 0;
                }
                if (j >= pos.func_177956_o() + 1 + i - 2) {
                    k = 3;
                }
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int l = pos.func_177958_n() - k; l <= pos.func_177958_n() + k && flag; ++l) {
                    for (int i1 = pos.func_177952_p() - k; i1 <= pos.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < 256) {
                            IBlockState iblockstate = world.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1));
                            if (iblockstate.func_177230_c().isAir(iblockstate, (IBlockAccess)world, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1)) || iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)world, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
        }
        if (!flag) {
            return false;
        }
        BlockPos down = pos.func_177977_b();
        IBlockState state = world.func_180495_p(down);
        boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, down, EnumFacing.UP, (IPlantable)Blocks.field_150345_g) || state.func_177230_c() instanceof BlockSand || state.func_177230_c() instanceof BlockHardenedClay;
        int height = 6 + rand.nextInt(5);
        if (isSoil && pos.func_177956_o() < world.func_72800_K() - height - 1) {
            int height1 = 2 + rand.nextInt(2);
            int height2 = height - (2 + rand.nextInt(2));
            EnumFacing facing1 = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
            EnumFacing facing2 = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
            BlockPos logPos = pos;
            if (this.canPlaceLog(world.func_180495_p(logPos), world, logPos)) {
                world.func_175656_a(logPos, this.LOG);
            }
            for (int x = 0; x < height; ++x) {
                logPos = logPos.func_177984_a();
                if (x == height1) {
                    if (this.canPlaceLog(world.func_180495_p(logPos), world, logPos)) {
                        world.func_175656_a(logPos, this.LOG);
                    }
                    logPos = logPos.func_177972_a(facing1);
                }
                if (x == height2) {
                    if (this.canPlaceLog(world.func_180495_p(logPos), world, logPos)) {
                        world.func_175656_a(logPos, this.LOG);
                    }
                    logPos = logPos.func_177972_a(facing2);
                }
                if (!this.canPlaceLog(world.func_180495_p(logPos), world, logPos)) continue;
                world.func_175656_a(logPos, this.LOG);
            }
            int branchCount = rand.nextBoolean() ? 3 : 4;
            boolean skipBranch = true;
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                if (skipBranch && rand.nextBoolean() && branchCount == 3) {
                    skipBranch = false;
                    continue;
                }
                if (skipBranch && branchCount == 3 && facing == EnumFacing.field_176754_o[3]) break;
                int branchLength = 3 + rand.nextInt(3);
                BlockPos branchPos = logPos;
                for (int b = 0; b < branchLength; ++b) {
                    branchPos = branchPos.func_177972_a(facing);
                    EnumFacing facingB = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
                    if (facingB != facing && rand.nextBoolean()) {
                        branchPos = branchPos.func_177972_a(facingB);
                    }
                    if (rand.nextInt(3) < 1) {
                        if (this.canPlaceLog(world.func_180495_p(branchPos), world, branchPos) && rand.nextBoolean()) {
                            world.func_175656_a(branchPos, this.LOG);
                        }
                        branchPos = branchPos.func_177984_a();
                    }
                    if (!this.canPlaceLog(world.func_180495_p(branchPos), world, branchPos)) continue;
                    world.func_175656_a(branchPos, this.LOG);
                    this.genLeaves(world, branchPos, rand);
                }
            }
        }
        return true;
    }

    public void genLeaves(World world, BlockPos pos, Random rand) {
        for (int x = -2; x <= 2; ++x) {
            for (int y = -1; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos leafPos = pos.func_177982_a(x, y, z);
                    if (!world.func_175623_d(leafPos)) continue;
                    if (Math.abs(x) == 2 || Math.abs(y) == 2 || Math.abs(z) == 2) {
                        if (rand.nextInt(16) <= 5) {
                            boolean shouldGenLeaves = false;
                            for (EnumFacing facing : EnumFacing.field_82609_l) {
                                IBlockState state = world.func_180495_p(leafPos.func_177972_a(facing));
                                if (!state.func_177230_c().isLeaves(state, (IBlockAccess)world, leafPos.func_177972_a(facing))) continue;
                                shouldGenLeaves = true;
                                break;
                            }
                            if (shouldGenLeaves) {
                                if (Math.abs(x) == Math.abs(z)) {
                                    if (rand.nextInt(4) == 0) {
                                        world.func_175656_a(leafPos, this.LEAVES);
                                    }
                                } else {
                                    world.func_175656_a(leafPos, this.LEAVES);
                                }
                            }
                        }
                    } else {
                        world.func_175656_a(leafPos, this.LEAVES);
                    }
                    if (rand.nextInt(8) >= 2) continue;
                    for (int i = 1; i < 2 + rand.nextInt(1); ++i) {
                        BlockPos tempPos = leafPos.func_177979_c(i);
                        if (!world.func_175623_d(tempPos)) continue;
                        world.func_175656_a(tempPos, this.LEAVES);
                    }
                }
            }
        }
    }

    public boolean canPlaceLog(IBlockState state, World world, BlockPos pos) {
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos);
    }
}

