/*
 * Decompiled with CFR 0.152.
 */
package vibrantjourneys.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import vibrantjourneys.blocks.BlockGroundCover;
import vibrantjourneys.init.PVJBlocks;
import vibrantjourneys.init.PVJWorldGen;
import vibrantjourneys.util.PVJConfig;

public class WorldGenFlowerPatch
implements IWorldGenerator {
    private int frequency;
    private Biome[] biomes;

    public WorldGenFlowerPatch(int frequency, Biome ... biomes) {
        this.biomes = biomes;
        this.frequency = (int)((double)frequency * ((double)PVJConfig.global.groundcoverDensity / 100.0));
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int i;
        Random rand = new Random();
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(x, 0, z));
        for (int id : PVJWorldGen.dimensionBlacklist) {
            if (PVJWorldGen.shouldGenHere(id, world)) continue;
            return;
        }
        boolean isValidBiome = false;
        for (i = 0; i < this.biomes.length; ++i) {
            if (biome != this.biomes[i]) continue;
            isValidBiome = true;
            break;
        }
        if (isValidBiome) {
            for (i = 0; i < this.frequency; ++i) {
                ChunkPos chunkPos = world.func_72964_e(chunkX, chunkZ).func_76632_l();
                int xPos = rand.nextInt(16) + 8;
                int zPos = rand.nextInt(16) + 8;
                int y = world.func_175645_m(chunkPos.func_180331_a(0, 0, 0).func_177982_a(xPos, 0, zPos)).func_177956_o() + random.nextInt(4) - random.nextInt(4);
                BlockPos pos = chunkPos.func_180331_a(0, 0, 0).func_177982_a(xPos, y, zPos);
                int model = random.nextInt(5);
                for (int j = 0; j < 5; ++j) {
                    BlockPos blockpos = pos.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
                    Block soil = world.func_180495_p(blockpos.func_177977_b()).func_177230_c();
                    boolean isSoil = false;
                    if (soil instanceof BlockGrass || soil instanceof BlockDirt) {
                        isSoil = true;
                    }
                    if (!world.func_175623_d(blockpos) || blockpos.func_177956_o() >= 255 || !isSoil) continue;
                    world.func_180501_a(blockpos, PVJBlocks.flower_patch.func_176223_P().func_177226_a((IProperty)BlockGroundCover.MODEL, (Comparable)Integer.valueOf(model)), 2);
                }
            }
        }
    }
}

